/*
 * Decompiled with CFR 0.152.
 */
package lux.xpath;

import lux.xml.ValueType;
import lux.xpath.AbstractExpression;
import lux.xpath.ExpressionVisitor;

public class BinaryOperation
extends AbstractExpression {
    private static final int MLT = 1;
    private static final int MEQ = 2;
    private static final int MGT = 4;
    private static final int MAND = 8;
    private static final int MOR = 16;
    private static final int MINTERSECT = 32;
    private static final int MUNION = 64;
    private static final int MEXCEPT = 128;
    private final Operator operator;

    public BinaryOperation(AbstractExpression op1, Operator operator, AbstractExpression op2) {
        super(AbstractExpression.Type.BINARY_OPERATION);
        this.setSubs(op1, op2);
        this.operator = operator;
    }

    @Override
    public void toString(StringBuilder buf) {
        this.appendSub(buf, this.subs[0]);
        buf.append(' ').append((Object)this.operator).append(' ');
        this.appendSub(buf, this.subs[1]);
    }

    public AbstractExpression getOperand1() {
        return this.subs[0];
    }

    public AbstractExpression getOperand2() {
        return this.subs[1];
    }

    public Operator getOperator() {
        return this.operator;
    }

    @Override
    public AbstractExpression accept(ExpressionVisitor visitor) {
        super.acceptSubs(visitor);
        return visitor.visit(this);
    }

    @Override
    public boolean isDocumentOrdered() {
        return this.operator.getResultType().isNode && super.isDocumentOrdered();
    }

    @Override
    public int getPrecedence() {
        return this.operator.precedence;
    }

    @Override
    protected boolean propEquals(AbstractExpression other) {
        return this.operator == ((BinaryOperation)other).operator;
    }

    @Override
    public boolean propGreaterEqual(AbstractExpression other) {
        Operator op2 = ((BinaryOperation)other).operator;
        return this.operator == op2 || op2.rangeMask != 0 && (this.operator.rangeMask & op2.rangeMask) == op2.rangeMask;
    }

    @Override
    public int equivHash() {
        return 13 + this.operator.ordinal();
    }

    @Override
    public boolean isRestrictive() {
        return this.operator == Operator.AND || this.operator == Operator.INTERSECT;
    }

    public static enum Operator {
        AND("and", ValueType.BOOLEAN, 5, 8),
        OR("or", ValueType.BOOLEAN, 4, 24),
        INTERSECT("intersect", ValueType.VALUE, 11, 32),
        EXCEPT("except", ValueType.VALUE, 11, 128),
        UNION("|", ValueType.VALUE, 10, 224),
        ADD("+", ValueType.ATOMIC, 8),
        SUB("-", ValueType.ATOMIC, 8),
        MUL("*", ValueType.ATOMIC, 9),
        DIV("div", ValueType.ATOMIC, 9),
        IDIV("idiv", ValueType.ATOMIC, 9),
        MOD("mod", ValueType.ATOMIC, 9),
        EQUALS("=", ValueType.BOOLEAN, 6, 2),
        NE("!=", ValueType.BOOLEAN, 6, 5),
        LT("<", ValueType.BOOLEAN, 6, 1),
        LE("<=", ValueType.BOOLEAN, 6, 3),
        GT(">", ValueType.BOOLEAN, 6, 4),
        GE(">=", ValueType.BOOLEAN, 6, 6),
        AEQ("eq", ValueType.BOOLEAN, 6, 2),
        ANE("ne", ValueType.BOOLEAN, 6, 5),
        ALT("lt", ValueType.BOOLEAN, 6, 1),
        ALE("le", ValueType.BOOLEAN, 6, 3),
        AGT("gt", ValueType.BOOLEAN, 6, 4),
        AGE("ge", ValueType.BOOLEAN, 6, 6),
        IS("is", ValueType.BOOLEAN, 6),
        BEFORE("<<", ValueType.BOOLEAN, 6),
        AFTER(">>", ValueType.BOOLEAN, 6),
        TO("to", ValueType.ATOMIC, 7);

        private String token;
        private ValueType resultType;
        private int precedence;
        private int rangeMask;

        private Operator(String token, ValueType resultType, int precedence) {
            this(token, resultType, precedence, 0);
        }

        private Operator(String token, ValueType resultType, int precedence, int rangeMask) {
            this.token = token;
            this.resultType = resultType;
            this.precedence = precedence;
        }

        public String toString() {
            return this.token;
        }

        public ValueType getResultType() {
            return this.resultType;
        }

        public int getPrecedence() {
            return this.precedence;
        }
    }
}

