/*
 * Decompiled with CFR 0.152.
 */
package lux.xquery;

import lux.xpath.AbstractExpression;
import lux.xpath.LiteralExpression;
import lux.xpath.Namespace;
import lux.xquery.FunctionDefinition;
import lux.xquery.ModuleImport;
import lux.xquery.VariableDefinition;
import org.apache.commons.lang.StringUtils;

public class XQuery {
    private final FunctionDefinition[] functionDefinitions;
    private final Namespace[] namespaceDeclarations;
    private final String defaultElementNamespace;
    private final String defaultFunctionNamespace;
    private final String defaultCollation;
    private final VariableDefinition[] externalVariables;
    private final ModuleImport[] importedModules;
    private final AbstractExpression body;
    private final String baseURI;
    private final Boolean preserveNamespaces;
    private final Boolean inheritNamespaces;
    private final boolean emptyLeast;

    public XQuery(String defaultElementNamespace, String defaultFunctionNamespace, String defaultCollation, ModuleImport[] importedModules, Namespace[] namespaceDeclarations, VariableDefinition[] variableDefinitions, FunctionDefinition[] defs, AbstractExpression body, String baseURI, Boolean copyNamespacesPreserve, Boolean copyNamespacesInherit, boolean emptyLeast) {
        this.namespaceDeclarations = namespaceDeclarations;
        this.externalVariables = variableDefinitions;
        this.defaultCollation = defaultCollation;
        this.defaultElementNamespace = defaultElementNamespace;
        this.defaultFunctionNamespace = defaultFunctionNamespace;
        this.functionDefinitions = defs;
        this.body = body;
        this.baseURI = baseURI;
        this.inheritNamespaces = copyNamespacesInherit;
        this.preserveNamespaces = copyNamespacesPreserve;
        this.emptyLeast = emptyLeast;
        this.importedModules = importedModules;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString(buf);
        return buf.toString();
    }

    public void toString(StringBuilder buf) {
        if (this.inheritNamespaces != null || this.preserveNamespaces != null) {
            buf.append("declare copy-namespaces ");
            if (this.preserveNamespaces == null || !this.preserveNamespaces.booleanValue()) {
                buf.append("no-preserve, ");
            } else {
                buf.append("preserve, ");
            }
            if (this.inheritNamespaces == null || this.inheritNamespaces.booleanValue()) {
                buf.append("inherit");
            } else {
                buf.append("no-inherit");
            }
            buf.append(";\n");
        }
        if (this.baseURI != null) {
            buf.append("declare base-uri ");
            LiteralExpression.quoteString(this.baseURI, buf);
            buf.append(";\n");
        }
        if (StringUtils.isNotBlank((String)this.defaultCollation)) {
            buf.append("declare default collation ");
            LiteralExpression.quoteString(this.defaultCollation, buf);
            buf.append(";\n");
        }
        if (!this.emptyLeast) {
            buf.append("declare default order empty greatest;\n");
        }
        if (StringUtils.isNotBlank((String)this.defaultElementNamespace)) {
            buf.append("declare default element namespace ");
            LiteralExpression.quoteString(this.defaultElementNamespace, buf);
            buf.append(";\n");
        }
        if (StringUtils.isNotBlank((String)this.defaultFunctionNamespace) && !this.defaultFunctionNamespace.equals("http://www.w3.org/2005/xpath-functions")) {
            buf.append("declare default function namespace ");
            LiteralExpression.quoteString(this.defaultFunctionNamespace, buf);
            buf.append(";\n");
        }
        if (this.namespaceDeclarations != null) {
            block0: for (Namespace namespace : this.namespaceDeclarations) {
                if (namespace.getPrefix().isEmpty() || "xml".equals(namespace.getPrefix())) continue;
                for (ModuleImport importedModule : this.importedModules) {
                    if (importedModule.getPrefix().equals(namespace.getPrefix())) continue block0;
                }
                buf.append("declare namespace ").append(namespace.getPrefix()).append('=');
                LiteralExpression.quoteString(namespace.getNamespace(), buf);
                buf.append(";\n");
            }
        }
        if (this.importedModules != null) {
            for (ModuleImport moduleImport : this.importedModules) {
                moduleImport.toString(buf);
            }
        }
        if (this.externalVariables != null) {
            for (VariableDefinition variableDefinition : this.externalVariables) {
                variableDefinition.toString(buf);
            }
        }
        if (this.functionDefinitions != null) {
            for (FunctionDefinition functionDefinition : this.functionDefinitions) {
                functionDefinition.toString(buf);
            }
        }
        this.body.toString(buf);
    }

    public AbstractExpression getBody() {
        return this.body;
    }

    public FunctionDefinition[] getFunctionDefinitions() {
        return this.functionDefinitions;
    }

    public Namespace[] getNamespaceDeclarations() {
        return this.namespaceDeclarations;
    }

    public VariableDefinition[] getVariableDefinitions() {
        return this.externalVariables;
    }

    public String getDefaultCollation() {
        return this.defaultCollation;
    }

    public String getDefaultElementNamespace() {
        return this.defaultElementNamespace;
    }

    public String getDefaultFunctionNamespace() {
        return this.defaultFunctionNamespace;
    }

    public Boolean isPreserveNamespaces() {
        return this.preserveNamespaces;
    }

    public Boolean isInheritNamespaces() {
        return this.inheritNamespaces;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public boolean isEmptyLeast() {
        return this.emptyLeast;
    }

    public ModuleImport[] getModuleImports() {
        return this.importedModules;
    }
}

