/*
 * Decompiled with CFR 0.152.
 */
package lux;

import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import lux.CachingDocReader;
import lux.exception.NotFoundException;
import lux.search.DocIterator;
import lux.search.LuxSearcher;
import net.sf.saxon.s9api.XdmNode;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class LuxURIResolver
implements URIResolver {
    private final URIResolver systemURIResolver;
    private final LuxSearcher searcher;
    private final CachingDocReader docReader;
    private final String uriFieldName;

    LuxURIResolver(URIResolver systemURIResolver, LuxSearcher searcher, CachingDocReader docReader, String uriFieldName) {
        this.systemURIResolver = systemURIResolver;
        this.searcher = searcher;
        this.docReader = docReader;
        this.uriFieldName = uriFieldName;
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        boolean isFile;
        String path = href;
        if (href.matches("^\\w+:.*$")) {
            isFile = href.startsWith("file:");
            if (isFile) {
                path = href.substring(5);
            } else if (href.startsWith("lux:/")) {
                path = href.substring(5);
            }
        } else {
            isFile = base != null ? base.startsWith("file:") : false;
        }
        if (isFile) {
            return this.systemURIResolver.resolve(path, base);
        }
        if (this.searcher == null) {
            throw new IllegalStateException("Attempted search, but no searcher was provided");
        }
        path = path.replace('\\', '/');
        try {
            DocIterator disi = this.searcher.search((Query)new TermQuery(new Term(this.uriFieldName, path)));
            int docID = disi.nextDoc();
            if (docID == Integer.MAX_VALUE) {
                throw new NotFoundException(href);
            }
            XdmNode doc = this.docReader.get(docID, disi.getCurrentReaderContext());
            return doc.asSource();
        }
        catch (IOException e) {
            throw new TransformerException(e);
        }
    }
}

