/*
 * Decompiled with CFR 0.152.
 */
package lux.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import lux.Compiler;
import lux.SearchResultIterator;
import lux.compiler.SlopCounter;
import lux.compiler.VarBinding;
import lux.compiler.XPathQuery;
import lux.exception.LuxException;
import lux.index.FieldName;
import lux.index.IndexConfiguration;
import lux.index.field.FieldDefinition;
import lux.query.BooleanPQuery;
import lux.query.NodeTextQuery;
import lux.query.ParseableQuery;
import lux.query.RangePQuery;
import lux.query.SpanTermPQuery;
import lux.query.TermPQuery;
import lux.xml.QName;
import lux.xml.ValueType;
import lux.xpath.AbstractExpression;
import lux.xpath.BinaryOperation;
import lux.xpath.Dot;
import lux.xpath.ExpressionVisitorBase;
import lux.xpath.FunCall;
import lux.xpath.LiteralExpression;
import lux.xpath.NodeTest;
import lux.xpath.PathExpression;
import lux.xpath.PathStep;
import lux.xpath.Predicate;
import lux.xpath.Root;
import lux.xpath.SearchCall;
import lux.xpath.Sequence;
import lux.xpath.Subsequence;
import lux.xquery.FLWOR;
import lux.xquery.FLWORClause;
import lux.xquery.ForClause;
import lux.xquery.FunctionDefinition;
import lux.xquery.LetClause;
import lux.xquery.OrderByClause;
import lux.xquery.SortKey;
import lux.xquery.Variable;
import lux.xquery.VariableBindingClause;
import lux.xquery.VariableContext;
import lux.xquery.WhereClause;
import lux.xquery.XQuery;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathOptimizer
extends ExpressionVisitorBase {
    private final ArrayList<XPathQuery> queryStack = new ArrayList();
    private final ArrayList<XPathQuery> rangeQueries = new ArrayList();
    private final HashMap<QName, VarBinding> varBindings = new HashMap();
    private final IndexConfiguration indexConfig;
    private final Compiler compiler;
    private final XPathQuery MATCH_ALL;
    private final String attrQNameField;
    private final String elementQNameField;
    private boolean optimizeForOrderedResults;
    private Logger log;
    private static final boolean DEBUG = false;

    public PathOptimizer(Compiler compiler) {
        this.compiler = compiler;
        this.indexConfig = compiler.getIndexConfiguration();
        this.MATCH_ALL = XPathQuery.getMatchAllQuery(this.indexConfig);
        this.attrQNameField = this.indexConfig.getFieldName(FieldName.ATT_QNAME);
        this.elementQNameField = this.indexConfig.getFieldName(FieldName.ELT_QNAME);
        this.optimizeForOrderedResults = true;
        this.log = LoggerFactory.getLogger(PathOptimizer.class);
    }

    public XQuery optimize(XQuery query) {
        this.queryStack.clear();
        this.push(XPathQuery.MATCH_ALL);
        AbstractExpression main = query.getBody();
        if (main != null) {
            main = this.indexConfig.isIndexingEnabled() ? this.optimize(main) : main.replaceRoot(new FunCall(FunCall.FN_COLLECTION, ValueType.DOCUMENT, new AbstractExpression[0]));
            return new XQuery(query.getDefaultElementNamespace(), query.getDefaultFunctionNamespace(), query.getDefaultCollation(), query.getModuleImports(), query.getNamespaceDeclarations(), query.getVariableDefinitions(), this.optimizeFunctionDefinitions(query.getFunctionDefinitions()), main, query.getBaseURI(), query.isPreserveNamespaces(), query.isInheritNamespaces(), query.isEmptyLeast());
        }
        return query;
    }

    private FunctionDefinition[] optimizeFunctionDefinitions(FunctionDefinition[] functionDefinitions) {
        for (int i = 0; i < functionDefinitions.length; ++i) {
            FunctionDefinition function = functionDefinitions[i];
            for (AbstractExpression var : function.getSubs()) {
                this.setUnboundVariable((Variable)var);
            }
            AbstractExpression body = this.optimize(function.getBody());
            functionDefinitions[i] = function = new FunctionDefinition(function.getName(), function.getReturnType(), function.getCardinality(), function.getReturnTypeName(), (Variable[])function.getSubs(), body);
            for (AbstractExpression var : function.getSubs()) {
                this.descopeVariable(((Variable)var).getQName());
            }
        }
        return functionDefinitions;
    }

    public AbstractExpression optimize(AbstractExpression expr) {
        expr = expr.accept(this);
        return this.optimizeExpression(expr, this.peek());
    }

    private AbstractExpression optimizeExpression(AbstractExpression expr, int i) {
        int j = this.queryStack.size() - i - 1;
        return this.optimizeExpression(expr, this.queryStack.get(j));
    }

    private AbstractExpression optimizeExpression(AbstractExpression expr, XPathQuery query) {
        AbstractExpression tail;
        if (expr instanceof SearchCall) {
            return this.mergeSearchCall((SearchCall)expr, query);
        }
        if (!expr.isAbsolute()) {
            return expr;
        }
        AbstractExpression root = expr.getRoot();
        FunCall search = root instanceof FunCall ? (FunCall)root : this.createSearchCall(FunCall.LUX_SEARCH, query);
        if (query.getResultType().equals((Object)ValueType.DOCUMENT) && search.getReturnType().equals((Object)ValueType.DOCUMENT) && root == expr.getHead() && (tail = expr.getTail()) != null) {
            return new Predicate(search, tail);
        }
        if (root instanceof Root) {
            for (Map.Entry<QName, VarBinding> entry : this.varBindings.entrySet()) {
                VarBinding binding = entry.getValue();
                if (binding.getExpr() != root) continue;
                this.varBindings.put(entry.getKey(), new VarBinding(binding.getVar(), search, binding.getQuery(), binding.getContext(), binding.getShadowedBinding()));
            }
            return expr.replaceRoot(search);
        }
        return expr;
    }

    private void optimizeSubExpressions(AbstractExpression expr) {
        AbstractExpression[] subs = expr.getSubs();
        for (int i = 0; i < subs.length; ++i) {
            subs[i] = this.optimizeExpression(subs[i], subs.length - i - 1);
        }
    }

    private void combineTopQueries(int n, BooleanClause.Occur occur) {
        this.combineTopQueries(n, occur, null);
    }

    private void combineTopQueries(int n, BooleanClause.Occur occur, ValueType valueType) {
        if (n <= 0) {
            this.push(XPathQuery.MATCH_ALL);
            return;
        }
        XPathQuery query = this.pop();
        if (n == 1) {
            ValueType type = valueType == null ? query.getResultType() : query.getResultType().promote(valueType);
            query = XPathQuery.getQuery(query.getBooleanQuery(), query.getPathQuery(), query.getFacts(), type, this.indexConfig, query.getSortFields());
        } else {
            for (int i = 0; i < n - 1; ++i) {
                query = this.combineQueries(this.pop(), occur, query, valueType);
            }
        }
        if (valueType == ValueType.DOCUMENT) {
            query.setFact(4, true);
        }
        this.push(query);
    }

    public XPathQuery peek() {
        return this.queryStack.size() == 0 ? null : this.queryStack.get(this.queryStack.size() - 1);
    }

    void push(XPathQuery query) {
        this.queryStack.add(query);
    }

    XPathQuery pop() {
        return this.queryStack.remove(this.queryStack.size() - 1);
    }

    private void debug(String tag, AbstractExpression expr) {
        for (int i = 0; i < this.queryStack.size(); ++i) {
            System.err.print(' ');
        }
        String desc = expr.toString();
        if (desc.length() > 30) {
            desc = desc.substring(0, 30);
            desc = desc.replaceAll("\\s+", " ");
        }
        System.err.println(tag + ' ' + (Object)((Object)expr.getType()) + ' ' + desc + "  depth=" + this.queryStack.size() + ", query: " + this.peek());
    }

    @Override
    public AbstractExpression visit(Root expr) {
        this.push(this.MATCH_ALL);
        return expr;
    }

    @Override
    public AbstractExpression visit(PathExpression pathExpr) {
        XPathQuery rq = this.pop();
        XPathQuery lq = this.pop();
        XPathQuery query = this.combineAdjacentQueries(pathExpr.getLHS(), pathExpr.getRHS(), lq, rq, ResultOrientation.RIGHT);
        this.push(query);
        return pathExpr;
    }

    @Override
    public AbstractExpression visit(Predicate predicate) {
        AbstractExpression filter = predicate.getFilter();
        predicate.setFilter(this.optimizeExpression(filter, this.peek()));
        XPathQuery filterQuery = this.pop();
        XPathQuery baseQuery = this.pop();
        if (filter.equals(LiteralExpression.TRUE)) {
            this.push(baseQuery);
            return predicate.getBase();
        }
        XPathQuery query = this.combineAdjacentQueries(predicate.getBase(), filter, baseQuery, filterQuery, ResultOrientation.LEFT);
        ParseableQuery contextQuery = baseQuery.getPathQuery();
        query.setPathQuery(contextQuery);
        this.push(query);
        this.peek().setFact(4, baseQuery.isFact(4));
        return predicate;
    }

    private XPathQuery combineAdjacentQueries(AbstractExpression left, AbstractExpression right, XPathQuery lq, XPathQuery rq, ResultOrientation orient) {
        AbstractExpression binding;
        Integer rSlop = null;
        Integer lSlop = null;
        if (left instanceof Variable && (binding = this.getBoundExpression(((Variable)left).getQName())) != null) {
            left = binding;
        }
        if (this.indexConfig.isOption(64)) {
            SlopCounter slopCounter = new SlopCounter();
            right.accept(slopCounter);
            rSlop = slopCounter.getSlop();
            if (rSlop != null) {
                slopCounter.reset();
                slopCounter.setReverse(true);
                left.accept(slopCounter);
                lSlop = slopCounter.getSlop();
            }
        }
        ValueType resultType = orient == ResultOrientation.RIGHT ? rq.getResultType() : lq.getResultType();
        boolean isPredicate = orient == ResultOrientation.LEFT;
        int slop = rSlop != null && lSlop != null ? rSlop + lSlop : -1;
        XPathQuery query = lq.combineSpanQueries(rq, BooleanClause.Occur.MUST, isPredicate, resultType, slop, this.indexConfig);
        return query;
    }

    @Override
    public AbstractExpression visit(PathStep step) {
        XPathQuery query;
        boolean isMinimal;
        QName name = step.getNodeTest().getQName();
        PathStep.Axis axis = step.getAxis();
        XPathQuery currentQuery = this.peek();
        boolean isSingular = currentQuery.isFact(4);
        if (axis == PathStep.Axis.Descendant || axis == PathStep.Axis.DescendantSelf || axis == PathStep.Axis.Attribute) {
            isMinimal = !step.getNodeTest().isWild() || currentQuery.isEmpty();
            if (axis != PathStep.Axis.Attribute) {
                isSingular = false;
            }
        } else {
            boolean isElementStep = step.getNodeTest().getType().is(ValueType.ELEMENT);
            if (axis == PathStep.Axis.Child) {
                boolean isPathIndexed = this.indexConfig.isOption(64);
                ValueType type = currentQuery.getResultType();
                boolean currentMinimal = currentQuery.isFact(2);
                if (ValueType.NODE.is(type)) {
                    isMinimal = currentMinimal;
                    isSingular = false;
                } else if (ValueType.DOCUMENT == type) {
                    isMinimal = isPathIndexed && currentMinimal || step.getNodeTest().isWild();
                    isSingular = (isPathIndexed || step.getNodeTest().isWild()) && isElementStep;
                } else {
                    isMinimal = isPathIndexed && isElementStep && currentMinimal;
                    isSingular = false;
                }
            } else if (axis == PathStep.Axis.Ancestor || axis == PathStep.Axis.AncestorSelf || axis == PathStep.Axis.Self) {
                isMinimal = !step.getNodeTest().isWild() || currentQuery.isEmpty() || !isElementStep;
                isSingular = false;
            } else {
                isMinimal = false;
            }
        }
        long facts = currentQuery.getFacts() & 0xFFFFFFFFFFFFFFBFL & 0xFFFFFFFFFFFFFFDFL;
        facts = !isSingular ? (facts &= 0xFFFFFFFFFFFFFFFBL) : (facts |= 4L);
        if (!isMinimal) {
            facts &= 0xFFFFFFFFFFFFFFFDL;
        }
        if (name == null) {
            ValueType type = step.getNodeTest().getType();
            if (axis == PathStep.Axis.Self && (type == ValueType.NODE || type == ValueType.VALUE)) {
                type = currentQuery.getResultType();
            } else if (axis == PathStep.Axis.AncestorSelf && (type == ValueType.NODE || type == ValueType.VALUE) && currentQuery.getResultType() == ValueType.DOCUMENT) {
                type = ValueType.DOCUMENT;
            }
            query = XPathQuery.getQuery(this.MATCH_ALL.getBooleanQuery(), null, facts, type, this.indexConfig, currentQuery.getSortFields());
        } else {
            ParseableQuery termQuery = this.nodeNameTermQuery(step.getAxis(), name);
            query = XPathQuery.getQuery(termQuery, facts, step.getNodeTest().getType(), this.indexConfig, currentQuery.getSortFields());
        }
        this.push(query);
        return step;
    }

    @Override
    public AbstractExpression visit(FunCall funcall) {
        QName name = funcall.getName();
        AbstractExpression luxfunc = this.optimizeFunCall(funcall);
        if (luxfunc != funcall) {
            return luxfunc;
        }
        this.optimizeSubExpressions(funcall);
        BooleanClause.Occur occur = BooleanClause.Occur.SHOULD;
        if (name.equals(FunCall.FN_CONTAINS)) {
            if (this.optimizeFnContains(funcall)) {
                occur = BooleanClause.Occur.MUST;
            }
        } else if (name.equals(FunCall.FN_ROOT) || name.equals(FunCall.FN_DATA) || name.equals(FunCall.FN_EXISTS) || name.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
            occur = BooleanClause.Occur.MUST;
        }
        AbstractExpression[] args = funcall.getSubs();
        this.combineTopQueries(args.length, occur, funcall.getReturnType());
        if (occur == BooleanClause.Occur.SHOULD) {
            XPathQuery argq = this.pop();
            argq = argq.setFact(32, true);
            argq = argq.setFact(2, false);
            this.push(argq);
        }
        if ((name.equals(FunCall.LUX_KEY) || name.equals(FunCall.LUX_FIELD_VALUES)) && args.length > 0) {
            AbstractExpression sortContext;
            AbstractExpression arg = args[0];
            if (args.length > 1) {
                sortContext = args[1];
            } else {
                sortContext = funcall.getSuper();
                if (sortContext == null) {
                    return funcall;
                }
            }
            VariableContext binding = sortContext.getBindingContext();
            if (binding == null || !(binding instanceof ForClause)) {
                return funcall;
            }
            if (arg.getType() == AbstractExpression.Type.LITERAL) {
                SortField.Type sortType;
                String fieldName = ((LiteralExpression)arg).getValue().toString();
                FieldDefinition fieldDefinition = this.indexConfig.getField(fieldName);
                if (fieldDefinition != null) {
                    sortType = fieldDefinition.getType().getLuceneSortFieldType();
                } else {
                    sortType = FieldDefinition.Type.STRING.getLuceneSortFieldType();
                    this.log.warn("Sorting by unknown field: {}", (Object)fieldName);
                }
                this.peek().setSortFields(new SortField[]{new SortField(fieldName, sortType)});
            }
        }
        return funcall;
    }

    private AbstractExpression optimizeFunCall(FunCall funcall) {
        AbstractExpression[] subs = funcall.getSubs();
        QName fname = funcall.getName();
        AbstractExpression searchArg = null;
        if (subs.length == 1 && this.isSearchCall(subs[0])) {
            if (fname.equals(FunCall.FN_COUNT) || fname.equals(FunCall.FN_EXISTS) || fname.equals(FunCall.FN_EMPTY)) {
                searchArg = subs[0].getSubs()[0];
            }
        } else {
            if (fname.equals(FunCall.LUX_SEARCH) && !(funcall instanceof SearchCall)) {
                if (subs.length == 1) {
                    return new SearchCall(subs[0]);
                }
                return funcall;
            }
            if (subs.length == 1 && !subs[0].isAbsolute()) {
                return funcall;
            }
        }
        if (fname.equals(FunCall.FN_COLLECTION) && subs.length == 0) {
            this.push(XPathQuery.MATCH_ALL);
            return new Root();
        }
        XPathQuery query = this.pop();
        if (searchArg != null || query.isMinimal()) {
            int functionFacts = 0;
            ValueType returnType = null;
            QName qname = null;
            if (fname.equals(FunCall.FN_COUNT) && query.isFact(4)) {
                functionFacts = 4;
                returnType = ValueType.INT;
                qname = FunCall.LUX_COUNT;
            } else if (fname.equals(FunCall.FN_EXISTS)) {
                returnType = ValueType.BOOLEAN;
                qname = FunCall.LUX_EXISTS;
            } else if (fname.equals(FunCall.FN_EMPTY)) {
                functionFacts = 16;
                returnType = ValueType.BOOLEAN;
                qname = FunCall.LUX_EXISTS;
            }
            if (qname != null) {
                if (searchArg != null) {
                    this.push(XPathQuery.MATCH_ALL);
                    return new FunCall(qname, returnType, searchArg);
                }
                query = query.setType(returnType);
                query = query.setFact(functionFacts, true);
                AbstractExpression root = subs[0].getRoot();
                if (!this.isSearchCall(root)) {
                    this.push(XPathQuery.MATCH_ALL);
                    return this.createSearchCall(qname, query);
                }
            }
        }
        this.push(query);
        return funcall;
    }

    private boolean isSearchCall(AbstractExpression root) {
        return root instanceof SearchCall || root instanceof FunCall && ((FunCall)root).getName().equals(FunCall.LUX_SEARCH);
    }

    private XPathQuery combineQueries(XPathQuery lq, BooleanClause.Occur occur, XPathQuery rq, ValueType resultType) {
        XPathQuery query = this.indexConfig.isOption(64) ? lq.combineSpanQueries(rq, occur, false, resultType, -1, this.indexConfig) : lq.combineBooleanQueries(occur, rq, occur, resultType, this.indexConfig);
        return query;
    }

    private ParseableQuery nodeNameTermQuery(PathStep.Axis axis, QName name) {
        String nodeName = name.getEncodedName();
        if (this.indexConfig.isOption(64)) {
            if (axis == PathStep.Axis.Attribute) {
                nodeName = '@' + nodeName;
            }
            Term term = new Term(this.indexConfig.getFieldName(FieldName.PATH), nodeName);
            return new SpanTermPQuery(term);
        }
        String fieldName = axis == PathStep.Axis.Attribute ? this.attrQNameField : this.elementQNameField;
        Term term = new Term(fieldName, nodeName);
        return new TermPQuery(term);
    }

    @Override
    public AbstractExpression visit(Dot dot) {
        this.push(this.MATCH_ALL);
        return dot;
    }

    @Override
    public AbstractExpression visit(BinaryOperation op) {
        this.optimizeSubExpressions(op);
        XPathQuery rq = this.pop();
        XPathQuery lq = this.pop();
        ValueType argType = lq.getResultType().promote(rq.getResultType());
        ValueType resultType = null;
        BooleanClause.Occur occur = BooleanClause.Occur.SHOULD;
        boolean minimal = false;
        boolean required = false;
        AbstractExpression rangeOptimized = null;
        switch (op.getOperator()) {
            case AND: {
                occur = BooleanClause.Occur.MUST;
            }
            case OR: {
                minimal = true;
                required = true;
                resultType = ValueType.BOOLEAN;
                break;
            }
            case ADD: 
            case SUB: 
            case DIV: 
            case MUL: 
            case IDIV: 
            case MOD: {
                resultType = ValueType.ATOMIC;
                break;
            }
            case AEQ: 
            case ANE: 
            case ALT: 
            case ALE: 
            case AGT: 
            case AGE: 
            case EQUALS: 
            case NE: 
            case LT: 
            case GT: 
            case LE: 
            case GE: {
                if (lq.getResultType().isNode || rq.getResultType().isNode) {
                    required = true;
                    occur = BooleanClause.Occur.MUST;
                }
                rangeOptimized = this.optimizeRangeComparison(lq, rq, op);
                resultType = ValueType.BOOLEAN;
                break;
            }
            case IS: 
            case BEFORE: 
            case AFTER: {
                required = true;
                resultType = ValueType.BOOLEAN;
                break;
            }
            case INTERSECT: {
                occur = BooleanClause.Occur.MUST;
            }
            case UNION: {
                minimal = true;
                required = true;
                resultType = argType;
                break;
            }
            case EXCEPT: {
                this.push(this.combineQueries(lq, BooleanClause.Occur.MUST, rq, argType));
                resultType = argType;
                required = true;
                return op;
            }
            case TO: {
                resultType = ValueType.INTEGER;
            }
        }
        XPathQuery query = this.combineQueries(lq, occur, rq, resultType);
        if (rangeOptimized != null) {
            query.setFact(6, true);
            query.setFact(32, false);
            this.push(query);
        } else {
            if (!minimal) {
                query = query.setFact(2, false);
            }
            if (!required) {
                query = query.setFact(32, true);
            }
            this.push(query);
            if (op.getOperator() == BinaryOperation.Operator.EQUALS || op.getOperator() == BinaryOperation.Operator.AEQ) {
                this.optimizeBinaryOperation(op);
            }
        }
        return rangeOptimized == null ? op : rangeOptimized;
    }

    private AbstractExpression optimizeRangeComparison(XPathQuery lq, XPathQuery rq, BinaryOperation op) {
        ParseableQuery rangeQuery;
        boolean directKeyMatch;
        FieldDefinition field;
        LiteralExpression value = null;
        AbstractExpression op1 = op.getOperand1();
        AbstractExpression op2 = op.getOperand2();
        AbstractExpression expr = null;
        if (op1.getType() == AbstractExpression.Type.LITERAL) {
            value = (LiteralExpression)op1;
            expr = op2;
        } else if (op2.getType() == AbstractExpression.Type.LITERAL) {
            value = (LiteralExpression)op2;
            expr = op1;
        } else {
            return null;
        }
        if (expr.getType() == AbstractExpression.Type.VARIABLE) {
            VarBinding varBinding = this.varBindings.get(((Variable)expr).getQName());
            if (varBinding == null) {
                return null;
            }
            if (expr == op1) {
                lq = varBinding.getQuery();
            } else {
                rq = varBinding.getQuery();
            }
            expr = varBinding.getExpr();
            if (expr == null) {
                return null;
            }
        }
        if ((field = this.fieldMatching(expr = this.rewriteMinMax(expr))) != null) {
            directKeyMatch = true;
        } else {
            directKeyMatch = false;
            field = this.matchField(expr, op);
        }
        if (field == null) {
            return null;
        }
        FieldDefinition.Type fieldType = field.getType();
        if (!this.isComparableType(value.getValueType(), fieldType)) {
            return null;
        }
        String fieldName = this.indexConfig.getFieldName(field);
        RangePQuery.Type rangeTermType = fieldType.getRangeTermType();
        String v = value.getValue().toString();
        BinaryOperation.Operator operator = op.getOperator();
        switch (operator) {
            case AEQ: 
            case ANE: 
            case EQUALS: 
            case NE: {
                rangeQuery = "string".equals((Object)rangeTermType) ? new TermPQuery(new Term(fieldName, v)) : new RangePQuery(fieldName, rangeTermType, v, v, true, true);
                if (operator != BinaryOperation.Operator.ANE && operator != BinaryOperation.Operator.NE) break;
                rangeQuery = new BooleanPQuery(BooleanClause.Occur.MUST_NOT, rangeQuery);
                break;
            }
            case ALE: 
            case LE: {
                rangeQuery = new RangePQuery(fieldName, rangeTermType, null, v, false, true);
                break;
            }
            case ALT: 
            case LT: {
                rangeQuery = new RangePQuery(fieldName, rangeTermType, null, v, false, false);
                break;
            }
            case AGE: 
            case GE: {
                rangeQuery = new RangePQuery(fieldName, rangeTermType, v, null, true, false);
                break;
            }
            case AGT: 
            case GT: {
                rangeQuery = new RangePQuery(fieldName, rangeTermType, v, null, false, false);
                break;
            }
            default: {
                return null;
            }
        }
        this.rangeQueries.add(new XPathQuery(rangeQuery, 6L, ValueType.BOOLEAN));
        return directKeyMatch ? LiteralExpression.TRUE : op;
    }

    private FieldDefinition matchField(AbstractExpression expr, BinaryOperation comparison) {
        AbstractExpression leafExpr = expr.getLastContextStep();
        if (leafExpr instanceof Dot) {
            leafExpr = this.getBaseContextStep(expr);
        }
        for (AbstractExpression fieldLeaf : this.compiler.getFieldLeaves(leafExpr)) {
            AbstractExpression fieldExpr = this.matchUpwards(leafExpr, fieldLeaf, comparison);
            if (fieldExpr == null) continue;
            return this.compiler.getFieldForExpr(fieldExpr);
        }
        return null;
    }

    private AbstractExpression getBaseContextStep(AbstractExpression expr) {
        AbstractExpression e;
        for (e = expr; e != null && e.getType() != AbstractExpression.Type.PREDICATE; e = e.getSuper()) {
        }
        if (e == null) {
            return expr;
        }
        return ((Predicate)e).getBase().getLastContextStep();
    }

    private AbstractExpression matchUpwards(AbstractExpression queryExpr, AbstractExpression fieldExpr, AbstractExpression enclosingExpr) {
        AbstractExpression fieldSuper = this.getEquivSuper(fieldExpr);
        AbstractExpression querySuper = this.getEquivSuper(queryExpr);
        if (fieldSuper == null) {
            return fieldExpr;
        }
        if (querySuper == enclosingExpr) {
            querySuper = this.getEquivSuper(querySuper);
        }
        if (querySuper == null) {
            return null;
        }
        if (!querySuper.matchDown(fieldSuper, fieldExpr)) {
            return null;
        }
        return this.matchUpwards(querySuper, fieldSuper, enclosingExpr);
    }

    private AbstractExpression getEquivSuper(AbstractExpression expr) {
        AbstractExpression sup = expr.getSuper();
        if (sup != null && sup.getType() == AbstractExpression.Type.FUNCTION_CALL && sup.isRestrictive()) {
            return this.getEquivSuper(sup);
        }
        return sup;
    }

    private FieldDefinition fieldMatching(AbstractExpression expr) {
        AbstractExpression arg;
        FunCall funcall;
        QName funcName;
        if (expr.getType() == AbstractExpression.Type.FUNCTION_CALL && ((funcName = (funcall = (FunCall)expr).getName()).equals(FunCall.LUX_KEY) || funcName.equals(FunCall.LUX_FIELD_VALUES)) && (arg = funcall.getSubs()[0]) instanceof LiteralExpression) {
            String fieldName = ((LiteralExpression)arg).getValue().toString();
            return this.indexConfig.getField(fieldName);
        }
        return null;
    }

    private AbstractExpression rewriteMinMax(AbstractExpression expr) {
        FunCall fnarg;
        AbstractExpression arg;
        FunCall funcall;
        QName funcName;
        if (expr.getType() == AbstractExpression.Type.FUNCTION_CALL && ((funcName = (funcall = (FunCall)expr).getName()).equals(FunCall.FN_MIN) || funcName.equals(FunCall.FN_MAX)) && (arg = funcall.getSubs()[0]) instanceof FunCall && ((fnarg = (FunCall)arg).getName().equals(FunCall.LUX_KEY) || fnarg.getName().equals(FunCall.LUX_FIELD_VALUES))) {
            return fnarg;
        }
        return expr;
    }

    private boolean isComparableType(ValueType valueType, FieldDefinition.Type fieldType) {
        if (valueType.isNode || valueType == ValueType.VALUE || valueType == ValueType.ATOMIC) {
            return true;
        }
        switch (fieldType) {
            case STRING: {
                return valueType == ValueType.STRING || valueType == ValueType.UNTYPED_ATOMIC;
            }
            case INT: 
            case LONG: {
                return valueType.isNumeric;
            }
        }
        return false;
    }

    private PathStep getLastPathStep(AbstractExpression path) {
        AbstractExpression last = path.getLastContextStep();
        if (last.getType() == AbstractExpression.Type.DOT) {
            AbstractExpression p;
            for (p = path; p != null && !(p instanceof Predicate); p = p.getSuper()) {
            }
            if (p == null) {
                return null;
            }
            last = ((Predicate)p).getBase().getLastContextStep();
        }
        if (last instanceof PathStep) {
            return (PathStep)last;
        }
        return null;
    }

    private boolean optimizeFnContains(FunCall funcall) {
        if (!this.indexConfig.isOption(128)) {
            return false;
        }
        if (!funcall.getName().equals(FunCall.FN_CONTAINS)) {
            return false;
        }
        LiteralExpression value = null;
        AbstractExpression path = null;
        AbstractExpression op1 = funcall.getSubs()[0];
        AbstractExpression op2 = funcall.getSubs()[1];
        if (op2.getType() != AbstractExpression.Type.LITERAL) {
            return false;
        }
        value = (LiteralExpression)op2;
        path = op1;
        PathStep step = this.getLastPathStep(path);
        if (step == null) {
            return false;
        }
        String v = value.getValue().toString();
        if (!v.matches("\\w+")) {
            return false;
        }
        ParseableQuery termQuery = this.createTermQuery(step, "*" + v + "*");
        if (termQuery != null) {
            this.combineTermQuery(termQuery, step.getNodeTest().getType());
            this.peek().setFact(2, false);
            return true;
        }
        return false;
    }

    private void optimizeBinaryOperation(BinaryOperation op) {
        if (!this.indexConfig.isOption(128)) {
            return;
        }
        LiteralExpression value = null;
        AbstractExpression path = null;
        if (op.getOperator() != BinaryOperation.Operator.EQUALS && op.getOperator() != BinaryOperation.Operator.AEQ) {
            return;
        }
        AbstractExpression op1 = op.getOperand1();
        AbstractExpression op2 = op.getOperand2();
        if (op1.getType() == AbstractExpression.Type.LITERAL) {
            value = (LiteralExpression)op1;
            path = op2;
        } else if (op2.getType() == AbstractExpression.Type.LITERAL) {
            value = (LiteralExpression)op2;
            path = op1;
        } else {
            return;
        }
        PathStep step = this.getLastPathStep(path);
        if (step == null) {
            return;
        }
        String v = value.getValue().toString();
        ParseableQuery termQuery = null;
        termQuery = this.createTermQuery(step, v);
        if (termQuery != null) {
            this.combineTermQuery(termQuery, step.getNodeTest().getType());
        }
    }

    private ParseableQuery createTermQuery(PathStep context, String value) {
        NodeTest nodeTest = context.getNodeTest();
        QName nodeName = nodeTest.getQName();
        if (nodeName == null || "*".equals(nodeName.getPrefix()) || "*".equals(nodeName.getLocalPart())) {
            return PathOptimizer.makeTextQuery(value, this.indexConfig);
        }
        if (nodeTest.getType() == ValueType.ELEMENT) {
            return PathOptimizer.makeElementValueQuery(nodeName, value, this.indexConfig);
        }
        if (nodeTest.getType() == ValueType.ATTRIBUTE) {
            return PathOptimizer.makeAttributeValueQuery(nodeName, value, this.indexConfig);
        }
        return null;
    }

    private void combineTermQuery(ParseableQuery termQuery, ValueType termType) {
        XPathQuery tq = XPathQuery.getQuery(termQuery, null, 2L, termType, this.indexConfig, null);
        XPathQuery q = this.pop();
        XPathQuery combined = q.getBooleanQuery() instanceof TermPQuery ? tq : this.combineQueries(tq, BooleanClause.Occur.MUST, q, q.getResultType());
        combined.setPathQuery(q.getPathQuery());
        this.push(combined);
    }

    public static NodeTextQuery makeElementValueQuery(QName qname, String value, IndexConfiguration config) {
        return new NodeTextQuery(new Term(config.getFieldName(IndexConfiguration.ELEMENT_TEXT), value), qname.getEncodedName());
    }

    public static ParseableQuery makeAttributeValueQuery(QName qname, String value, IndexConfiguration config) {
        return new NodeTextQuery(new Term(config.getFieldName(IndexConfiguration.ATTRIBUTE_TEXT), value), qname.getEncodedName());
    }

    public static ParseableQuery makeTextQuery(String value, IndexConfiguration config) {
        return new NodeTextQuery(new Term(config.getFieldName(IndexConfiguration.XML_TEXT), value));
    }

    @Override
    public AbstractExpression visit(LiteralExpression literal) {
        this.push(XPathQuery.MATCH_ALL.setFact(32, true));
        return literal;
    }

    @Override
    public AbstractExpression visit(Variable variable) {
        QName qName = variable.getQName();
        VarBinding varBinding = this.varBindings.get(qName);
        if (varBinding != null) {
            XPathQuery q = varBinding.getQuery();
            this.push(q);
            AbstractExpression value = varBinding.getExpr();
            variable.setValue(value);
            variable.setBindingContext(varBinding.getContext());
        } else {
            this.push(XPathQuery.MATCH_ALL.setFact(32, true));
        }
        return variable;
    }

    @Override
    public AbstractExpression visit(Subsequence subsequence) {
        this.optimizeSubExpressions(subsequence);
        AbstractExpression length = subsequence.getLengthExpr();
        AbstractExpression start = subsequence.getStartExpr();
        if (length != null) {
            this.pop();
        }
        this.pop();
        if (start == FunCall.LastExpression || start.equals(LiteralExpression.ONE) && length.equals(LiteralExpression.ONE)) {
            return subsequence;
        }
        this.push(this.pop().setFact(6, false));
        return this.optimizeStart(subsequence);
    }

    private AbstractExpression optimizeStart(Subsequence subsequence) {
        AbstractExpression sequence = subsequence.getSequence();
        AbstractExpression start = subsequence.getStartExpr();
        AbstractExpression length = subsequence.getLengthExpr();
        AbstractExpression root = sequence.getRoot();
        if (root == null || root.getType() != AbstractExpression.Type.FUNCTION_CALL || LiteralExpression.ONE.equals(start)) {
            return subsequence;
        }
        FunCall search = (FunCall)root;
        AbstractExpression[] args = search.getSubs();
        if (args.length >= 3) {
            return subsequence;
        }
        boolean isSingular = args.length < 1 ? true : (search instanceof SearchCall ? ((SearchCall)search).getQuery().isFact(4) : false);
        if (isSingular) {
            int i;
            AbstractExpression[] newArgs = new AbstractExpression[3];
            for (i = 0; i < args.length; ++i) {
                newArgs[i] = args[i];
            }
            while (i < 2) {
                newArgs[i++] = LiteralExpression.EMPTY;
            }
            newArgs[i] = start;
            search.setArguments(newArgs);
            if (length == null || length.equals(LiteralExpression.EMPTY)) {
                return search;
            }
            subsequence.setStartExpr(LiteralExpression.ONE);
        }
        return subsequence;
    }

    private SearchCall mergeSearchCall(SearchCall search, XPathQuery query) {
        search.combineQuery(query, this.indexConfig);
        return search;
    }

    private FunCall createSearchCall(QName functionName, XPathQuery query) {
        for (XPathQuery rangeq : this.rangeQueries) {
            query = this.combineQueries(query, BooleanClause.Occur.MUST, rangeq, query.getResultType());
        }
        this.rangeQueries.clear();
        if (functionName.equals(FunCall.LUX_SEARCH)) {
            return new SearchCall(query, this.indexConfig);
        }
        FunCall fn = new FunCall(functionName, query.getResultType(), query.toXmlNode(this.indexConfig.getDefaultFieldName(), this.indexConfig));
        if (query.isFact(16)) {
            return new FunCall(FunCall.FN_NOT, ValueType.BOOLEAN, fn);
        }
        return fn;
    }

    @Override
    public AbstractExpression visit(Sequence sequence) {
        this.optimizeSubExpressions(sequence);
        this.combineTopQueries(sequence.getSubs().length, BooleanClause.Occur.SHOULD);
        return sequence;
    }

    private void popChildQueries(AbstractExpression expr) {
        for (int i = 0; i < expr.getSubs().length; ++i) {
            this.pop();
        }
        this.push(XPathQuery.MATCH_ALL);
    }

    @Override
    public AbstractExpression visitDefault(AbstractExpression expr) {
        this.optimizeSubExpressions(expr);
        this.popChildQueries(expr);
        return expr;
    }

    @Override
    public AbstractExpression visit(FLWOR flwor) {
        flwor.getSubs()[0] = this.optimizeExpression(flwor.getReturnExpression(), this.peek());
        this.peek().setSortFields(null);
        int length = flwor.getClauses().length;
        for (int i = length - 1; i >= 0; --i) {
            XPathQuery q;
            FLWORClause clause = flwor.getClauses()[i];
            AbstractExpression seq = clause.getSequence();
            if (clause instanceof VariableBindingClause) {
                QName varName = ((VariableBindingClause)clause).getVariable().getQName();
                this.descopeVariable(varName);
            }
            XPathQuery returnq = this.pop();
            XPathQuery clauseq = this.pop();
            if (clause instanceof LetClause) {
                clauseq.setFact(32, false);
                q = this.combineQueries(clauseq, BooleanClause.Occur.MUST, returnq, clauseq.getResultType());
                clause.setSequence(this.optimizeExpression(seq, q));
                this.push(returnq);
            } else {
                q = this.combineQueries(clauseq, BooleanClause.Occur.MUST, returnq, returnq.getResultType());
                this.push(q);
            }
            if (!(clause instanceof ForClause)) continue;
            clause.setSequence(this.optimizeExpression(seq, this.peek()));
        }
        return flwor;
    }

    private void descopeVariable(QName varName) {
        VarBinding binding = this.varBindings.remove(varName);
        if (binding != null && binding.getShadowedBinding() != null) {
            this.varBindings.put(varName, binding.getShadowedBinding());
        }
    }

    @Override
    public OrderByClause visit(OrderByClause orderByClause) {
        LinkedList<SortField> sortFields = new LinkedList<SortField>();
        ArrayList<SortKey> sortKeys = orderByClause.getSortKeys();
        boolean foundUnindexedSort = false;
        int stackOffset = this.queryStack.size() - sortKeys.size();
        for (int i = 0; i < sortKeys.size(); ++i) {
            FunCall keyFun;
            XPathQuery q = this.queryStack.remove(stackOffset);
            SortKey sortKey = sortKeys.get(i);
            AbstractExpression key = sortKey.getKey();
            if (q.getSortFields() == null) {
                foundUnindexedSort = true;
                continue;
            }
            if (foundUnindexedSort) continue;
            if (key instanceof FunCall && ((keyFun = (FunCall)key).getName().equals(FunCall.LUX_KEY) || keyFun.getName().equals(FunCall.LUX_FIELD_VALUES)) && keyFun.getSubs().length < 2) {
                throw new LuxException("lux:key($key) depends on the context where there is no context defined");
            }
            String order = sortKey.getOrder().getValue().toString();
            SortField sortField = q.getSortFields()[0];
            if (!sortKey.isEmptyLeast()) {
                sortField = new SortField(sortField.getField(), (FieldComparatorSource)SearchResultIterator.MISSING_LAST, order.toString().equals("descending"));
            } else if (order.toString().equals("descending")) {
                sortField = new SortField(sortField.getField(), sortField.getType(), true);
            }
            sortFields.add(sortField);
            sortKeys.remove(i);
            --i;
        }
        if (sortFields.isEmpty()) {
            this.push(this.MATCH_ALL);
        } else {
            XPathQuery query = XPathQuery.getQuery(this.MATCH_ALL.getBooleanQuery(), null, this.MATCH_ALL.getFacts(), this.MATCH_ALL.getResultType(), this.indexConfig, sortFields.toArray(new SortField[sortFields.size()]));
            this.push(query);
        }
        return orderByClause;
    }

    @Override
    public ForClause visit(ForClause forClause) {
        this.visitVariableBinding(forClause);
        return forClause;
    }

    @Override
    public WhereClause visit(WhereClause whereClause) {
        this.pop();
        this.push(this.MATCH_ALL);
        return whereClause;
    }

    @Override
    public LetClause visit(LetClause letClause) {
        this.visitVariableBinding(letClause);
        return letClause;
    }

    private void visitVariableBinding(VariableBindingClause clause) {
        XPathQuery q = this.peek();
        q.setSortFields(null);
        this.setBoundExpression(clause, q);
    }

    private void setUnboundVariable(Variable var) {
        QName name = var.getQName();
        VarBinding currentBinding = this.varBindings.get(name);
        VarBinding newBinding = new VarBinding(var, null, this.MATCH_ALL, null, currentBinding);
        this.varBindings.put(name, newBinding);
    }

    private void setBoundExpression(VariableBindingClause clause, XPathQuery q) {
        Variable var = clause.getVariable();
        QName name = var.getQName();
        VarBinding currentBinding = this.varBindings.get(name);
        VarBinding newBinding = new VarBinding(var, clause.getSequence(), q, clause, currentBinding);
        this.varBindings.put(name, newBinding);
    }

    public AbstractExpression getBoundExpression(QName name) {
        VarBinding binding = this.varBindings.get(name);
        while (binding != null && binding.getExpr() instanceof Variable) {
            binding = this.varBindings.get(((Variable)binding.getExpr()).getQName());
        }
        return binding == null ? null : binding.getExpr();
    }

    public boolean isOptimizedForOrderedResults() {
        return this.optimizeForOrderedResults;
    }

    public void setSearchStrategy(Compiler.SearchStrategy searchStrategy) {
        this.optimizeForOrderedResults = searchStrategy == Compiler.SearchStrategy.LUX_SEARCH;
    }

    private static enum ResultOrientation {
        LEFT,
        RIGHT;

    }
}

