/*
 * Decompiled with CFR 0.152.
 */
package lux;

import java.io.IOException;
import lux.CachingDocReader;
import lux.Evaluator;
import lux.QueryStats;
import lux.exception.LuxException;
import lux.search.DocIterator;
import lux.search.LuxSearcher;
import lux.solr.MissingStringLastComparatorSource;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.trans.XPathException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;

public class SearchResultIterator
implements SequenceIterator<NodeInfo> {
    private final DocIdSetIterator docIter;
    private final Query query;
    private final QueryStats stats;
    private final LuxSearcher searcher;
    private final String sortCriteria;
    private final int start;
    private CachingDocReader docCache;
    private NodeInfo current = null;
    private int position = 0;
    public static final MissingStringLastComparatorSource MISSING_LAST = new MissingStringLastComparatorSource();

    public SearchResultIterator(Evaluator eval, Query query, String sortCriteria, int start) throws IOException {
        this(eval.getSearcher(), eval.getDocReader(), eval.getQueryStats(), query, sortCriteria, start);
    }

    protected SearchResultIterator(LuxSearcher searcher, CachingDocReader docReader, QueryStats stats, Query query, String sortCriteria, int start) throws IOException {
        this.query = query;
        this.searcher = searcher;
        this.docCache = docReader;
        this.stats = stats;
        this.sortCriteria = sortCriteria;
        this.start = start;
        if (stats != null) {
            stats.query = query.toString();
        }
        if (searcher == null) {
            throw new LuxException("Attempted to search using an Evaluator that has no searcher");
        }
        if (sortCriteria != null) {
            Sort sort = this.makeSortFromCriteria();
            this.docIter = searcher.search(query, sort);
        } else {
            this.docIter = searcher.searchOrdered(query);
        }
        if (start > 1) {
            this.advanceTo(start);
        }
    }

    private Sort makeSortFromCriteria() {
        String[] fields = this.sortCriteria.split("\\s*,\\s*");
        SortField[] sortFields = new SortField[fields.length];
        block4: for (int i = 0; i < fields.length; ++i) {
            SortField.Type type = SortField.Type.STRING;
            String[] tokens = fields[i].split("\\s+");
            String field = tokens[0];
            Boolean reverse = null;
            Boolean emptyGreatest = null;
            for (int j = 1; j < tokens.length; ++j) {
                if (tokens[j].equals("descending")) {
                    reverse = this.setBooleanOnce(reverse, true, this.sortCriteria);
                    continue;
                }
                if (tokens[j].equals("ascending")) {
                    reverse = this.setBooleanOnce(reverse, false, this.sortCriteria);
                    continue;
                }
                if (tokens[j].equals("empty")) {
                    if (j == tokens.length - 1) {
                        throw new LuxException("missing keyword after 'empty' in: " + this.sortCriteria);
                    }
                    if (tokens[++j].equals("least")) {
                        emptyGreatest = this.setBooleanOnce(emptyGreatest, false, this.sortCriteria);
                        continue;
                    }
                    if (tokens[j].equals("greatest")) {
                        emptyGreatest = this.setBooleanOnce(emptyGreatest, true, this.sortCriteria);
                        continue;
                    }
                    throw new LuxException("missing or invalid keyword after 'empty' in: " + this.sortCriteria);
                }
                if (tokens[j].equals("int")) {
                    type = SortField.Type.INT;
                    continue;
                }
                if (tokens[j].equals("long")) {
                    type = SortField.Type.LONG;
                    continue;
                }
                if (tokens[j].equals("string")) {
                    type = SortField.Type.STRING;
                    continue;
                }
                throw new LuxException("invalid keyword '" + tokens[j] + "' in: " + this.sortCriteria);
            }
            if (field.equals("lux:score")) {
                if (reverse == Boolean.FALSE) {
                    throw new LuxException("not countenanced: attempt to sort by irrelevance");
                }
                sortFields[i] = SortField.FIELD_SCORE;
                continue;
            }
            if (emptyGreatest == Boolean.TRUE) {
                if (type == SortField.Type.STRING) {
                    sortFields[i] = new SortField(field, (FieldComparatorSource)MISSING_LAST, reverse == Boolean.TRUE);
                    continue;
                }
                sortFields[i] = new SortField(field, type, reverse == Boolean.TRUE);
                switch (type) {
                    case INT: {
                        sortFields[i].setMissingValue((Object)(reverse == Boolean.TRUE ? 0 : Integer.MAX_VALUE));
                        continue block4;
                    }
                    case LONG: {
                        sortFields[i].setMissingValue((Object)(reverse == Boolean.TRUE ? 0L : Long.MAX_VALUE));
                        continue block4;
                    }
                    default: {
                        throw new LuxException("unsupported combination of empty greatest and sort field type: " + type);
                    }
                }
            }
            sortFields[i] = new SortField(field, type, reverse == Boolean.TRUE);
        }
        return new Sort(sortFields);
    }

    private final Boolean setBooleanOnce(Boolean current, boolean value, String sortCriteria) {
        if (current != null) {
            throw new LuxException("too many ordering keywords in: " + sortCriteria);
        }
        return value;
    }

    public NodeInfo next() throws XPathException {
        long t = System.nanoTime();
        int startPosition = this.position;
        try {
            int docID = this.docIter.nextDoc();
            if (docID == Integer.MAX_VALUE) {
                this.position = -1;
                this.current = null;
            } else {
                NodeInfo item;
                long t1 = System.nanoTime();
                XdmNode doc = this.sortCriteria == null ? this.docCache.get(docID, ((DocIterator)this.docIter).getCurrentReaderContext()) : this.docCache.get(docID, this.searcher.getIndexReader());
                this.current = item = (NodeInfo)doc.getUnderlyingValue();
                ++this.position;
                if (this.stats != null) {
                    this.stats.retrievalTime += System.nanoTime() - t1;
                }
            }
        }
        catch (IOException e) {
            throw new XPathException((Throwable)e);
        }
        finally {
            if (this.stats != null) {
                if (this.position >= 0) {
                    this.stats.docCount += this.position - startPosition;
                }
                this.stats.totalTime += System.nanoTime() - t;
            }
        }
        return this.current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void advanceTo(int startPosition) throws IOException {
        long t = System.nanoTime();
        int start0 = startPosition - 1;
        try {
            int docID = 0;
            this.current = null;
            while (this.position < start0) {
                docID = this.docIter.nextDoc();
                if (docID == Integer.MAX_VALUE) {
                    this.position = -1;
                    break;
                }
                ++this.position;
            }
            if (this.stats != null) {
                // empty if block
            }
        }
        finally {
            if (this.stats != null) {
                long t1 = System.nanoTime();
                this.stats.retrievalTime += t1 - t;
                this.stats.totalTime += t1 - t;
            }
        }
    }

    public NodeInfo current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public void close() {
    }

    public SequenceIterator<NodeInfo> getAnother() throws XPathException {
        try {
            return new SearchResultIterator(this.searcher, this.docCache, this.stats, this.query, this.sortCriteria, this.start);
        }
        catch (IOException e) {
            throw new XPathException((Throwable)e);
        }
    }

    public int getProperties() {
        return 0;
    }
}

