/*
 * Decompiled with CFR 0.152.
 */
package lux.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log
extends ExtensionFunctionDefinition {
    private void log(Logger logger, LogLevel level, String message) {
        switch (level) {
            case TRACE: {
                logger.trace(message);
                break;
            }
            case DEBUG: {
                logger.debug(message);
                break;
            }
            case INFO: {
                logger.info(message);
                break;
            }
            case WARN: {
                logger.warn(message);
                break;
            }
            case ERROR: {
                logger.error(message);
                break;
            }
            default: {
                logger.error(message);
            }
        }
    }

    private boolean isLogEnabled(Logger logger, LogLevel level) {
        switch (level) {
            case TRACE: {
                return logger.isTraceEnabled();
            }
            case DEBUG: {
                return logger.isDebugEnabled();
            }
            case INFO: {
                return logger.isInfoEnabled();
            }
            case WARN: {
                return logger.isWarnEnabled();
            }
            case ERROR: {
                return logger.isErrorEnabled();
            }
        }
        return true;
    }

    public StructuredQName getFunctionQName() {
        return new StructuredQName("lux", "http://luxdb.net", "log");
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.ANY_SEQUENCE, SequenceType.OPTIONAL_STRING};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.OPTIONAL_ITEM;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new LogCall();
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 2;
    }

    class LogCall
    extends ExtensionFunctionCall {
        LogCall() {
        }

        public SequenceIterator<? extends Item> call(SequenceIterator<? extends Item>[] arguments, XPathContext context) throws XPathException {
            LogLevel level;
            Logger logger = LoggerFactory.getLogger((String)"lux.functions");
            if (arguments.length > 1) {
                String lvl = arguments[1].next().getStringValue();
                try {
                    level = LogLevel.valueOf(lvl.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    throw new XPathException("Undefined log level: " + lvl);
                }
            } else {
                level = LogLevel.INFO;
            }
            if (!Log.this.isLogEnabled(logger, level)) {
                return EmptySequence.asIterator(null);
            }
            SequenceIterator<? extends Item> tokens = arguments[0];
            StringBuilder message = new StringBuilder();
            Item item = tokens.next();
            if (item != null) {
                message.append(item.getStringValue());
            }
            while ((item = tokens.next()) != null) {
                message.append(item.getStringValue());
            }
            Log.this.log(logger, level, message.toString());
            return EmptySequence.asIterator(null);
        }
    }

    private static enum LogLevel {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        FATAL;

    }
}

