/*
 * Decompiled with CFR 0.152.
 */
package lux.index;

import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.stream.XMLStreamReader;
import lux.index.MutableString;
import lux.index.XmlPathMapper;

public class QNameTextMapper
extends XmlPathMapper {
    private int depth = -1;
    private StringBuilder[] stack;
    private ArrayList<CharSequence> names;
    private ArrayList<CharSequence> values;
    private MutableString charBuffer = new MutableString();

    public QNameTextMapper() {
        this.stack = new StringBuilder[8];
        this.names = new ArrayList();
        this.values = new ArrayList();
        for (int i = 0; i < this.stack.length; ++i) {
            this.stack[i] = new StringBuilder();
        }
    }

    public ArrayList<CharSequence> getValues() {
        return this.values;
    }

    public ArrayList<CharSequence> getNames() {
        return this.names;
    }

    @Override
    public void reset() {
        super.reset();
        this.depth = -1;
        this.names.clear();
        this.values.clear();
    }

    @Override
    public void handleEvent(XMLStreamReader reader, int eventType) {
        switch (eventType) {
            case 7: {
                super.handleEvent(reader, eventType);
                break;
            }
            case 1: {
                super.handleEvent(reader, eventType);
                StringBuilder buf = this.pushStackFrame();
                for (int i = 0; i < reader.getAttributeCount(); ++i) {
                    this.getEventAttQName(this.charBuffer, reader, i);
                    String name = '@' + this.charBuffer.toString();
                    this.names.add(name);
                    this.values.add(reader.getAttributeValue(i));
                }
                break;
            }
            case 2: {
                super.handleEvent(reader, eventType);
                StringBuilder buf = this.popStackFrame();
                this.names.add(this.getCurrentQName());
                this.values.add(buf.toString());
                break;
            }
            case 4: 
            case 6: 
            case 12: {
                this.stack[this.depth].append(reader.getTextCharacters(), reader.getTextStart(), reader.getTextLength());
                super.handleEvent(reader, eventType);
                break;
            }
            case 9: {
                this.stack[this.depth].append(reader.getText());
                break;
            }
            default: {
                super.handleEvent(reader, eventType);
            }
        }
    }

    private StringBuilder popStackFrame() {
        return this.stack[this.depth--];
    }

    private StringBuilder pushStackFrame() {
        if (this.depth++ >= this.stack.length) {
            this.growStack();
        } else {
            this.stack[this.depth].setLength(0);
        }
        return this.stack[this.depth];
    }

    private void growStack() {
        this.stack = Arrays.copyOf(this.stack, this.stack.length + 8);
    }
}

