/*
 * Decompiled with CFR 0.152.
 */
package lux.index.analysis;

import java.io.IOException;
import lux.index.analysis.ValueTokenStream;

public final class QNameValueTokenStream
extends ValueTokenStream {
    private static final int HASH_SIZE = 8;
    private int bufpos;
    private char[] buf = new char[8];

    public QNameValueTokenStream(Iterable<char[]> values) {
        super(values);
    }

    @Override
    protected boolean advanceValue() {
        if (!super.advanceValue()) {
            return false;
        }
        this.pos = this.value.length - 8 - 2;
        while (this.value[this.pos] != ' ') {
            --this.pos;
        }
        this.bufpos = 0;
        return true;
    }

    public boolean incrementToken() throws IOException {
        if (this.pos >= this.value.length && !this.advanceValue()) {
            return false;
        }
        System.arraycopy(this.value, this.value.length - 8, this.buf, 0, 8);
        while (this.value[this.pos] != ' ') {
            this.buf[this.bufpos] = (char)(this.buf[this.bufpos] * 15 + this.value[this.pos++]);
            if (++this.bufpos < 8) continue;
            this.bufpos = 0;
        }
        this.termAtt.copyBuffer(this.buf, 0, 8);
        this.pos = this.value.length;
        return true;
    }
}

