/*
 * Decompiled with CFR 0.152.
 */
package lux.query.parser;

import lux.query.parser.NodeQueryBuilder;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.ext.ExtensionQuery;
import org.apache.lucene.queryparser.ext.ParserExtension;
import org.apache.lucene.queryparser.xml.ParserException;
import org.apache.lucene.search.Query;

class NodeParser
extends ParserExtension {
    private final String textFieldName;
    private final String elementTextFieldName;
    private final String attributeTextFieldName;
    NodeQueryBuilder queryBuilder;

    NodeParser(String textFieldName, String elementTextFieldName, String attributeTextFieldName, NodeQueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
        this.textFieldName = textFieldName;
        this.elementTextFieldName = elementTextFieldName;
        this.attributeTextFieldName = attributeTextFieldName;
    }

    public Query parse(ExtensionQuery query) throws ParseException {
        String field = query.getField();
        String term = query.getRawQueryString();
        try {
            if (StringUtils.isEmpty((String)field)) {
                return this.queryBuilder.parseQueryTerm(this.textFieldName, field, term, 1.0f);
            }
            if (field.charAt(0) == '@') {
                return this.queryBuilder.parseQueryTerm(this.attributeTextFieldName, field.substring(1), term, 1.0f);
            }
            return this.queryBuilder.parseQueryTerm(this.elementTextFieldName, field, term, 1.0f);
        }
        catch (ParserException e) {
            throw new ParseException(e.getMessage());
        }
    }
}

