/*
 * Decompiled with CFR 0.152.
 */
package lux.solr;

import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import javax.xml.stream.XMLStreamException;
import lux.index.FieldName;
import lux.index.IndexConfiguration;
import lux.index.XmlIndexer;
import lux.index.field.FieldDefinition;
import lux.solr.SolrIndexConfig;
import lux.solr.UpdateDocCommand;
import lux.xml.tinybin.TinyBinary;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.NodeInfo;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.LoggerFactory;

public class LuxUpdateProcessor
extends UpdateRequestProcessor {
    private final SolrIndexConfig solrIndexConfig;
    private final IndexConfiguration indexConfig;
    private final Configuration saxonConfig;
    private final SolrQueryRequest req;

    public LuxUpdateProcessor(SolrIndexConfig config, SolrQueryRequest req, UpdateRequestProcessor next) {
        super(next);
        this.solrIndexConfig = config;
        this.indexConfig = this.solrIndexConfig.getIndexConfig();
        this.saxonConfig = this.solrIndexConfig.getCompiler().getProcessor().getUnderlyingConfiguration();
        this.req = req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAdd(AddUpdateCommand cmd) throws IOException {
        SolrInputDocument solrInputDocument = cmd.getSolrInputDocument();
        String xmlFieldName = this.indexConfig.getFieldName(FieldName.XML_STORE);
        SolrInputField xmlField = solrInputDocument.removeField(xmlFieldName);
        Document luceneDocument = cmd.getLuceneDocument();
        UpdateDocCommand luxCommand = null;
        if (xmlField != null) {
            solrInputDocument.put(xmlFieldName, xmlField);
            XmlIndexer xmlIndexer = this.solrIndexConfig.checkoutXmlIndexer();
            Object xml = xmlField.getFirstValue();
            try {
                String uri = (String)solrInputDocument.getFieldValue(this.indexConfig.getFieldName(FieldName.URI));
                try {
                    if (xml instanceof String) {
                        xmlIndexer.index(new StringReader((String)xml), uri);
                    } else if (xml instanceof byte[]) {
                        TinyBinary xmlbin = new TinyBinary((byte[])xml, Charset.forName("utf-8"));
                        xmlIndexer.index((NodeInfo)xmlbin.getTinyDocument(this.saxonConfig), uri);
                    }
                }
                catch (XMLStreamException e) {
                    LoggerFactory.getLogger(LuxUpdateProcessor.class).error("Failed to parse " + (Object)((Object)FieldName.XML_STORE), (Throwable)e);
                }
                LuxUpdateProcessor.addDocumentFields(xmlIndexer, this.solrIndexConfig.getSchema(), luceneDocument);
                luxCommand = new UpdateDocCommand(this.req, solrInputDocument, luceneDocument, uri);
            }
            finally {
                this.solrIndexConfig.returnXmlIndexer(xmlIndexer);
            }
        }
        if (this.next != null) {
            this.next.processAdd((AddUpdateCommand)(luxCommand == null ? cmd : luxCommand));
        }
    }

    public static void addDocumentFields(XmlIndexer indexer, IndexSchema indexSchema, Document doc) {
        IndexConfiguration indexConfig = indexer.getConfiguration();
        if (indexConfig.isOption(16)) {
            doc.removeField(indexConfig.getFieldName(FieldName.XML_STORE));
        }
        for (FieldDefinition field : indexConfig.getFields()) {
            String fieldName = indexConfig.getFieldName(field);
            if ((field == indexConfig.getField(FieldName.URI) || field == indexConfig.getField(FieldName.XML_STORE)) && doc.getField(fieldName) != null) continue;
            Iterable<?> values = field.getValues(indexer);
            SchemaField schemaField = indexSchema.getField(fieldName);
            if (values != null) {
                for (Object object : values) {
                    LuxUpdateProcessor.addField(doc, schemaField, object, 1.0f);
                }
                continue;
            }
            for (IndexableField indexableField : field.getFieldValues(indexer)) {
                LuxUpdateProcessor.addField(doc, schemaField, indexableField, 1.0f);
            }
        }
    }

    private static void addField(Document doc, SchemaField field, Object val, float boost) {
        for (IndexableField f : field.getType().createFields(field, val, boost)) {
            if (f == null) continue;
            doc.add((IndexableField)((Field)f));
        }
    }

    public void processDelete(DeleteUpdateCommand cmd) throws IOException {
        if (this.next != null) {
            this.next.processDelete(cmd);
        }
    }
}

