/*
 * Decompiled with CFR 0.152.
 */
package lux.solr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import lux.Compiler;
import lux.Evaluator;
import lux.QueryContext;
import lux.QueryStats;
import lux.TransformErrorListener;
import lux.exception.LuxException;
import lux.exception.ResourceExhaustedException;
import lux.search.LuxSearcher;
import lux.solr.LuxDispatchFilter;
import lux.solr.SolrDocWriter;
import lux.solr.SolrIndexConfig;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.GlobalVariableDefinition;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.LinkedTreeBuilder;
import net.sf.saxon.tree.tiny.TinyElementImpl;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.GDateValue;
import net.sf.saxon.value.GDayValue;
import net.sf.saxon.value.GMonthDayValue;
import net.sf.saxon.value.GMonthValue;
import net.sf.saxon.value.GYearMonthValue;
import net.sf.saxon.value.GYearValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.TextFragmentValue;
import net.sf.saxon.value.Value;
import nu.validator.htmlparser.sax.HtmlParser;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.search.IndexSearcher;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.QueryComponent;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocSlice;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class XQueryComponent
extends QueryComponent
implements SolrCoreAware {
    public static final String LUX_XQUERY = "lux.xquery";
    public static final String LUX_PATH_INFO = "lux.pathInfo";
    private static final lux.xml.QName LUX_HTTP = new lux.xml.QName("http://luxdb.net", "http");
    private static final int MAX_RESULT_SIZE = (int)(Runtime.getRuntime().maxMemory() / 32L);
    protected Set<String> fields = new HashSet<String>();
    protected SolrIndexConfig solrIndexConfig;
    protected String queryPath;
    private Serializer serializer;
    private Logger logger = LoggerFactory.getLogger(XQueryComponent.class);
    private int resultByteSize;
    private static final String EXPATH_HTTP_NS = "http://expath.org/ns/webapp";
    public static final String XQUERY_COMPONENT_NAME = "xquery";

    public void inform(SolrCore core) {
        this.solrIndexConfig = SolrIndexConfig.registerIndexConfiguration(core);
    }

    public void prepare(ResponseBuilder rb) throws IOException {
        SolrQueryRequest req = rb.req;
        SolrParams params = req.getParams();
        if (rb.getQueryString() == null) {
            rb.setQueryString(params.get("q"));
        }
        String contentType = params.get("lux.contentType");
        this.serializer = this.solrIndexConfig.checkoutSerializer();
        if (contentType != null) {
            if (contentType.equals("text/html")) {
                this.serializer.setOutputProperty(Serializer.Property.METHOD, "html");
            } else if (contentType.equals("text/xml")) {
                this.serializer.setOutputProperty(Serializer.Property.METHOD, "xml");
            }
        } else {
            this.serializer.setOutputProperty(Serializer.Property.METHOD, this.getDefaultSerialization());
        }
        if (this.queryPath == null) {
            this.queryPath = rb.req.getParams().get(LUX_XQUERY);
        }
        this.resultByteSize = 0;
    }

    public String getDefaultSerialization() {
        return "xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(ResponseBuilder rb) throws IOException {
        SolrQueryRequest req = rb.req;
        SolrParams params = req.getParams();
        if (!params.getBool(XQUERY_COMPONENT_NAME, true)) {
            return;
        }
        int start = params.getInt("start", 1);
        int len = params.getInt("rows", -1);
        try {
            this.evaluateQuery(rb, start, len);
        }
        finally {
            this.solrIndexConfig.returnSerializer(this.serializer);
        }
    }

    protected void evaluateQuery(ResponseBuilder rb, int start, int len) {
        ArrayList<TransformerException> errors;
        XQueryExecutable expr;
        String query = rb.getQueryString();
        SolrQueryRequest req = rb.req;
        SolrQueryResponse rsp = rb.rsp;
        if (StringUtils.isBlank((String)query)) {
            rsp.add("xpath-error", (Object)"query was blank");
            return;
        }
        SolrParams params = req.getParams();
        long timeAllowed = params.getInt("timeAllowed", -1);
        if (!params.getBool(XQUERY_COMPONENT_NAME, true)) {
            return;
        }
        SolrIndexSearcher.QueryResult result = new SolrIndexSearcher.QueryResult();
        SolrIndexSearcher searcher = rb.req.getSearcher();
        SolrDocWriter docWriter = new SolrDocWriter(this, rb.req.getCore());
        Compiler compiler = this.solrIndexConfig.getCompiler();
        Evaluator evaluator = new Evaluator(compiler, new LuxSearcher((IndexSearcher)searcher), docWriter);
        TransformErrorListener errorListener = evaluator.getErrorListener();
        try {
            URI baseURI = this.queryPath == null ? null : URI.create(this.queryPath);
            expr = compiler.compile(query, errorListener, baseURI, null);
        }
        catch (LuxException ex) {
            String err = this.formatError(query, errorListener);
            if (StringUtils.isEmpty((String)err)) {
                err = ex.getMessage();
            }
            rsp.add("xpath-error", (Object)err);
            return;
        }
        NamedList xpathResults = new NamedList();
        long tstart = System.currentTimeMillis();
        int count = 0;
        QueryContext context = null;
        context = new QueryContext();
        this.bindRequestVariables(rb, req, expr, compiler, evaluator, context);
        Iterator<XdmItem> queryResults = evaluator.iterator(expr, context);
        String err = null;
        while (queryResults.hasNext()) {
            QName name;
            XdmItem xpathResult = queryResults.next();
            if (++count < start) continue;
            if (count == 1 && !xpathResult.isAtomicValue() && (name = ((XdmNode)xpathResult).getNodeName()) != null && name.getNamespaceURI().equals(EXPATH_HTTP_NS) && name.getLocalName().equals("response")) {
                err = this.handleEXPathResponse(req, rsp, (NamedList<Object>)xpathResults, xpathResult);
                if (!queryResults.hasNext()) break;
                this.logger.warn("Ignoring results following http:response, which should be the sole item in its result");
                break;
            }
            err = this.safeAddResult((NamedList<Object>)xpathResults, xpathResult);
            if (err != null) {
                xpathResult = null;
                break;
            }
            if ((len <= 0 || xpathResults.size() < len) && (timeAllowed <= 0L || System.currentTimeMillis() - tstart <= timeAllowed)) continue;
            break;
        }
        if (!(errors = evaluator.getErrorListener().getErrors()).isEmpty()) {
            err = this.formatError(query, errors, evaluator.getQueryStats());
            if (xpathResults.size() == 0) {
                xpathResults = null;
            }
        }
        if (err != null) {
            rsp.add("xpath-error", err);
        }
        rsp.add("xpath-results", (Object)xpathResults);
        result.setDocList((DocList)new DocSlice(0, 0, null, null, evaluator.getQueryStats().docCount, 0.0f));
        rb.setResult(result);
        rsp.add("response", (Object)rb.getResults().docList);
        if (xpathResults != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("retrieved: " + evaluator.getDocReader().getCacheMisses() + " docs, " + xpathResults.size() + " results, " + (System.currentTimeMillis() - tstart) + "ms");
            }
        } else {
            this.logger.warn("xquery evaluation error: " + evaluator.getDocReader().getCacheMisses() + " docs, " + "0 results, " + (System.currentTimeMillis() - tstart) + "ms");
        }
    }

    private String handleEXPathResponse(SolrQueryRequest req, SolrQueryResponse rsp, NamedList<Object> xpathResults, XdmItem xpathResult) {
        XdmNode expathResponse = (XdmNode)xpathResult;
        HttpServletRequest httpReq = (HttpServletRequest)req.getContext().get("httpServletRequest");
        HttpServletResponse httpResp = (HttpServletResponse)httpReq.getAttribute("httpServletResponse");
        TinyElementImpl responseNode = (TinyElementImpl)expathResponse.getUnderlyingNode();
        String status = responseNode.getAttributeValue("", "status");
        String message = responseNode.getAttributeValue("", "message");
        int istatus = 200;
        if (status != null) {
            try {
                istatus = Integer.parseInt(status);
            }
            catch (NumberFormatException e) {
                throw new LuxException("Non-numeric response status code: " + status);
            }
            if (istatus >= 400) {
                try {
                    if (message != null) {
                        httpResp.sendError(istatus, message);
                    } else {
                        httpResp.sendError(istatus);
                    }
                }
                catch (IOException e) {
                    this.logger.error("sendError failed: " + e.getMessage());
                }
            }
            httpResp.setStatus(istatus);
        }
        XdmSequenceIterator children = expathResponse.axisIterator(Axis.CHILD);
        while (children.hasNext()) {
            XdmNode child = (XdmNode)children.next();
            QName childName = child.getNodeName();
            if (!childName.getNamespaceURI().equals(EXPATH_HTTP_NS)) {
                this.logger.warn("ignoring unknown response child element: " + childName.getClarkName());
                continue;
            }
            if (childName.getLocalName().equals("body")) {
                String contentType;
                String src = child.getAttributeValue(this.qnameFor("src"));
                if (src != null) {
                    throw new LuxException("The body/@src attribute is not supported");
                }
                String characterSet = child.getAttributeValue(this.qnameFor("charset"));
                if (characterSet == null) {
                    characterSet = "utf-8";
                }
                if ((contentType = child.getAttributeValue(this.qnameFor("content-type"))) != null) {
                    contentType = contentType + "; charset=" + characterSet;
                }
                if (contentType == null && (contentType = req.getParams().get("lux.contentType", contentType)) != null) {
                    contentType = contentType.replaceFirst("(?<=; charset=).*", characterSet);
                }
                if (contentType != null) {
                    req.getContext().put("lux.contentType", contentType);
                }
                XdmSequenceIterator bodyKids = child.axisIterator(Axis.CHILD);
                while (bodyKids.hasNext()) {
                    XdmNode result = (XdmNode)bodyKids.next();
                    String err = this.safeAddResult(xpathResults, (XdmItem)result);
                    if (err == null) continue;
                    return err;
                }
                continue;
            }
            if (childName.getLocalName().equals("header")) {
                String header = child.getAttributeValue(this.qnameFor("name"));
                String value = child.getAttributeValue(this.qnameFor("value"));
                httpResp.addHeader(header, value);
                continue;
            }
            if (!childName.getLocalName().equals("multipart")) continue;
            throw new LuxException("Multipart HTTP responses not implemented");
        }
        if (expathResponse != null) {
            req.getContext().put("expath:response", expathResponse);
        }
        return null;
    }

    private void bindRequestVariables(ResponseBuilder rb, SolrQueryRequest req, XQueryExecutable expr, Compiler compiler, Evaluator evaluator, QueryContext context) {
        Iterator decls = expr.getUnderlyingCompiledQuery().getStaticContext().getModuleVariables();
        boolean hasLuxHttp = false;
        boolean hasEXpathRequest = false;
        while (decls.hasNext()) {
            GlobalVariableDefinition decl = (GlobalVariableDefinition)decls.next();
            StructuredQName varName = decl.getVariableQName();
            if (varName.equals((Object)new StructuredQName("", EXPATH_HTTP_NS, "input"))) {
                hasEXpathRequest = true;
                continue;
            }
            if (!varName.equals((Object)new StructuredQName("", LUX_HTTP.getNamespaceURI(), LUX_HTTP.getLocalPart()))) continue;
            hasLuxHttp = true;
        }
        if (hasLuxHttp) {
            context.bindVariable(LUX_HTTP, this.buildHttpParams(evaluator, req, this.queryPath != null ? this.queryPath : "/xquery"));
        }
        if (hasEXpathRequest) {
            try {
                context.bindVariable(new lux.xml.QName(EXPATH_HTTP_NS, "input", ""), this.buildEXPathRequest(compiler, evaluator, req));
            }
            catch (XPathException e) {
                throw new LuxException(e);
            }
        }
    }

    private String formatError(String query, TransformErrorListener errorListener) {
        ArrayList<TransformerException> errors = errorListener.getErrors();
        return this.formatError(query, errors, null);
    }

    private String formatError(String query, List<TransformerException> errors, QueryStats queryStats) {
        StringBuilder buf = new StringBuilder();
        if (queryStats != null && queryStats.optimizedQuery != null) {
            query = queryStats.optimizedQuery;
        }
        for (TransformerException te : errors) {
            String additionalLocationText;
            if (te instanceof XPathException && (additionalLocationText = ((XPathException)((Object)te)).getAdditionalLocationText()) != null) {
                buf.append(additionalLocationText);
            }
            buf.append(te.getMessageAndLocation());
            buf.append("\n");
            if (te.getLocator() != null) {
                int lineNumber = te.getLocator().getLineNumber();
                int column = te.getLocator().getColumnNumber();
                String[] lines = query.split("\r?\n");
                if (lineNumber <= lines.length && lineNumber > 0) {
                    String line = lines[lineNumber - 1];
                    buf.append(line, Math.min(Math.max(0, column - 100), line.length()), Math.min(line.length(), column + 100));
                }
            }
            this.logger.error("XQuery exception", (Throwable)te);
        }
        return buf.toString();
    }

    private XdmNode buildHttpParams(Evaluator evaluator, SolrQueryRequest req, String path) {
        return evaluator.build(new StringReader(this.buildHttpInfo(req)), path);
    }

    protected String safeAddResult(NamedList<Object> xpathResults, XdmItem item) {
        try {
            this.addResult(xpathResults, item);
            return null;
        }
        catch (SaxonApiException e) {
            return e.getMessage();
        }
        catch (ResourceExhaustedException e) {
            return e.getMessage();
        }
        catch (OutOfMemoryError e) {
            return e.getMessage();
        }
    }

    protected void addResult(NamedList<Object> xpathResults, XdmItem item) throws SaxonApiException {
        if (item.isAtomicValue()) {
            XdmAtomicValue xdmValue = (XdmAtomicValue)item;
            AtomicValue value = (AtomicValue)xdmValue.getUnderlyingValue();
            TypeHierarchy typeHierarchy = this.solrIndexConfig.getCompiler().getProcessor().getUnderlyingConfiguration().getTypeHierarchy();
            try {
                Object javaValue;
                String typeName = value.getItemType(typeHierarchy).toString();
                if (value instanceof DecimalValue) {
                    javaValue = ((DecimalValue)value).getDoubleValue();
                    this.addResultBytes(8);
                } else if (value instanceof QNameValue) {
                    javaValue = ((QNameValue)value).getClarkName();
                    this.addResultBytes(((String)javaValue).length() * 2);
                } else if (value instanceof GDateValue) {
                    javaValue = value instanceof GMonthValue ? ((GMonthValue)value).getPrimitiveStringValue().toString() : (value instanceof GYearValue ? ((GYearValue)value).getPrimitiveStringValue().toString() : (value instanceof GDayValue ? ((GDayValue)value).getPrimitiveStringValue().toString() : (value instanceof GMonthDayValue ? ((GMonthDayValue)value).getPrimitiveStringValue().toString() : (value instanceof GYearMonthValue ? ((GYearMonthValue)value).getPrimitiveStringValue().toString() : Value.convertToJava((Item)value)))));
                    this.addResultBytes(javaValue.toString().length() * 2);
                } else {
                    javaValue = Value.convertToJava((Item)value);
                    this.addResultBytes(javaValue.toString().length() * 2);
                }
                xpathResults.add(typeName, javaValue);
            }
            catch (XPathException e) {
                xpathResults.add(value.getPrimitiveType().getDisplayName(), (Object)value.toString());
            }
        } else {
            XdmNode node = (XdmNode)item;
            XdmNodeKind nodeKind = node.getNodeKind();
            StringWriter buf = new StringWriter();
            this.serializer.setOutputWriter((Writer)buf);
            this.serializer.serializeNode(node);
            String xml = buf.toString();
            this.addResultBytes(xml.length() * 2);
            xpathResults.add(nodeKind.toString().toLowerCase(), (Object)xml);
        }
    }

    private void addResultBytes(int count) {
        if (this.resultByteSize + count > MAX_RESULT_SIZE) {
            throw new ResourceExhaustedException("Maximum result size exceeded, returned result has been truncated");
        }
        this.resultByteSize += count;
    }

    private String buildHttpInfo(SolrQueryRequest req) {
        Map context;
        String webapp;
        StringBuilder buf = new StringBuilder();
        buf.append(String.format("<http>", new Object[0]));
        buf.append("<params>");
        SolrParams params = req.getParams();
        Iterator paramNames = params.getParameterNamesIterator();
        while (paramNames.hasNext()) {
            String[] values;
            String param = (String)paramNames.next();
            if (param.startsWith("lux.")) continue;
            buf.append(String.format("<param name=\"%s\">", param));
            for (String value : values = params.getParams(param)) {
                buf.append(String.format("<value>%s</value>", this.xmlEscape(value)));
            }
            buf.append("</param>");
        }
        buf.append("</params>");
        String pathInfo = params.get(LUX_PATH_INFO);
        if (pathInfo != null) {
            buf.append("<path-info>").append(this.xmlEscape(pathInfo)).append("</path-info>");
        }
        if ((webapp = (String)(context = req.getContext()).get("webapp")) == null) {
            webapp = "";
        }
        buf.append("<context-path>").append(webapp).append("</context-path>");
        buf.append("</http>");
        return buf.toString();
    }

    private XdmValue buildEXPathRequest(Compiler compiler, Evaluator evaluator, SolrQueryRequest req) throws XPathException {
        LinkedTreeBuilder builder = new LinkedTreeBuilder(compiler.getProcessor().getUnderlyingConfiguration().makePipelineConfiguration());
        builder.startDocument(0);
        builder.startElement((NodeName)this.fQNameFor("http", EXPATH_HTTP_NS, "request"), (SchemaType)AnyType.getInstance(), 0, 0);
        builder.namespace(new NamespaceBinding("http", EXPATH_HTTP_NS), 0);
        LuxDispatchFilter.Request requestWrapper = (LuxDispatchFilter.Request)((Object)req.getContext().get("httpServletRequest"));
        this.addAttribute(builder, "method", requestWrapper.getMethod());
        this.addAttribute(builder, "servlet", requestWrapper.getServletPath());
        HttpServletRequest httpReq = (HttpServletRequest)requestWrapper.getRequest();
        this.addAttribute(builder, "path", httpReq.getServletPath());
        String pathInfo = requestWrapper.getPathInfo();
        if (pathInfo != null) {
            this.addAttribute(builder, "path-info", pathInfo);
        }
        builder.startContent();
        StringBuilder buf = new StringBuilder();
        buf.append(requestWrapper.getScheme()).append("://").append(requestWrapper.getServerName()).append(':').append(requestWrapper.getServerPort());
        String authority = buf.toString();
        this.addSimpleElement(builder, "authority", authority);
        buf.append(httpReq.getServletPath());
        if (httpReq.getQueryString() != null) {
            buf.append('?').append(httpReq.getQueryString());
        }
        String url = buf.toString();
        this.addSimpleElement(builder, "url", url);
        this.addSimpleElement(builder, "context-root", httpReq.getContextPath());
        builder.startElement((NodeName)this.fQNameFor("http", EXPATH_HTTP_NS, "path"), (SchemaType)BuiltInAtomicType.UNTYPED_ATOMIC, 0, 0);
        builder.startContent();
        this.addSimpleElement(builder, "part", httpReq.getServletPath());
        builder.endElement();
        Iterator paramNames = req.getParams().getParameterNamesIterator();
        while (paramNames.hasNext()) {
            String[] values;
            String param = (String)paramNames.next();
            for (String value : values = req.getParams().getParams(param)) {
                builder.startElement((NodeName)this.fQNameFor("http", EXPATH_HTTP_NS, "param"), (SchemaType)BuiltInAtomicType.UNTYPED_ATOMIC, 0, 0);
                this.addAttribute(builder, "name", param);
                this.addAttribute(builder, "value", value);
                builder.startContent();
                builder.endElement();
            }
        }
        Enumeration headerNames = httpReq.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Enumeration headerValues = httpReq.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                String value = (String)headerValues.nextElement();
                builder.startElement((NodeName)this.fQNameFor("http", EXPATH_HTTP_NS, "header"), (SchemaType)BuiltInAtomicType.UNTYPED_ATOMIC, 0, 0);
                this.addAttribute(builder, "name", headerName);
                this.addAttribute(builder, "value", value);
                builder.startContent();
                builder.endElement();
            }
        }
        ArrayList<XdmItem> resultSequence = null;
        if (req.getContentStreams() != null) {
            resultSequence = new ArrayList<XdmItem>();
            this.handleContentStreams(builder, req, resultSequence, evaluator);
        }
        builder.endElement();
        builder.endDocument();
        XdmNode expathReq = new XdmNode(builder.getCurrentRoot());
        if (resultSequence == null) {
            return expathReq;
        }
        resultSequence.add(0, (XdmItem)expathReq);
        return new XdmValue(resultSequence);
    }

    private void handleContentStreams(LinkedTreeBuilder builder, SolrQueryRequest req, ArrayList<XdmItem> result, Evaluator evaluator) throws XPathException {
        int i = 0;
        for (ContentStream stream : req.getContentStreams()) {
            String contentType = stream.getContentType();
            byte[] partBytes = null;
            try {
                partBytes = IOUtils.toByteArray((InputStream)stream.getStream(), (long)stream.getSize());
            }
            catch (IOException e) {
                throw new LuxException(e);
            }
            String charset = ContentStreamBase.getCharsetFromContentType((String)contentType);
            if (charset == null) {
                charset = "utf-8";
            }
            if (!this.isText(contentType)) {
                throw new LuxException("binary values not supported");
            }
            XdmNode part = null;
            if (this.isXML(contentType)) {
                try {
                    part = evaluator.build(new ByteArrayInputStream(partBytes), "#part" + i);
                }
                catch (LuxException e) {
                    this.logger.warn("Caught an exception while parsing XML: " + e.getMessage() + ", treating it as plain text");
                    contentType = "text/plain; charset=" + charset;
                }
            }
            if (part == null) {
                String text;
                try {
                    text = new String(partBytes, charset);
                }
                catch (UnsupportedEncodingException e1) {
                    throw new LuxException(e1);
                }
                if (this.isHTML(contentType)) {
                    HtmlParser parser = new HtmlParser();
                    SAXSource source = new SAXSource((XMLReader)parser, new InputSource(new StringReader(text)));
                    try {
                        part = evaluator.getDocBuilder().build((Source)source);
                    }
                    catch (SaxonApiException e) {
                        e.printStackTrace();
                        this.logger.warn("failed to parse HTML; treating as plain text: " + e.getMessage());
                    }
                }
                if (part == null) {
                    part = new XdmNode((NodeInfo)new TextFragmentValue((CharSequence)text, "#part" + i));
                }
            }
            result.add((XdmItem)part);
            builder.startElement((NodeName)this.fQNameFor("http", EXPATH_HTTP_NS, "body"), (SchemaType)BuiltInAtomicType.UNTYPED_ATOMIC, 0, 0);
            this.addAttribute(builder, "position", "1");
            this.addAttribute(builder, "content-type", contentType);
            builder.startContent();
            builder.endElement();
        }
    }

    private boolean isText(String contentType) {
        return contentType.startsWith("text/") || this.isHTML(contentType) || this.isXML(contentType);
    }

    private boolean isHTML(String contentType) {
        return contentType.matches(".*/html($| )");
    }

    private boolean isXML(String contentType) {
        return contentType.matches(".*/xml($| )") || contentType.matches(".*\\+xml($| )");
    }

    private void addSimpleElement(LinkedTreeBuilder builder, String name, String text) throws XPathException {
        builder.startElement((NodeName)this.fQNameFor("http", EXPATH_HTTP_NS, name), (SchemaType)BuiltInAtomicType.STRING, 0, 0);
        builder.startContent();
        builder.characters((CharSequence)text, 0, 0);
        builder.endElement();
    }

    private void addAttribute(LinkedTreeBuilder builder, String name, String value) throws XPathException {
        builder.attribute((NodeName)this.fQNameFor("", "", name), (SimpleType)BuiltInAtomicType.UNTYPED_ATOMIC, (CharSequence)value, 0, 0);
    }

    public SolrIndexConfig getSolrIndexConfig() {
        return this.solrIndexConfig;
    }

    protected FingerprintedQName fQNameFor(String prefix, String namespace, String name) {
        return new FingerprintedQName(prefix, namespace, name);
    }

    protected QName qnameFor(String namespace, String localName) {
        return new QName(namespace, localName);
    }

    protected QName qnameFor(String localName) {
        return new QName(localName);
    }

    private String xmlEscape(String value) {
        return value.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll("\"", "&quot;");
    }

    public String getDescription() {
        return "XQuery";
    }

    public String getSource() {
        return "http://github.com/msokolov/lux";
    }

    public String getVersion() {
        return "";
    }
}

