/*
 * Decompiled with CFR 0.152.
 */
package lux.xquery;

import lux.xml.QName;
import lux.xpath.AbstractExpression;
import lux.xpath.ExpressionVisitor;
import lux.xquery.VariableContext;

public class Variable
extends AbstractExpression {
    private QName name;
    private AbstractExpression value;
    private String typeDesc;
    private VariableContext context;

    public Variable(QName qname) {
        super(AbstractExpression.Type.VARIABLE);
        this.name = qname;
    }

    public Variable(QName qname, String typeDesc) {
        super(AbstractExpression.Type.VARIABLE);
        this.name = qname;
        this.typeDesc = typeDesc;
    }

    @Override
    public AbstractExpression accept(ExpressionVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public void toString(StringBuilder buf) {
        buf.append('$');
        this.name.toString(buf);
        if (this.typeDesc != null) {
            buf.append(" as ").append(this.typeDesc);
        }
    }

    public QName getQName() {
        return this.name;
    }

    @Override
    public int getPrecedence() {
        return 0;
    }

    @Override
    public boolean isDocumentOrdered() {
        return false;
    }

    public void setName(QName name2) {
        this.name = name2;
    }

    public void setValue(AbstractExpression value) {
        this.value = value;
    }

    public AbstractExpression getValue() {
        return this.value;
    }

    @Override
    public AbstractExpression getRoot() {
        if (this.value == null) {
            return null;
        }
        return this.value.getRoot();
    }

    @Override
    public AbstractExpression getLastContextStep() {
        return this.getValue().getLastContextStep();
    }

    @Override
    public VariableContext getBindingContext() {
        return this.context;
    }

    public void setBindingContext(VariableContext context) {
        this.context = context;
    }
}

