/*
 * Decompiled with CFR 0.152.
 */
package lux;

import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import lux.CachingDocReader;
import lux.Evaluator;
import lux.exception.NotFoundException;
import lux.search.DocIterator;
import lux.search.LuxSearcher;
import net.sf.saxon.s9api.XdmNode;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class LuxURIResolver
implements URIResolver {
    private final URIResolver systemURIResolver;
    protected final Evaluator evaluator;
    protected final String uriFieldName;

    public LuxURIResolver(URIResolver systemURIResolver, Evaluator evaluator, String uriFieldName) {
        this.systemURIResolver = systemURIResolver;
        this.evaluator = evaluator;
        this.uriFieldName = uriFieldName;
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        boolean isFile;
        String path = href;
        if (href.matches("^\\w+:.*$")) {
            isFile = href.startsWith("file:");
            if (isFile) {
                path = href.substring(5);
            } else if (href.startsWith("lux:/")) {
                path = href.substring(5);
            }
        } else {
            isFile = base != null ? base.startsWith("file:") : false;
        }
        if (isFile) {
            return this.systemURIResolver.resolve(path, base);
        }
        path = path.replace('\\', '/');
        return this.getDocument(path).asSource();
    }

    public XdmNode getDocument(String uri) throws TransformerException {
        if (this.getSearcher() == null) {
            throw new IllegalStateException("Attempted search, but no searcher was provided");
        }
        try {
            DocIterator disi = this.getSearcher().search((Query)new TermQuery(new Term(this.uriFieldName, uri)));
            int docID = disi.nextDoc();
            if (docID == Integer.MAX_VALUE) {
                throw new NotFoundException(uri);
            }
            return this.getDocReader().get(docID, disi.getCurrentReaderContext());
        }
        catch (IOException e) {
            throw new TransformerException(e);
        }
    }

    public LuxSearcher getSearcher() {
        return this.evaluator.getSearcher();
    }

    public CachingDocReader getDocReader() {
        return this.evaluator.getDocReader();
    }
}

