/*
 * Decompiled with CFR 0.152.
 */
package lux;

import java.io.IOException;
import lux.CachingDocReader;
import lux.Evaluator;
import lux.SearchIteratorBase;
import lux.exception.LuxException;
import lux.search.DocIterator;
import lux.search.LuxSearcher;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.trans.XPathException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;

public class SearchResultIterator
extends SearchIteratorBase {
    private final Query query;
    private final DocIdSetIterator docIter;
    private final LuxSearcher searcher;
    private CachingDocReader docCache;

    public SearchResultIterator(Evaluator eval, Query query, String sortCriteria, int start1) throws IOException {
        super(eval, sortCriteria, start1);
        this.query = query;
        if (this.stats != null) {
            this.stats.query = query.toString();
        }
        this.searcher = eval.getSearcher();
        this.docCache = eval.getDocReader();
        if (this.searcher == null) {
            throw new LuxException("Attempted to search using an Evaluator that has no searcher");
        }
        if (sortCriteria != null) {
            Sort sort = this.makeSortFromCriteria(sortCriteria);
            this.docIter = this.searcher.search(query, sort);
        } else {
            this.docIter = this.searcher.searchOrdered(query);
        }
        if (this.start > 0) {
            this.advanceTo(start1);
        }
    }

    public NodeInfo next() throws XPathException {
        long t = System.nanoTime();
        int startPosition = this.position;
        try {
            int docID = this.docIter.nextDoc();
            if (docID == Integer.MAX_VALUE) {
                this.position = -1;
                this.current = null;
            } else {
                NodeInfo item;
                long t1 = System.nanoTime();
                XdmNode doc = this.sortCriteria == null ? this.docCache.get(docID, ((DocIterator)this.docIter).getCurrentReaderContext()) : this.docCache.get(docID, this.searcher.getIndexReader());
                this.current = item = (NodeInfo)doc.getUnderlyingValue();
                ++this.position;
                if (this.stats != null) {
                    this.stats.retrievalTime += System.nanoTime() - t1;
                }
            }
        }
        catch (IOException e) {
            throw new XPathException((Throwable)e);
        }
        finally {
            if (this.stats != null) {
                if (this.position >= 0) {
                    this.stats.docCount += this.position - startPosition;
                }
                this.stats.totalTime += System.nanoTime() - t;
            }
        }
        return this.current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void advanceTo(int startPosition) throws IOException {
        long t = System.nanoTime();
        int start0 = startPosition - 1;
        try {
            int docID = 0;
            this.current = null;
            while (this.position < start0) {
                docID = this.docIter.nextDoc();
                if (docID == Integer.MAX_VALUE) {
                    this.position = -1;
                    break;
                }
                ++this.position;
            }
            if (this.stats != null) {
                // empty if block
            }
        }
        finally {
            if (this.stats != null) {
                long t1 = System.nanoTime();
                this.stats.retrievalTime += t1 - t;
                this.stats.totalTime += t1 - t;
            }
        }
    }

    public SequenceIterator<NodeInfo> getAnother() throws XPathException {
        try {
            return new SearchResultIterator(this.eval, this.query, this.sortCriteria, this.start + 1);
        }
        catch (IOException e) {
            throw new XPathException((Throwable)e);
        }
    }
}

