/*
 * Decompiled with CFR 0.152.
 */
package lux.functions;

import java.io.IOException;
import lux.Evaluator;
import lux.functions.SearchBase;
import lux.search.DocIterator;
import lux.solr.CloudSearchIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.SequenceType;
import org.apache.lucene.search.Query;

public class Exists
extends SearchBase {
    public StructuredQName getFunctionQName() {
        return new StructuredQName("lux", "http://luxdb.net", "exists");
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_BOOLEAN;
    }

    public boolean trustResultType() {
        return true;
    }

    public UnfailingIterator<BooleanValue> iterate(Query query, Evaluator saxon, String sortCriteria, int start) throws XPathException {
        long t = System.currentTimeMillis();
        boolean exists = false;
        try {
            DocIterator iter = saxon.getSearcher().search(query);
            exists = iter.nextDoc() != Integer.MAX_VALUE;
        }
        catch (IOException e) {
            throw new XPathException((Throwable)e);
        }
        saxon.getQueryStats().totalTime = System.currentTimeMillis() - t;
        if (exists) {
            ++saxon.getQueryStats().docCount;
        }
        return SingletonIterator.makeIterator((Item)BooleanValue.get((boolean)exists));
    }

    protected UnfailingIterator<BooleanValue> iterateDistributed(String query, SearchBase.QueryParser queryParser, Evaluator eval, String sortCriteria, int start) throws XPathException {
        try {
            long count = new CloudSearchIterator(eval, query, queryParser, sortCriteria, start).count();
            return SingletonIterator.makeIterator((Item)BooleanValue.get((count > 0L ? 1 : 0) != 0));
        }
        catch (Exception e) {
            throw new XPathException((Throwable)e);
        }
    }
}

