/*
 * Decompiled with CFR 0.152.
 */
package lux.functions;

import java.util.ArrayList;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import lux.Evaluator;
import lux.TransformErrorListener;
import lux.functions.InterpreterCall;
import lux.functions.SearchBase;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;

public class Transform
extends ExtensionFunctionDefinition {
    public StructuredQName getFunctionQName() {
        return new StructuredQName("lux", "http://luxdb.net", "transform");
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_NODE, SequenceType.SINGLE_NODE, SequenceType.ANY_SEQUENCE};
    }

    public int getMinimumNumberOfArguments() {
        return 2;
    }

    public int getMaximumNumberOfArguments() {
        return 3;
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_NODE;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new TransformCall();
    }

    class TransformCall
    extends InterpreterCall {
        private XsltTransformer transformer;

        TransformCall() {
        }

        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            NodeInfo stylesheet = (NodeInfo)arguments[0].head();
            NodeInfo node = (NodeInfo)arguments[1].head();
            Evaluator eval = SearchBase.getEvaluator(context);
            XsltCompiler xsltCompiler = eval.getCompiler().getXsltCompiler();
            xsltCompiler.setErrorListener((ErrorListener)eval.getErrorListener());
            try {
                XsltExecutable xsltexec = xsltCompiler.compile((Source)stylesheet);
                this.transformer = xsltexec.load();
                this.transformer.setSource((Source)node);
                this.transformer.setErrorListener((ErrorListener)eval.getErrorListener());
                if (arguments.length > 2) {
                    this.bindParameters(arguments[2]);
                }
                XdmDestination dest = new XdmDestination();
                this.transformer.setDestination((Destination)dest);
                this.transformer.transform();
                ArrayList<TransformerException> runtimeErrors = ((TransformErrorListener)this.transformer.getErrorListener()).getErrors();
                if (!runtimeErrors.isEmpty()) {
                    throw new XPathException(runtimeErrors.get(0).getMessage(), runtimeErrors.get(0).getLocator(), (Throwable)runtimeErrors.get(0));
                }
                XdmNode result = dest.getXdmNode();
                if (result == null) {
                    return EmptySequence.getInstance();
                }
                return result.getUnderlyingNode();
            }
            catch (SaxonApiException e) {
                throw new XPathException((Throwable)e);
            }
        }

        @Override
        protected void setParameter(StructuredQName name, Item value) {
            this.transformer.getUnderlyingController().setParameter(name, (Sequence)value);
        }
    }
}

