/*
 * Decompiled with CFR 0.152.
 */
package lux.index.field;

import lux.exception.LuxException;
import lux.index.XmlIndexer;
import lux.index.field.FieldValues;
import lux.query.RangePQuery;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.SortField;

public abstract class FieldDefinition {
    private final String name;
    private final boolean renameable;
    private final Type type;
    private final Analyzer analyzer;
    private final Field.Store isStored;

    public boolean isRenameable() {
        return this.renameable;
    }

    public FieldDefinition(String name, Analyzer analyzer, Field.Store isStored, Type type, boolean renameable) {
        this.name = name;
        this.analyzer = analyzer;
        this.isStored = isStored;
        this.type = type;
        this.renameable = renameable;
        if (analyzer != null && type != Type.STRING && type != Type.TEXT && type != Type.TOKENS && type != Type.SOLR_FIELD) {
            throw new LuxException("Unexpected combination of analyzer and field " + name + " of type: " + (Object)((Object)type));
        }
    }

    public FieldDefinition(String name, Analyzer analyzer, Field.Store isStored, Type type) {
        this(name, analyzer, isStored, type, false);
    }

    public Iterable<? extends IndexableField> getFieldValues(XmlIndexer indexer) {
        Iterable<?> values = this.getValues(indexer);
        if (values == null) {
            throw new LuxException(this.getClass().getName() + ".getValues() returned null: did you neglect to implement it?");
        }
        return new FieldValues(indexer.getConfiguration(), this, values);
    }

    public Iterable<?> getValues(XmlIndexer indexer) {
        return null;
    }

    public String getDefaultName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public Field.Store isStored() {
        return this.isStored;
    }

    public boolean isSingleValued() {
        return false;
    }

    public int getSolrFieldProperties() {
        int options = 0;
        if (this.type != Type.BYTES) {
            options |= 1;
        }
        if (this.analyzer != null) {
            options = this.analyzer instanceof KeywordAnalyzer ? (options |= 0x20) : (options |= 2);
        }
        if (this.isStored == Field.Store.YES) {
            options |= 4;
        }
        if (!this.isSingleValued()) {
            options |= 0x200;
        }
        if (this.type != Type.TOKENS) {
            options |= 0x10;
        }
        return options;
    }

    public String toString() {
        return this.name;
    }

    public static enum Type {
        TOKENS(SortField.Type.DOC, RangePQuery.Type.STRING),
        STRING(SortField.Type.STRING, RangePQuery.Type.STRING),
        BYTES(SortField.Type.BYTES, null),
        INT(SortField.Type.INT, RangePQuery.Type.INT),
        LONG(SortField.Type.LONG, RangePQuery.Type.LONG),
        TEXT(SortField.Type.DOC, RangePQuery.Type.STRING),
        SOLR_FIELD(SortField.Type.STRING, RangePQuery.Type.STRING);

        private SortField.Type sortFieldType;
        private RangePQuery.Type rangeTermType;

        private Type(SortField.Type sortFieldType, RangePQuery.Type rangeTermType) {
            this.sortFieldType = sortFieldType;
            this.rangeTermType = rangeTermType;
        }

        public SortField.Type getLuceneSortFieldType() {
            return this.sortFieldType;
        }

        public RangePQuery.Type getRangeTermType() {
            return this.rangeTermType;
        }
    }
}

