/*
 * Decompiled with CFR 0.152.
 */
package lux.index.field;

import java.util.Iterator;
import lux.exception.LuxException;
import lux.index.XmlIndexer;
import lux.index.field.FieldDefinition;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.apache.solr.schema.SchemaField;

public class XPathField
extends FieldDefinition {
    private final String xpath;
    private final SchemaField schemaField;

    public XPathField(String name, String xpath, Analyzer analyzer, Field.Store isStored, FieldDefinition.Type type) {
        super(name, analyzer, isStored, type);
        this.xpath = xpath;
        this.schemaField = null;
    }

    public XPathField(String name, String xpath, Analyzer analyzer, Field.Store isStored, SchemaField schemaField) {
        super(name, analyzer, isStored, FieldDefinition.Type.SOLR_FIELD);
        this.xpath = xpath;
        this.schemaField = schemaField;
    }

    public String getXPath() {
        return this.xpath;
    }

    @Override
    public Iterable<?> getValues(XmlIndexer indexer) {
        XdmValue value;
        try {
            value = indexer.evaluateXPath(this.xpath);
        }
        catch (SaxonApiException e) {
            throw new LuxException("error getting values for field: " + this.getDefaultName(), e);
        }
        return new XPathValueIterator(value.iterator());
    }

    public SchemaField getSchemaField() {
        return this.schemaField;
    }

    class XPathValueIterator
    implements Iterator<Object>,
    Iterable<Object> {
        private final XdmSequenceIterator sequence;

        XPathValueIterator(XdmSequenceIterator sequence) {
            this.sequence = sequence;
        }

        @Override
        public boolean hasNext() {
            return this.sequence.hasNext();
        }

        @Override
        public Object next() {
            XdmItem item = this.sequence.next();
            String stringValue = item.getStringValue();
            switch (XPathField.this.getType()) {
                case STRING: 
                case TEXT: {
                    return stringValue;
                }
                case INT: {
                    return Integer.valueOf(stringValue);
                }
                case LONG: {
                    return Long.valueOf(stringValue);
                }
                case SOLR_FIELD: {
                    return XPathField.this.getSchemaField().createField((Object)stringValue, 1.0f);
                }
            }
            throw new IllegalStateException((Object)((Object)XPathField.this.getType()) + " is not a valid type for an XPathField");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Object> iterator() {
            return this;
        }
    }
}

