/*
 * Decompiled with CFR 0.152.
 */
package lux.search;

import java.io.IOException;
import lux.search.LuxSearcher;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;

class TopDocsIterator
extends DocIdSetIterator {
    private final LuxSearcher searcher;
    private final Query query;
    private final Sort sort;
    private int docID = -1;
    private int iDocNext = 0;
    private TopDocs topDocs;
    private static final int BATCH_SIZE = 200;

    TopDocsIterator(LuxSearcher luxSearcher, Query query, Sort sort) throws IOException {
        this.searcher = luxSearcher;
        this.query = query;
        this.sort = sort;
        this.topDocs = this.searcher.search(this.searcher.createNormalizedWeight(query), 200, sort, false, false);
    }

    public int docID() {
        return this.docID;
    }

    public int nextDoc() throws IOException {
        if (this.iDocNext < this.topDocs.scoreDocs.length) {
            this.docID = this.topDocs.scoreDocs[this.iDocNext++].doc;
        } else if (this.iDocNext < this.topDocs.totalHits) {
            this.topDocs = this.searcher.search(this.searcher.createNormalizedWeight(this.query), this.iDocNext + 200, this.sort, false, false);
        } else {
            this.docID = Integer.MAX_VALUE;
        }
        return this.docID;
    }

    public int advance(int target) throws IOException {
        return Integer.MAX_VALUE;
    }

    public long cost() {
        return 0L;
    }
}

