/*
 * Decompiled with CFR 0.152.
 */
package lux.search.highlight;

import java.io.IOException;
import java.util.ArrayList;
import lux.xml.QName;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.AttributeSource;

public final class StreamingElementTokens
extends TokenStream {
    private TokenStream wrapped;
    private final CharTermAttribute termAtt;
    private final PositionIncrementAttribute posIncrAtt;
    private final CharTermAttribute term;
    private ArrayList<QName> qnames;
    private int qnamePos = -1;

    public boolean isPlainToken() {
        return this.termAtt.length() == this.term.length();
    }

    public StreamingElementTokens(TokenStream tokens) {
        super((AttributeSource)tokens);
        this.wrapped = tokens;
        this.termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        this.posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
        this.term = new CharTermAttributeImpl();
        this.qnames = new ArrayList();
    }

    public void pushElement(QName qname) {
        this.qnames.add(qname);
    }

    public void popElement() {
        this.qnames.remove(this.qnames.size() - 1);
    }

    public boolean incrementToken() throws IOException {
        if (this.qnamePos < 0) {
            if (!this.wrapped.incrementToken()) {
                return false;
            }
            this.qnamePos = this.qnames.size() - 1;
            this.term.setEmpty();
            this.term.append(this.termAtt);
            return true;
        }
        QName qname = this.qnames.get(this.qnamePos--);
        this.termAtt.setEmpty();
        this.termAtt.append(qname.getEncodedName());
        this.termAtt.append(':');
        this.termAtt.append(this.term);
        this.posIncrAtt.setPositionIncrement(0);
        return true;
    }

    public void reset(TokenStream tokens) throws IOException {
        this.wrapped = tokens;
        this.reset();
    }

    public void reset() throws IOException {
        super.reset();
        this.wrapped.reset();
    }
}

