/*
 * Decompiled with CFR 0.152.
 */
package lux.search.highlight;

import java.io.IOException;
import java.io.Reader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import lux.exception.LuxException;
import lux.index.FieldName;
import lux.index.IndexConfiguration;
import lux.index.analysis.DefaultAnalyzer;
import lux.index.analysis.XmlTextTokenStream;
import lux.search.highlight.HighlightFormatter;
import lux.search.highlight.StreamingElementTokens;
import lux.search.highlight.TokenGroup;
import lux.xml.QName;
import lux.xml.SaxonDocBuilder;
import lux.xml.XmlReader;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.tree.tiny.TinyDocumentImpl;
import org.apache.commons.io.input.CharSequenceReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.TextFragment;

public class XmlHighlighter
extends SaxonDocBuilder {
    private final HighlightFormatter highlighter;
    private QueryScorer scorer;
    private final XmlStreamTextReader textReader;
    private XMLStreamReader xmlStreamReader;
    private StreamingElementTokens xmlStreamTokens;
    private TokenStream scorerTokens;
    private OffsetAttribute offsetAtt;
    private TokenGroup tokenGroup;
    private int startOffset;
    private int endOffset;
    private int lastEndOffset = 0;
    private int maxDocCharsToAnalyze = Integer.MAX_VALUE;
    private String textFieldName;
    private Analyzer analyzer;

    public XmlHighlighter(Processor processor, IndexConfiguration indexConfig, HighlightFormatter highlighter) {
        super(processor);
        this.textFieldName = indexConfig.getFieldName(FieldName.XML_TEXT);
        this.analyzer = indexConfig.getFieldAnalyzers();
        this.highlighter = highlighter;
        this.textReader = new XmlStreamTextReader();
        try {
            this.xmlStreamTokens = new StreamingElementTokens(this.analyzer.tokenStream(this.textFieldName, (Reader)this.textReader));
            this.offsetAtt = (OffsetAttribute)this.xmlStreamTokens.addAttribute(OffsetAttribute.class);
            this.xmlStreamTokens.addAttribute(PositionIncrementAttribute.class);
        }
        catch (IOException e) {
            throw new LuxException(e);
        }
        this.tokenGroup = new TokenGroup(this.xmlStreamTokens);
    }

    public XdmNode highlight(Query query, NodeInfo node) throws XMLStreamException, SaxonApiException {
        if (this.needsPositions(query)) {
            query = this.replaceFields(query, this.textFieldName);
        }
        this.scorer = new QueryScorer(query);
        DefaultAnalyzer defaultAnalyzer = new DefaultAnalyzer();
        TokenStream textTokens = null;
        try {
            textTokens = defaultAnalyzer.tokenStream("xml_text", (Reader)new CharSequenceReader((CharSequence)""));
        }
        catch (IOException e) {
            // empty catch block
        }
        this.init(new XmlTextTokenStream("xml_text", defaultAnalyzer, textTokens, new XdmNode(node), null));
        XmlReader xmlReader = new XmlReader();
        xmlReader.addHandler(this);
        xmlReader.read(node);
        if (this.getDocument().getUnderlyingNode() instanceof TinyDocumentImpl) {
            ((TinyDocumentImpl)this.getDocument().getUnderlyingNode()).setBaseURI(node.getSystemId());
        }
        return this.getDocument();
    }

    private Query replaceFields(Query query, String fieldName) {
        TermQuery tq;
        if (query instanceof PhraseQuery) {
            PhraseQuery pq = new PhraseQuery();
            for (Term t : ((PhraseQuery)query).getTerms()) {
                if (t.field().equals(fieldName)) {
                    return query;
                }
                pq.add(this.replaceField(fieldName, t));
            }
            return pq;
        }
        if (query instanceof BooleanQuery) {
            for (BooleanClause clause : ((BooleanQuery)query).getClauses()) {
                clause.setQuery(this.replaceFields(clause.getQuery(), fieldName));
            }
            return query;
        }
        if (query instanceof TermQuery && !(tq = (TermQuery)query).getTerm().field().equals(fieldName)) {
            return new TermQuery(new Term(fieldName, tq.getTerm().text().split(":")[1]));
        }
        return query;
    }

    private Term replaceField(String fieldName, Term t) {
        String[] parts = t.text().split(":");
        if (parts.length > 1) {
            return new Term(fieldName, parts[1]);
        }
        return new Term(fieldName, t.text());
    }

    private boolean needsPositions(Query query) {
        if (query instanceof PhraseQuery) {
            return true;
        }
        if (query instanceof BooleanQuery) {
            for (BooleanClause clause : ((BooleanQuery)query).getClauses()) {
                if (!this.needsPositions(clause.getQuery())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void reset() {
        super.reset();
    }

    private void init(TokenStream tokenStream) {
        try {
            tokenStream.reset();
            this.scorer.setMaxDocCharsToAnalyze(this.maxDocCharsToAnalyze);
            this.scorerTokens = this.scorer.init(tokenStream);
            if (this.scorerTokens == null) {
                this.scorer.init((TokenStream)this.xmlStreamTokens);
            }
            this.scorer.startFragment(new TextFragment((CharSequence)"", 0, 0));
        }
        catch (IOException e) {
            throw new LuxException(e);
        }
    }

    @Override
    public void handleEvent(XMLStreamReader reader, int eventType) throws XMLStreamException {
        switch (eventType) {
            case 7: {
                this.xmlStreamReader = reader;
                super.handleEvent(reader, eventType);
                break;
            }
            case 1: {
                super.handleEvent(reader, eventType);
                this.xmlStreamTokens.pushElement(new QName(reader.getNamespaceURI(), reader.getLocalName(), reader.getPrefix()));
                break;
            }
            case 2: {
                super.handleEvent(reader, eventType);
                this.xmlStreamTokens.popElement();
                break;
            }
            case 3: 
            case 5: {
                super.handleEvent(reader, eventType);
                break;
            }
            case 12: {
                throw new XMLStreamException("unexpected CDATA event");
            }
            case 6: {
                super.handleEvent(reader, eventType);
                break;
            }
            case 4: {
                this.textReader.text();
                try {
                    this.highlightTextNode();
                    break;
                }
                catch (IOException e) {
                    throw new XMLStreamException(e);
                }
            }
            case 9: {
                throw new XMLStreamException("unexpected entity reference event");
            }
            default: {
                super.handleEvent(reader, eventType);
            }
        }
    }

    private void highlightTextNode() throws IOException, XMLStreamException {
        this.xmlStreamTokens.reset(this.analyzer.tokenStream(this.textFieldName, (Reader)this.textReader));
        this.lastEndOffset = 0;
        boolean next = this.xmlStreamTokens.incrementToken();
        while (next && this.offsetAtt.startOffset() < this.maxDocCharsToAnalyze) {
            if (this.scorerTokens != null && this.xmlStreamTokens.isPlainToken()) {
                this.scorerTokens.incrementToken();
            }
            if (this.tokenGroup.isDistinct()) {
                this.handleTokenGroup();
                this.tokenGroup.clear();
            }
            if (this.scorerTokens == null || this.xmlStreamTokens.isPlainToken()) {
                this.tokenGroup.addToken(this.scorer.getTokenScore());
            }
            next = this.xmlStreamTokens.incrementToken();
        }
        this.handleTokenGroup();
        this.tokenGroup.clear();
        this.writeTrailingText();
    }

    private void writeTrailingText() throws XMLStreamException {
        int textOffset = this.lastEndOffset;
        int totalTextLength = this.xmlStreamReader.getTextStart() + this.xmlStreamReader.getTextLength();
        if (textOffset < totalTextLength) {
            this.writeText(this.lastEndOffset, totalTextLength);
        }
    }

    private void handleTokenGroup() throws XMLStreamException {
        if (this.tokenGroup.numTokens > 0) {
            this.startOffset = this.tokenGroup.matchStartOffset;
            this.endOffset = this.tokenGroup.matchEndOffset;
            if (this.startOffset > this.lastEndOffset) {
                this.writeText(this.lastEndOffset, this.startOffset);
            }
            if (this.tokenGroup.getTotalScore() > 0.0f) {
                char[] tokenText = new char[this.endOffset - this.startOffset];
                this.xmlStreamReader.getTextCharacters(this.startOffset, tokenText, 0, this.endOffset - this.startOffset);
                this.highlighter.highlightTerm((XMLStreamWriter)this.writer, new String(tokenText));
            } else {
                this.writeText(this.startOffset, this.endOffset);
            }
            this.lastEndOffset = Math.max(this.lastEndOffset, this.endOffset);
        }
    }

    private void writeText(int start, int end) throws XMLStreamException {
        int length = end - start;
        this.writer.writeCharacters(this.xmlStreamReader.getTextCharacters(), start, length);
    }

    final class XmlStreamTextReader
    extends Reader {
        private int offset;
        private int len;
        private int pos;

        XmlStreamTextReader() {
        }

        void text() {
            this.pos = 0;
            this.offset = XmlHighlighter.this.xmlStreamReader.getTextStart();
            this.len = XmlHighlighter.this.xmlStreamReader.getTextLength();
        }

        @Override
        public void close() {
        }

        @Override
        public int read(char[] target, int off, int count) throws IOException {
            if (this.remaining() <= 0) {
                return -1;
            }
            int nread = this.remaining() > count ? count : this.remaining();
            try {
                XmlHighlighter.this.xmlStreamReader.getTextCharacters(this.offset + this.pos, target, off, nread);
            }
            catch (XMLStreamException e) {
                throw new IOException(e);
            }
            this.pos += nread;
            return nread;
        }

        private int remaining() {
            return this.len - this.pos;
        }

        public int length() {
            return this.len;
        }
    }
}

