/*
 * Decompiled with CFR 0.152.
 */
package lux.solr;

import lux.Evaluator;
import lux.SearchIteratorBase;
import lux.exception.LuxException;
import lux.functions.SearchBase;
import lux.index.FieldName;
import lux.index.IndexConfiguration;
import lux.index.field.IDField;
import lux.solr.CloudQueryRequest;
import lux.solr.SolrQueryContext;
import lux.solr.XQueryComponent;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.trans.XPathException;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.SortSpec;

public class CloudSearchIterator
extends SearchIteratorBase {
    private int limit = 20;
    private SolrQueryResponse response;
    private final String query;
    private final SearchBase.QueryParser queryParser;
    private final String xmlFieldName;
    private final String uriFieldName;
    private final String idFieldName;

    public CloudSearchIterator(Evaluator eval, String query, SearchBase.QueryParser queryParser, String sortCriteria, int start1) {
        super(eval, sortCriteria, start1);
        this.queryParser = queryParser;
        this.query = query;
        IndexConfiguration indexConfig = eval.getCompiler().getIndexConfiguration();
        this.xmlFieldName = indexConfig.getFieldName(FieldName.XML_STORE);
        this.uriFieldName = indexConfig.getFieldName(FieldName.URI);
        this.idFieldName = indexConfig.getFieldName(IDField.getInstance());
    }

    public SequenceIterator<NodeInfo> getAnother() throws XPathException {
        return new CloudSearchIterator(this.eval, this.query, this.queryParser, this.sortCriteria, this.start + 1);
    }

    public long count() {
        SolrDocumentList docs;
        if (this.response == null) {
            this.limit = 0;
            this.doCloudSearch();
        }
        if ((docs = (SolrDocumentList)this.response.getValues().get("response")) == null) {
            return 0L;
        }
        return docs.getNumFound();
    }

    public NodeInfo next() throws XPathException {
        while (true) {
            if (this.response != null) {
                SolrDocumentList docs = (SolrDocumentList)this.response.getValues().get("response");
                if (docs == null) {
                    return null;
                }
                if ((long)this.position < docs.getStart() + (long)docs.size()) {
                    SolrDocument doc = (SolrDocument)docs.get(this.position++ - (int)docs.getStart());
                    String uri = (String)doc.getFirstValue(this.uriFieldName);
                    Object oxml = doc.getFirstValue(this.xmlFieldName);
                    Long id = (Long)doc.getFirstValue(this.idFieldName);
                    if (id == null) {
                        throw new LuxException("This index has no lux docids: it cannot support Lux on Solr Cloud");
                    }
                    String xml = (String)(oxml instanceof String ? oxml : null);
                    byte[] bytes = (byte[])(oxml instanceof byte[] ? oxml : null);
                    XdmNode node = this.eval.getDocReader().createXdmNode(id, uri, xml, bytes);
                    DocumentInfo docNode = node.getUnderlyingNode().getDocumentRoot();
                    docNode.setUserData(SolrDocument.class.getName(), (Object)doc);
                    return docNode;
                }
                if ((long)this.position >= docs.getNumFound()) {
                    return null;
                }
            }
            this.doCloudSearch();
        }
    }

    private void doCloudSearch() {
        ResponseBuilder origRB = ((SolrQueryContext)this.eval.getQueryContext()).getResponseBuilder();
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.add("q", new String[]{this.query});
        if (SearchBase.QueryParser.XML == this.queryParser) {
            params.add("defType", new String[]{"xml"});
        }
        params.add("start", new String[]{Integer.toString(this.position)});
        params.add("rows", new String[]{Integer.toString(this.limit)});
        params.add("fl", new String[]{"*"});
        SolrParams origParams = origRB.req.getParams();
        String debug = origParams.get("debug");
        if (debug != null) {
            params.add("debug", new String[]{debug});
        }
        params.add("distrib", new String[]{"true"});
        params.add("shards", new String[]{origParams.get("shards")});
        SortSpec sortSpec = this.makeSortSpec();
        this.addSortParam(params, sortSpec);
        XQueryComponent xqueryComponent = ((SolrQueryContext)this.eval.getQueryContext()).getQueryComponent();
        CloudQueryRequest req = new CloudQueryRequest(xqueryComponent.getCore(), (SolrParams)params, sortSpec);
        this.response = new SolrQueryResponse();
        xqueryComponent.getSearchHandler().handleRequest((SolrQueryRequest)req, this.response);
        SolrDocumentList docs = (SolrDocumentList)this.response.getValues().get("response");
        if (docs != null) {
            this.eval.getQueryStats().docCount = (int)((long)this.eval.getQueryStats().docCount + docs.getNumFound());
        }
    }

    private void addSortParam(ModifiableSolrParams params, SortSpec sortSpec) {
        for (SortField sortField : sortSpec.getSort().getSort()) {
            String dir = sortField.getReverse() ? "desc" : "asc";
            String field = sortField.getField();
            if (field == null) continue;
            params.add("sort", new String[]{sortField.getField() + ' ' + dir});
        }
    }

    private String getEffectiveSortCriteria() {
        if (this.sortCriteria != null) {
            return this.sortCriteria + ',' + this.idFieldName;
        }
        return this.idFieldName;
    }

    private SortSpec makeSortSpec() {
        Sort sort = this.sortCriteria != null ? this.makeSortFromCriteria(this.getEffectiveSortCriteria()) : new Sort(new SortField(this.idFieldName, SortField.Type.LONG));
        return new SortSpec(sort, this.position, this.limit);
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }
}

