/*
 * Decompiled with CFR 0.152.
 */
package lux.xml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import lux.xml.EventToStaxBridge;
import lux.xml.StAXHandler;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.evpull.BracketedDocumentIterator;
import net.sf.saxon.evpull.Decomposer;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.PullEvent;
import net.sf.saxon.evpull.SingletonEventIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NodeInfo;
import org.codehaus.stax2.XMLInputFactory2;

public class XmlReader {
    private XMLInputFactory inputFactory;
    private ArrayList<StAXHandler> handlers = new ArrayList();
    private boolean stripNamespaces;

    public void read(Reader reader) throws XMLStreamException {
        XMLStreamReader xmlStreamReader = this.getXMLInputFactory().createXMLStreamReader(reader);
        if (this.stripNamespaces) {
            xmlStreamReader = new NamespaceStrippingXMLStreamReader(xmlStreamReader);
        }
        this.read(xmlStreamReader);
    }

    public void read(InputStream in) throws XMLStreamException {
        XMLStreamReader xmlStreamReader = this.getXMLInputFactory().createXMLStreamReader(in);
        if (this.stripNamespaces) {
            xmlStreamReader = new NamespaceStrippingXMLStreamReader(xmlStreamReader);
        }
        this.read(xmlStreamReader);
    }

    public void read(NodeInfo node) throws XMLStreamException {
        XMLStreamReader xmlStreamReader;
        Configuration configuration = node.getConfiguration();
        if (configuration == null) {
            throw new XMLStreamException("Attempt to parse non-XML node");
        }
        PipelineConfiguration pipe = configuration.makePipelineConfiguration();
        pipe.setHostLanguage(51);
        if (node instanceof DocumentInfo) {
            Decomposer eventIterator = new Decomposer(node, pipe);
            xmlStreamReader = new EventToStaxBridge((EventIterator)eventIterator, pipe);
        } else {
            SingletonEventIterator contentIterator = new SingletonEventIterator((PullEvent)node);
            BracketedDocumentIterator eventIterator = new BracketedDocumentIterator((EventIterator)contentIterator);
            eventIterator = new Decomposer((EventIterator)eventIterator, pipe);
            xmlStreamReader = new EventToStaxBridge((EventIterator)eventIterator, pipe);
        }
        if (this.stripNamespaces) {
            xmlStreamReader = new NamespaceStrippingXMLStreamReader(xmlStreamReader);
        }
        this.read(xmlStreamReader);
    }

    private XMLInputFactory getXMLInputFactory() {
        if (this.inputFactory == null) {
            this.inputFactory = XMLInputFactory2.newInstance();
            this.inputFactory.setProperty("javax.xml.stream.isCoalescing", false);
            this.inputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", true);
            this.inputFactory.setProperty("org.codehaus.stax2.reportPrologWhitespace", false);
            this.inputFactory.setProperty("javax.xml.stream.resolver", new XMLResolver(){

                @Override
                public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
                    return new ByteArrayInputStream(new byte[0]);
                }
            });
            this.inputFactory.setProperty("com.ctc.wstx.treatCharRefsAsEnts", true);
            this.inputFactory.setProperty("com.ctc.wstx.minTextSegment", 1);
        }
        return this.inputFactory;
    }

    public void addHandler(StAXHandler handler) {
        this.handlers.add(handler);
    }

    public List<StAXHandler> getHandlers() {
        return this.handlers;
    }

    public void read(XMLStreamReader in) throws XMLStreamException {
        boolean gotEndDocument = false;
        this.sendEvent(in, 7);
        while (in.hasNext()) {
            int event = in.next();
            if (event == 7) continue;
            this.sendEvent(in, event);
            if (event != 8) continue;
            gotEndDocument = true;
        }
        if (!gotEndDocument) {
            this.sendEvent(in, 8);
        }
    }

    private void sendEvent(XMLStreamReader in, int event) throws XMLStreamException {
        for (StAXHandler handler : this.handlers) {
            handler.handleEvent(in, event);
        }
    }

    public void reset() {
        for (StAXHandler handler : this.handlers) {
            handler.reset();
        }
    }

    public boolean isStripNamespaces() {
        return this.stripNamespaces;
    }

    public void setStripNamespaces(boolean stripNamespaces) {
        this.stripNamespaces = stripNamespaces;
    }

    class NamespaceStrippingXMLStreamReader
    extends StreamReaderDelegate
    implements NamespaceContext {
        public NamespaceStrippingXMLStreamReader(XMLStreamReader xmlStreamReader) {
            super(xmlStreamReader);
        }

        @Override
        public String getPrefix() {
            return "";
        }

        @Override
        public String getNamespaceURI() {
            return "";
        }

        @Override
        public int getNamespaceCount() {
            return 0;
        }

        @Override
        public String getNamespaceURI(int i) {
            return "";
        }

        @Override
        public String getNamespaceURI(String s) {
            return "";
        }

        @Override
        public String getAttributePrefix(int i) {
            return "";
        }

        @Override
        public String getAttributeNamespace(int i) {
            return "";
        }

        @Override
        public NamespaceContext getNamespaceContext() {
            return this;
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return "";
        }

        @Override
        public Iterator<String> getPrefixes(String namespaceURI) {
            return new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public String next() {
                    return null;
                }

                @Override
                public void remove() {
                }
            };
        }
    }
}

