/*
 * Decompiled with CFR 0.152.
 */
package lux.xquery;

import lux.xpath.AbstractExpression;
import lux.xpath.ExpressionVisitor;

public class AttributeConstructor
extends AbstractExpression {
    public AttributeConstructor(AbstractExpression name, AbstractExpression content) {
        super(AbstractExpression.Type.ATTRIBUTE);
        this.subs = new AbstractExpression[]{name, content};
    }

    @Override
    public AbstractExpression accept(ExpressionVisitor visitor) {
        this.acceptSubs(visitor);
        return visitor.visit(this);
    }

    @Override
    public void toString(StringBuilder buf) {
        buf.append("attribute ");
        buf.append("{ ");
        this.getName().toString(buf);
        buf.append(" } { ");
        this.appendValue(buf);
        buf.append(" }");
    }

    public void appendValue(StringBuilder buf) {
        String c = this.getContent().toString();
        if (this.getContent().getType() == AbstractExpression.Type.LITERAL) {
            c = c.replace("\r", "&#xD;").replace("\n", "&#xA;");
        }
        buf.append(c);
    }

    public final AbstractExpression getName() {
        return this.subs[0];
    }

    public final AbstractExpression getContent() {
        return this.subs[1];
    }

    @Override
    public int getPrecedence() {
        return 0;
    }
}

