/*
 * Decompiled with CFR 0.152.
 */
package lux;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import lux.Config;
import lux.DocIDNumberAllocator;
import lux.QueryStats;
import lux.compiler.EXPathSupport;
import lux.compiler.PathOptimizer;
import lux.compiler.SaxonTranslator;
import lux.exception.LuxException;
import lux.functions.ExtensionFunctions;
import lux.functions.LuxFunctionLibrary;
import lux.functions.file.FileExtensions;
import lux.index.FieldName;
import lux.index.IndexConfiguration;
import lux.index.field.FieldDefinition;
import lux.index.field.XPathField;
import lux.xml.GentleXmlReader;
import lux.xpath.AbstractExpression;
import lux.xpath.NodeTest;
import lux.xpath.PathStep;
import lux.xpath.PropEquiv;
import lux.xquery.XQuery;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.CollectionURIResolver;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.tree.util.DocumentNumberAllocator;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;

public class Compiler {
    private final Logger logger;
    private final Processor processor;
    private final CollectionURIResolver defaultCollectionURIResolver;
    private final String uriFieldName;
    private final IndexConfiguration indexConfig;
    private final boolean isSaxonLicensed;
    private final HashMap<PropEquiv, ArrayList<AbstractExpression>> fieldLeaves;
    private final HashMap<AbstractExpression, XPathField> fieldExpressions;
    private final HashMap<String, String> namespaceBindings;
    private final PropEquiv tempEquiv;
    private SearchStrategy searchStrategy;

    public Compiler(IndexConfiguration config) {
        this(Compiler.makeProcessor(), config);
    }

    public Compiler(Processor processor, IndexConfiguration indexConfig) {
        this.indexConfig = indexConfig;
        this.processor = processor;
        Configuration config = processor.getUnderlyingConfiguration();
        config.setDocumentNumberAllocator((DocumentNumberAllocator)new DocIDNumberAllocator());
        config.setConfigurationProperty("http://saxon.sf.net/feature/xqueryPreserveNamespaces", (Object)false);
        this.namespaceBindings = new HashMap();
        this.namespaceBindings.put("lux", "http://luxdb.net");
        GentleXmlReader parser = new GentleXmlReader();
        config.getParseOptions().setEntityResolver((EntityResolver)parser);
        config.setSourceParserClass("lux.xml.GentleXmlReader");
        boolean bl = this.isSaxonLicensed = config.isLicensedFeature(8) || config.isLicensedFeature(4);
        this.searchStrategy = indexConfig == null || !indexConfig.isIndexingEnabled() ? SearchStrategy.NONE : (this.isSaxonLicensed ? SearchStrategy.SAXON_LICENSE : SearchStrategy.LUX_SEARCH);
        this.defaultCollectionURIResolver = config.getCollectionURIResolver();
        this.registerExtensionFunctions();
        this.uriFieldName = indexConfig.getFieldName(FieldName.URI);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.fieldLeaves = new HashMap();
        this.fieldExpressions = new HashMap();
        this.tempEquiv = new PropEquiv(null);
        this.compileFieldExpressions();
    }

    public XQueryExecutable compile(String exprString) throws LuxException {
        return this.compile(exprString, null, null, null);
    }

    public XQueryExecutable compile(String exprString, ErrorListener errorListener) throws LuxException {
        return this.compile(exprString, errorListener, null, null);
    }

    public XQueryExecutable compile(String exprString, ErrorListener errorListener, QueryStats stats) throws LuxException {
        return this.compile(exprString, errorListener, null, stats);
    }

    public XQueryExecutable compile(String exprString, ErrorListener errorListener, URI baseURI, QueryStats stats) throws LuxException {
        XQueryExecutable xquery;
        XQueryCompiler xQueryCompiler = this.getXQueryCompiler();
        if (errorListener != null) {
            xQueryCompiler.setErrorListener(errorListener);
        }
        if (baseURI != null) {
            xQueryCompiler.setBaseURI(baseURI);
        }
        try {
            xquery = xQueryCompiler.compile(exprString);
        }
        catch (SaxonApiException e) {
            throw new LuxException(e);
        }
        SaxonTranslator translator = this.makeTranslator();
        if (this.searchStrategy == SearchStrategy.NONE) {
            return xquery;
        }
        XQuery abstractQuery = translator.queryFor(xquery);
        PathOptimizer optimizer = new PathOptimizer(this);
        optimizer.setSearchStrategy(this.searchStrategy);
        XQuery optimizedQuery = null;
        try {
            optimizedQuery = optimizer.optimize(abstractQuery);
            if (stats != null) {
                stats.optimizedXQuery = optimizedQuery;
            }
        }
        catch (LuxException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("An error occurred while optimizing: " + abstractQuery.toString());
            }
            throw e;
        }
        String queryString = optimizedQuery.toString();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("optimized xquery: " + queryString);
        }
        try {
            xquery = xQueryCompiler.compile(queryString);
        }
        catch (SaxonApiException e) {
            throw new LuxException(e);
        }
        return xquery;
    }

    private static Processor makeProcessor() {
        try {
            if (Class.forName("com.saxonica.config.EnterpriseConfiguration") != null) {
                return new Processor(true);
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            if (Class.forName("com.saxonica.config.ProfessionalConfiguration") != null) {
                return new Processor(true);
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        Processor p = new Processor((Configuration)new Config());
        if (!StringUtils.isEmpty((String)System.getProperty("org.expath.pkg.saxon.repo"))) {
            EXPathSupport.initializeEXPath(p);
        }
        return p;
    }

    private void registerExtensionFunctions() {
        LuxFunctionLibrary.registerFunctions(this.processor);
        FileExtensions.registerFunctions(this.processor);
        ExtensionFunctions.registerFunctions(this.processor);
    }

    public XsltCompiler getXsltCompiler() {
        return this.processor.newXsltCompiler();
    }

    public XQueryCompiler getXQueryCompiler() {
        XQueryCompiler xqueryCompiler = this.processor.newXQueryCompiler();
        for (Map.Entry<String, String> binding : this.namespaceBindings.entrySet()) {
            xqueryCompiler.declareNamespace(binding.getKey(), binding.getValue());
        }
        xqueryCompiler.declareNamespace("lux", "http://luxdb.net");
        return xqueryCompiler;
    }

    public XPathCompiler getXPathCompiler() {
        XPathCompiler xpathCompiler = this.processor.newXPathCompiler();
        xpathCompiler.declareNamespace("lux", "http://luxdb.net");
        return xpathCompiler;
    }

    public IndexConfiguration getIndexConfiguration() {
        return this.indexConfig;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public SaxonTranslator makeTranslator() {
        return new SaxonTranslator(this.processor.getUnderlyingConfiguration());
    }

    public CollectionURIResolver getDefaultCollectionURIResolver() {
        return this.defaultCollectionURIResolver;
    }

    public String getUriFieldName() {
        return this.uriFieldName;
    }

    public SearchStrategy getSearchStrategy() {
        return this.searchStrategy;
    }

    public void setSearchStrategy(SearchStrategy searchStrategy) {
        this.searchStrategy = searchStrategy;
    }

    public boolean isSaxonLicensed() {
        return this.isSaxonLicensed;
    }

    public List<AbstractExpression> getFieldLeaves(AbstractExpression leafExpr) {
        ArrayList<AbstractExpression> allLeaves = new ArrayList<AbstractExpression>();
        this.addMatchingLeaves(leafExpr, allLeaves);
        if (leafExpr instanceof PathStep) {
            PathStep step;
            PathStep.Axis axis = ((PathStep)leafExpr).getAxis();
            NodeTest nodeTest = ((PathStep)leafExpr).getNodeTest();
            for (PathStep.Axis extAxis : axis.extensions) {
                step = new PathStep(extAxis, nodeTest);
                this.addMatchingLeaves(step, allLeaves);
            }
            if (!nodeTest.isWild()) {
                nodeTest = new NodeTest(nodeTest.getType());
                step = new PathStep(axis, nodeTest);
                this.addMatchingLeaves(step, allLeaves);
                for (PathStep.Axis extAxis : axis.extensions) {
                    step = new PathStep(extAxis, nodeTest);
                    this.addMatchingLeaves(step, allLeaves);
                }
            }
        }
        return allLeaves;
    }

    private void addMatchingLeaves(AbstractExpression expr, List<AbstractExpression> allLeaves) {
        this.tempEquiv.setExpression(expr);
        ArrayList<AbstractExpression> leaves = this.fieldLeaves.get(this.tempEquiv);
        if (leaves != null) {
            allLeaves.addAll(leaves);
        }
    }

    public FieldDefinition getFieldForExpr(AbstractExpression fieldExpr) {
        return this.fieldExpressions.get(fieldExpr);
    }

    public void bindNamespacePrefix(String prefix, String namespace) {
        if (StringUtils.isEmpty((String)namespace)) {
            this.namespaceBindings.remove(prefix);
        } else {
            this.namespaceBindings.put(prefix, namespace);
        }
    }

    public void compileFieldExpressions() {
        SaxonTranslator translator = new SaxonTranslator(this.processor.getUnderlyingConfiguration());
        XPathCompiler xPathCompiler = this.getXPathCompiler();
        for (Map.Entry<String, String> e : this.indexConfig.getNamespaceMap().entrySet()) {
            xPathCompiler.declareNamespace(e.getKey(), e.getValue());
        }
        for (FieldDefinition field : this.indexConfig.getFields()) {
            XPathExecutable xpathExec;
            if (!(field instanceof XPathField)) continue;
            String xpath = ((XPathField)field).getXPath();
            try {
                xpathExec = xPathCompiler.compile(xpath);
            }
            catch (SaxonApiException e) {
                throw new LuxException("Error compiling index expression " + xpath + " for field " + field.getDefaultName());
            }
            AbstractExpression xpathExpr = translator.exprFor(xpathExec.getUnderlyingExpression().getInternalExpression());
            AbstractExpression leaf = xpathExpr.getLastContextStep();
            PropEquiv leafEquiv = new PropEquiv(leaf);
            if (this.fieldLeaves.containsKey(leaf)) {
                this.fieldLeaves.get(leafEquiv).add(leaf);
            } else {
                ArrayList<AbstractExpression> leaves = new ArrayList<AbstractExpression>();
                leaves.add(leaf);
                this.fieldLeaves.put(leafEquiv, leaves);
            }
            this.fieldExpressions.put(xpathExpr, (XPathField)field);
        }
    }

    public static enum SearchStrategy {
        NONE,
        LUX_UNOPTIMIZED,
        LUX_SEARCH,
        SAXON_LICENSE;

    }
}

