/*
 * Decompiled with CFR 0.152.
 */
package lux;

import lux.Evaluator;
import lux.QueryStats;
import lux.exception.LuxException;
import lux.solr.MissingStringLastComparatorSource;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;

public abstract class SearchIteratorBase
implements SequenceIterator<NodeInfo> {
    protected final Evaluator eval;
    protected final QueryStats stats;
    protected final String sortCriteria;
    protected final int start;
    protected NodeInfo current = null;
    protected int position = 0;
    public static final MissingStringLastComparatorSource MISSING_LAST = new MissingStringLastComparatorSource();

    public SearchIteratorBase(Evaluator eval, String sortCriteria, int start1) {
        this.eval = eval;
        this.stats = eval.getQueryStats();
        this.sortCriteria = sortCriteria;
        this.start = start1 - 1;
    }

    protected Sort makeSortFromCriteria(String criteria) {
        String[] fields = criteria.split("\\s*,\\s*");
        SortField[] sortFields = new SortField[fields.length];
        block4: for (int i = 0; i < fields.length; ++i) {
            SortField.Type type = SortField.Type.STRING;
            String[] tokens = fields[i].split("\\s+");
            String field = tokens[0];
            Boolean reverse = null;
            Boolean emptyGreatest = null;
            for (int j = 1; j < tokens.length; ++j) {
                if (tokens[j].equals("descending")) {
                    reverse = this.setBooleanOnce(reverse, true, criteria);
                    continue;
                }
                if (tokens[j].equals("ascending")) {
                    reverse = this.setBooleanOnce(reverse, false, criteria);
                    continue;
                }
                if (tokens[j].equals("empty")) {
                    if (j == tokens.length - 1) {
                        throw new LuxException("missing keyword after 'empty' in: " + criteria);
                    }
                    if (tokens[++j].equals("least")) {
                        emptyGreatest = this.setBooleanOnce(emptyGreatest, false, criteria);
                        continue;
                    }
                    if (tokens[j].equals("greatest")) {
                        emptyGreatest = this.setBooleanOnce(emptyGreatest, true, criteria);
                        continue;
                    }
                    throw new LuxException("missing or invalid keyword after 'empty' in: " + criteria);
                }
                if (tokens[j].equals("int")) {
                    type = SortField.Type.INT;
                    continue;
                }
                if (tokens[j].equals("long")) {
                    type = SortField.Type.LONG;
                    continue;
                }
                if (tokens[j].equals("string")) {
                    type = SortField.Type.STRING;
                    continue;
                }
                throw new LuxException("invalid keyword '" + tokens[j] + "' in: " + criteria);
            }
            if (field.equals("lux:score")) {
                if (reverse == Boolean.FALSE) {
                    throw new LuxException("not countenanced: attempt to sort by irrelevance");
                }
                sortFields[i] = SortField.FIELD_SCORE;
                continue;
            }
            if (emptyGreatest == Boolean.TRUE) {
                if (type == SortField.Type.STRING) {
                    sortFields[i] = new SortField(field, (FieldComparatorSource)MISSING_LAST, reverse == Boolean.TRUE);
                    continue;
                }
                sortFields[i] = new SortField(field, type, reverse == Boolean.TRUE);
                switch (type) {
                    case INT: {
                        sortFields[i].setMissingValue((Object)(reverse == Boolean.TRUE ? 0 : Integer.MAX_VALUE));
                        continue block4;
                    }
                    case LONG: {
                        sortFields[i].setMissingValue((Object)(reverse == Boolean.TRUE ? 0L : Long.MAX_VALUE));
                        continue block4;
                    }
                    default: {
                        throw new LuxException("unsupported combination of empty greatest and sort field type: " + type);
                    }
                }
            }
            sortFields[i] = new SortField(field, type, reverse == Boolean.TRUE);
        }
        return new Sort(sortFields);
    }

    final Boolean setBooleanOnce(Boolean current, boolean value, String sortCriteria) {
        if (current != null) {
            throw new LuxException("too many ordering keywords in: " + sortCriteria);
        }
        return value;
    }

    public NodeInfo current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public void close() {
    }

    public int getProperties() {
        return 0;
    }
}

