/*
 * Decompiled with CFR 0.152.
 */
package lux.functions;

import java.io.IOException;
import lux.Evaluator;
import lux.functions.SearchBase;
import lux.solr.CloudQueryRequest;
import lux.solr.SolrQueryContext;
import lux.solr.XQueryComponent;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.slf4j.LoggerFactory;

public class FieldTerms
extends ExtensionFunctionDefinition {
    public StructuredQName getFunctionQName() {
        return new StructuredQName("lux", "http://luxdb.net", "field-terms");
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.OPTIONAL_STRING, SequenceType.OPTIONAL_STRING};
    }

    public int getMinimumNumberOfArguments() {
        return 0;
    }

    public int getMaximumNumberOfArguments() {
        return 2;
    }

    public boolean trustResultType() {
        return true;
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.ATOMIC_SEQUENCE;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new FieldTermsCall();
    }

    class TermsIterator
    implements SequenceIterator<AtomicValue> {
        private TermsEnum terms;
        private final Evaluator eval;
        private Term term;
        private int pos;
        private String current;
        private String next;

        TermsIterator(Evaluator eval, Term term) throws IOException {
            this.term = term;
            this.eval = eval;
            this.pos = 0;
            this.createTermsEnum(term);
        }

        private void createTermsEnum(Term t) throws IOException {
            Terms fieldTerms;
            String fieldName = t.field();
            Fields fields = MultiFields.getFields((IndexReader)this.eval.getSearcher().getIndexReader());
            if (fields != null && (fieldTerms = fields.terms(fieldName)) != null) {
                this.terms = fieldTerms.iterator(null);
                if (t != null && this.terms.seekCeil(new BytesRef(t.text().getBytes("utf-8"))) != TermsEnum.SeekStatus.END) {
                    this.next = this.terms.term().utf8ToString();
                }
            }
        }

        public AtomicValue next() throws XPathException {
            try {
                if (this.next == null) {
                    this.pos = -1;
                    return null;
                }
                ++this.pos;
                this.current = this.next;
                BytesRef bytesRef = this.terms.next();
                this.next = bytesRef == null ? null : bytesRef.utf8ToString();
                return new StringValue((CharSequence)this.current);
            }
            catch (IOException e) {
                throw new XPathException((Throwable)e);
            }
        }

        public AtomicValue current() {
            return new StringValue((CharSequence)this.current);
        }

        public int position() {
            return this.pos;
        }

        public void close() {
        }

        public SequenceIterator<AtomicValue> getAnother() throws XPathException {
            try {
                return new TermsIterator(this.eval, this.term);
            }
            catch (IOException e) {
                throw new XPathException((Throwable)e);
            }
        }

        public int getProperties() {
            return 0;
        }
    }

    class SolrTermsIterator
    implements SequenceIterator<AtomicValue> {
        private final Evaluator eval;
        private Term term;
        private int offset;
        private int pos;
        private String current;
        private XQueryComponent xqueryComponent;
        private SolrQueryResponse response;

        SolrTermsIterator(Evaluator eval, Term term) {
            this.term = term;
            this.eval = eval;
            this.pos = -1;
            this.offset = 0;
            this.xqueryComponent = ((SolrQueryContext)eval.getQueryContext()).getQueryComponent();
        }

        public AtomicValue next() throws XPathException {
            int idx;
            NamedList terms;
            while (true) {
                NamedList termFields;
                if (this.response == null) {
                    this.getMoreTerms();
                }
                if ((terms = (NamedList)(termFields = (NamedList)this.response.getValues().get("terms")).get(this.term.field())).size() == 0) {
                    return null;
                }
                idx = this.pos - this.offset;
                if (idx < terms.size()) break;
                this.response = null;
            }
            this.current = terms.getName(idx);
            ++this.pos;
            return new StringValue((CharSequence)this.current);
        }

        private void getMoreTerms() {
            SolrRequestHandler termsHandler = this.xqueryComponent.getCore().getRequestHandler("/terms");
            if (termsHandler == null) {
                LoggerFactory.getLogger(this.getClass()).error("No /terms handler configured; lux:field-terms giving up");
                return;
            }
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.add("terms.fl", new String[]{this.term.field()});
            if (this.current != null) {
                params.add("terms.lower", new String[]{this.current});
                params.add("terms.lower.incl", new String[]{"false"});
                this.offset = this.pos;
            } else {
                this.pos = 0;
                params.add("terms.lower", new String[]{this.term.text()});
            }
            params.add("terms.sort", new String[]{"index"});
            params.add("terms.limit", new String[]{Integer.toString(100)});
            params.add("distrib", new String[]{"true"});
            this.xqueryComponent.getCurrentShards();
            params.add("shards", new String[]{StringUtils.join((Object[])this.xqueryComponent.getCurrentShards(), (String)",")});
            params.add("shards.qt", new String[]{"/terms"});
            CloudQueryRequest req = new CloudQueryRequest(this.xqueryComponent.getCore(), (SolrParams)params, null);
            this.response = new SolrQueryResponse();
            termsHandler.handleRequest((SolrQueryRequest)req, this.response);
        }

        public AtomicValue current() {
            return new StringValue((CharSequence)this.current);
        }

        public int position() {
            return this.pos;
        }

        public void close() {
        }

        public SequenceIterator<AtomicValue> getAnother() throws XPathException {
            return new SolrTermsIterator(this.eval, this.term);
        }

        public int getProperties() {
            return 0;
        }
    }

    class FieldTermsCall
    extends ExtensionFunctionCall {
        FieldTermsCall() {
        }

        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            String fieldName = null;
            String start = "";
            if (arguments.length > 0) {
                Item arg0 = arguments[0].head();
                if (arg0 != null) {
                    fieldName = arg0.getStringValue();
                }
                if (arguments.length > 1) {
                    Item arg1 = arguments[1].head();
                    start = arg1 == null ? "" : arg1.getStringValue();
                }
            }
            Evaluator eval = SearchBase.getEvaluator(context);
            try {
                XQueryComponent xqueryComponent;
                if (fieldName == null && (fieldName = eval.getCompiler().getIndexConfiguration().getDefaultFieldName()) == null) {
                    return EmptySequence.getInstance();
                }
                Term term = new Term(fieldName, start);
                if (eval.getQueryContext() instanceof SolrQueryContext && (xqueryComponent = ((SolrQueryContext)eval.getQueryContext()).getQueryComponent()).getCurrentShards() != null) {
                    return new LazySequence((SequenceIterator)new SolrTermsIterator(eval, term));
                }
                return new LazySequence((SequenceIterator)new TermsIterator(eval, term));
            }
            catch (IOException e) {
                throw new XPathException("failed getting terms from field " + fieldName, (Throwable)e);
            }
        }
    }
}

