/*
 * Decompiled with CFR 0.152.
 */
package lux.functions;

import java.util.Iterator;
import lux.Evaluator;
import lux.query.parser.LuxQueryParser;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.instruct.SavedNamespaceContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.NamespaceConstant;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.xml.ParserException;
import org.apache.lucene.search.Query;
import org.w3c.dom.Element;

public abstract class NamespaceAwareFunctionCall
extends ExtensionFunctionCall {
    private NamespaceResolver namespaceResolver;

    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public void supplyStaticContext(StaticContext context, int locationId, Expression[] arguments) {
        this.namespaceResolver = context.getNamespaceResolver();
        if (!(this.namespaceResolver instanceof SavedNamespaceContext)) {
            this.namespaceResolver = new SavedNamespaceContext(this.namespaceResolver);
        }
    }

    public void copyLocalData(ExtensionFunctionCall destination) {
        ((NamespaceAwareFunctionCall)destination).namespaceResolver = this.namespaceResolver;
    }

    protected Query parseQuery(Item queryArg, Evaluator eval) throws XPathException {
        NodeInfo queryNodeInfo;
        NodeOverNodeInfo queryDocument;
        if (queryArg instanceof NodeInfo && (queryDocument = NodeOverNodeInfo.wrap((NodeInfo)(queryNodeInfo = (NodeInfo)queryArg))) instanceof Element) {
            try {
                return eval.getXmlQueryParser().getQuery((Element)queryDocument);
            }
            catch (ParserException e) {
                throw new XPathException("Failed to parse xml query : " + e.getMessage(), (Throwable)e);
            }
        }
        LuxQueryParser luxQueryParser = eval.getLuxQueryParser();
        Iterator prefixes = this.namespaceResolver.iteratePrefixes();
        while (prefixes.hasNext()) {
            String prefix = (String)prefixes.next();
            String nsURI = this.namespaceResolver.getURIForPrefix(prefix, false);
            if (NamespaceConstant.isReservedInQuery((String)nsURI)) continue;
            luxQueryParser.bindNamespacePrefix(prefix, nsURI);
        }
        try {
            return luxQueryParser.parse(queryArg.getStringValue());
        }
        catch (ParseException e) {
            throw new XPathException(e.getMessage(), (Throwable)e);
        }
    }
}

