/*
 * Decompiled with CFR 0.152.
 */
package lux.index;

public class MutableString
implements CharSequence {
    private int length;
    private char[] buffer;

    public MutableString(int capacity) {
        this.buffer = new char[capacity];
        this.length = 0;
    }

    public MutableString() {
        this(64);
    }

    public MutableString(MutableString o) {
        this(o.length());
        this.append(o);
    }

    public MutableString(CharSequence o) {
        this(o.length());
        this.append(o.toString());
    }

    public int hashCode() {
        int h = 0;
        for (int i = 0; i < this.length; ++i) {
            h = 31 * h + this.buffer[i];
        }
        return h;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof MutableString) {
            return this.equals((MutableString)other);
        }
        if (other instanceof CharSequence) {
            return this.equals((CharSequence)other);
        }
        return false;
    }

    private boolean equals(CharSequence o) {
        if (o.length() != this.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.buffer[i] == o.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private boolean equals(MutableString o) {
        if (o.length != this.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.buffer[i] == o.buffer[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return new String(this.buffer, 0, this.length);
    }

    public MutableString append(char c) {
        this.assureCapacity(1);
        this.buffer[this.length++] = c;
        return this;
    }

    public MutableString append(String s) {
        int l = s.length();
        this.assureCapacity(l);
        s.getChars(0, l, this.buffer, this.length);
        this.length += l;
        return this;
    }

    public MutableString append(MutableString s) {
        this.assureCapacity(s.length);
        System.arraycopy(s.buffer, 0, this.buffer, this.length, s.length);
        this.length += s.length;
        return this;
    }

    public MutableString append(char[] s) {
        this.assureCapacity(s.length);
        System.arraycopy(s, 0, this.buffer, this.length, s.length);
        this.length += s.length;
        return this;
    }

    private final void assureCapacity(int n) {
        if (this.length + n > this.buffer.length) {
            char[] expanded = new char[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, expanded, 0, this.buffer.length);
            this.buffer = expanded;
        }
    }

    @Override
    public char charAt(int index) {
        return this.buffer[index];
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        char[] sub = new char[end - start];
        System.arraycopy(this.buffer, start, sub, 0, end - start);
        return new String(sub);
    }

    public void setLength(int i) {
        this.length = i;
    }
}

