/*
 * Decompiled with CFR 0.152.
 */
package lux.index.analysis;

import lux.index.analysis.ContentIterator;
import lux.index.analysis.QNameTokenFilter;
import lux.index.analysis.TextOffsetTokenStream;
import lux.index.attribute.QNameAttribute;
import lux.xml.Offsets;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;

public final class ElementTokenStream
extends TextOffsetTokenStream {
    private final QNameAttribute qnameAtt;
    private QNameTokenFilter qnameTokenFilter = new QNameTokenFilter(this.getWrappedTokenStream());

    public ElementTokenStream(String fieldName, Analyzer analyzer, TokenStream wrapped, XdmNode doc, Offsets offsets) {
        super(fieldName, analyzer, wrapped, doc, offsets);
        this.contentIter = new ContentIterator(doc);
        this.qnameAtt = (QNameAttribute)this.qnameTokenFilter.addAttribute(QNameAttribute.class);
        this.setWrappedTokenStream((TokenStream)this.qnameTokenFilter);
    }

    @Override
    protected void updateNodeAtts() {
        this.getAncestorQNames();
    }

    private void getAncestorQNames() {
        AncestorIterator nodeAncestors = new AncestorIterator(this.curNode);
        this.qnameAtt.clearQNames();
        while (nodeAncestors.hasNext()) {
            XdmNode e = (XdmNode)nodeAncestors.next();
            if (e.getNodeKind() != XdmNodeKind.ELEMENT) continue;
            QName qname = e.getNodeName();
            this.qnameAtt.addQName(new lux.xml.QName(qname.getNamespaceURI(), qname.getLocalName(), qname.getPrefix()));
        }
    }

    private static class AncestorIterator
    extends XdmSequenceIterator {
        protected AncestorIterator(XdmNode node) {
            super((SequenceIterator)node.getUnderlyingNode().iterateAxis(Axis.ANCESTOR_OR_SELF.getAxisNumber(), (NodeTest)new CombinedNodeTest((NodeTest)NodeKindTest.TEXT, 1, (NodeTest)new CombinedNodeTest((NodeTest)NodeKindTest.ELEMENT, 1, (NodeTest)NodeKindTest.ATTRIBUTE))));
        }
    }
}

