/*
 * Decompiled with CFR 0.152.
 */
package lux.index.field;

import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import lux.index.XmlIndexer;
import lux.index.analysis.DefaultAnalyzer;
import lux.index.analysis.ElementTokenStream;
import lux.index.analysis.QNameTokenFilter;
import lux.index.field.FieldDefinition;
import lux.index.field.FieldValues;
import lux.xml.SaxonDocBuilder;
import net.sf.saxon.s9api.XdmNode;
import org.apache.commons.io.input.CharSequenceReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;

public class ElementTextField
extends FieldDefinition {
    private static final ElementTextField instance = new ElementTextField();

    public static ElementTextField getInstance() {
        return instance;
    }

    protected ElementTextField() {
        super("lux_elt_text", new DefaultAnalyzer(), Field.Store.NO, FieldDefinition.Type.TOKENS);
    }

    public Iterable<IndexableField> getFieldValues(XmlIndexer indexer) {
        XdmNode doc = indexer.getXdmNode();
        if (doc != null && doc.getUnderlyingNode() != null) {
            SaxonDocBuilder builder = indexer.getSaxonDocBuilder();
            String fieldName = indexer.getConfiguration().getFieldName(this);
            Analyzer analyzer = this.getAnalyzer();
            TokenStream textTokens = null;
            try {
                textTokens = analyzer.tokenStream(fieldName, (Reader)new CharSequenceReader((CharSequence)""));
            }
            catch (IOException e) {
                // empty catch block
            }
            ElementTokenStream tokens = new ElementTokenStream(fieldName, analyzer, textTokens, doc, builder.getOffsets());
            ((QNameTokenFilter)tokens.getWrappedTokenStream()).setNamespaceAware(indexer.getConfiguration().isOption(4));
            return new FieldValues(indexer.getConfiguration(), this, Collections.singleton(new TextField(indexer.getConfiguration().getFieldName(this), (TokenStream)tokens)));
        }
        return Collections.emptySet();
    }
}

