/*
 * Decompiled with CFR 0.152.
 */
package lux.index.field;

import java.util.Iterator;
import lux.index.IndexConfiguration;
import lux.index.field.FieldDefinition;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;

public class FieldValues
implements Iterable<IndexableField> {
    private final FieldDefinition field;
    private final String fieldName;
    private final Iterable<?> values;

    public FieldValues(IndexConfiguration indexConfig, FieldDefinition field, Iterable<?> values) {
        this.field = field;
        this.values = values;
        this.fieldName = indexConfig.getFieldName(field);
    }

    @Override
    public Iterator<IndexableField> iterator() {
        return new FieldIterator(this.values.iterator());
    }

    class FieldIterator
    implements Iterator<IndexableField> {
        private Iterator<?> iter;

        FieldIterator(Iterator<?> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public IndexableField next() {
            Object value = this.iter.next();
            if (value instanceof IndexableField) {
                return (IndexableField)value;
            }
            switch (FieldValues.this.field.getType()) {
                case BYTES: {
                    if (value instanceof byte[]) {
                        return new StoredField(FieldValues.this.fieldName, (byte[])value);
                    }
                }
                case STRING: {
                    return new StringField(FieldValues.this.fieldName, value.toString(), FieldValues.this.field.isStored());
                }
                case TEXT: {
                    return new TextField(FieldValues.this.fieldName, value.toString(), FieldValues.this.field.isStored());
                }
                case INT: {
                    return new IntField(FieldValues.this.fieldName, ((Integer)value).intValue(), FieldValues.this.field.isStored());
                }
                case LONG: {
                    return new LongField(FieldValues.this.fieldName, ((Long)value).longValue(), FieldValues.this.field.isStored());
                }
            }
            throw new IllegalStateException("unimplemented field type: " + (Object)((Object)FieldValues.this.field.getType()));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

