/*
 * Decompiled with CFR 0.152.
 */
package lux.index.field;

import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import lux.index.XmlIndexer;
import lux.index.field.FieldDefinition;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.document.Field;

public class PathOccurrenceField
extends FieldDefinition {
    private static final PathOccurrenceField instance = new PathOccurrenceField();
    private final Pattern spacePattern = Pattern.compile(" ");

    public static PathOccurrenceField getInstance() {
        return instance;
    }

    protected PathOccurrenceField() {
        super("lux_path", (Analyzer)new KeywordAnalyzer(), Field.Store.NO, FieldDefinition.Type.STRING);
    }

    @Override
    public Iterable<?> getValues(XmlIndexer indexer) {
        return new PathOccurrenceIterator(indexer);
    }

    class PathOccurrenceIterator
    implements Iterable<String>,
    Iterator<String> {
        private Iterator<Map.Entry<CharSequence, Integer>> pathCounts;
        private Map.Entry<CharSequence, Integer> pathCount;
        private int iPathCount;

        public PathOccurrenceIterator(XmlIndexer indexer) {
            this.pathCounts = indexer.getPathMapper().getPathCounts().entrySet().iterator();
            if (this.pathCounts.hasNext()) {
                this.pathCount = this.pathCounts.next();
            }
            this.iPathCount = 0;
        }

        @Override
        public Iterator<String> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.pathCounts.hasNext() || this.pathCount != null;
        }

        @Override
        public String next() {
            StringBuilder buf = new StringBuilder();
            CharSequence path = this.pathCount.getKey();
            String[] names = PathOccurrenceField.this.spacePattern.split(path);
            if (names.length > 1) {
                buf.append(names[names.length - 1]);
                for (int i = names.length - 2; i > 0; --i) {
                    buf.append('/');
                    buf.append(names[i]);
                }
            }
            if (this.iPathCount++ >= this.pathCount.getValue()) {
                this.iPathCount = 0;
                this.pathCount = this.pathCounts.hasNext() ? this.pathCounts.next() : null;
            }
            return buf.toString();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

