/*
 * Decompiled with CFR 0.152.
 */
package lux.search;

import java.io.IOException;
import lux.search.DocIterator;
import lux.search.TopDocsIterator;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.Directory;

public class LuxSearcher
extends IndexSearcher {
    private final IndexReader indexReader;

    public LuxSearcher(Directory dir) throws IOException {
        super((IndexReader)DirectoryReader.open((Directory)dir));
        this.indexReader = this.getIndexReader();
    }

    public LuxSearcher(IndexSearcher searcher) {
        super(searcher.getIndexReader());
        this.indexReader = null;
    }

    public LuxSearcher(IndexReader reader) {
        super(reader);
        this.indexReader = reader;
    }

    public void close() throws IOException {
        if (this.indexReader != null) {
            this.indexReader.close();
        }
    }

    public DocIterator search(Query query) throws IOException {
        return new DocIterator(this, query, false);
    }

    public TopFieldDocs search(Weight weight, int size, Sort sort, boolean b1, boolean b2) throws IOException {
        return super.search(weight, size, sort, b1, b2);
    }

    public TopDocsIterator search(Query query, Sort sort) throws IOException {
        return new TopDocsIterator(this, query, sort);
    }

    public DocIterator searchOrdered(Query query) throws IOException {
        return new DocIterator(this, query, true);
    }
}

