/*
 * Decompiled with CFR 0.152.
 */
package lux.solr;

import java.io.IOException;
import lux.index.FieldName;
import lux.index.IndexConfiguration;
import lux.index.field.IDField;
import lux.solr.SolrIndexConfig;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;

public class CloudIdProcessor
extends UpdateRequestProcessor {
    private final String idFieldName;
    private final String uriFieldName;

    public CloudIdProcessor(SolrIndexConfig config, SolrQueryRequest req, UpdateRequestProcessor next) {
        super(next);
        IndexConfiguration indexConfig = config.getIndexConfig();
        this.idFieldName = indexConfig.getFieldName(IDField.getInstance());
        this.uriFieldName = indexConfig.getFieldName(FieldName.URI);
    }

    public void processAdd(AddUpdateCommand cmd) throws IOException {
        SolrInputDocument solrInputDocument = cmd.getSolrInputDocument();
        String uri = (String)solrInputDocument.getFieldValue(this.uriFieldName);
        if (uri != null) {
            long t = System.currentTimeMillis() << 22;
            long hashCode = uri.hashCode() & 0x2FFFFF;
            long luxDocId = t | hashCode;
            solrInputDocument.addField(this.idFieldName, (Object)luxDocId);
        }
        if (this.next != null) {
            this.next.processAdd(cmd);
        }
    }
}

