/*
 * Decompiled with CFR 0.152.
 */
package lux.solr;

import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import javax.xml.stream.XMLStreamException;
import lux.index.FieldName;
import lux.index.IndexConfiguration;
import lux.index.XmlIndexer;
import lux.index.field.FieldDefinition;
import lux.index.field.IDField;
import lux.solr.SolrIndexConfig;
import lux.solr.UpdateDocCommand;
import lux.xml.tinybin.TinyBinary;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.NodeInfo;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongField;
import org.apache.lucene.index.IndexableField;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuxUpdateProcessor
extends UpdateRequestProcessor {
    private final SolrIndexConfig solrIndexConfig;
    private final IndexConfiguration indexConfig;
    private final Configuration saxonConfig;
    private final SolrQueryRequest req;
    private final Logger logger;

    public LuxUpdateProcessor(SolrIndexConfig config, SolrQueryRequest req, UpdateRequestProcessor next) {
        super(next);
        this.solrIndexConfig = config;
        this.indexConfig = this.solrIndexConfig.getIndexConfig();
        this.saxonConfig = this.solrIndexConfig.getCompiler().getProcessor().getUnderlyingConfiguration();
        this.req = req;
        this.logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    }

    public void processAdd(AddUpdateCommand cmd) throws IOException {
        SolrInputDocument solrInputDocument = cmd.getSolrInputDocument();
        String xmlFieldName = this.indexConfig.getFieldName(FieldName.XML_STORE);
        String idFieldName = this.indexConfig.getFieldName(IDField.getInstance());
        SolrInputField xmlField = solrInputDocument.removeField(xmlFieldName);
        SolrInputField luxIdField = solrInputDocument.removeField(idFieldName);
        String uri = (String)solrInputDocument.getFieldValue(this.indexConfig.getFieldName(FieldName.URI));
        Document luceneDocument = cmd.getLuceneDocument();
        solrInputDocument.addField(xmlFieldName, (Object)xmlField);
        XmlIndexer xmlIndexer = this.solrIndexConfig.checkoutXmlIndexer();
        UpdateDocCommand luxCommand = null;
        if (xmlField != null) {
            Object xml = xmlField.getFirstValue();
            try {
                try {
                    if (xml instanceof String) {
                        xmlIndexer.index(new StringReader((String)xml), uri);
                    } else if (xml instanceof byte[]) {
                        TinyBinary xmlbin = new TinyBinary((byte[])xml, Charset.forName("utf-8"));
                        xmlIndexer.index((NodeInfo)xmlbin.getTinyDocument(this.saxonConfig), uri);
                    } else if (xml instanceof NodeInfo) {
                        xmlIndexer.index((NodeInfo)xml, uri);
                    }
                }
                catch (XMLStreamException e) {
                    this.logger.error("Failed to parse " + uri, (Throwable)e);
                }
                this.addDocumentFields(xmlIndexer, this.solrIndexConfig.getSchema(), luceneDocument);
                if (luxIdField != null) {
                    Object id = luxIdField.getValue();
                    if (!(id instanceof Long)) {
                        id = Long.valueOf(id.toString());
                    }
                    luceneDocument.add((IndexableField)new LongField(idFieldName, ((Long)id).longValue(), Field.Store.YES));
                }
                luxCommand = new UpdateDocCommand(this.req, solrInputDocument, luceneDocument, uri);
            }
            catch (Exception e) {
                this.logger.error("An error occurred while indexing " + uri, (Throwable)e);
                throw new IOException(e);
            }
            finally {
                this.solrIndexConfig.returnXmlIndexer(xmlIndexer);
            }
        }
        if (this.next != null) {
            this.next.processAdd((AddUpdateCommand)(luxCommand == null ? cmd : luxCommand));
        }
    }

    private void addDocumentFields(XmlIndexer indexer, IndexSchema indexSchema, Document doc) {
        if (this.indexConfig.isOption(16)) {
            doc.removeField(this.indexConfig.getFieldName(FieldName.XML_STORE));
        }
        for (FieldDefinition field : this.indexConfig.getFields()) {
            String fieldName = this.indexConfig.getFieldName(field);
            if ((field == this.indexConfig.getField(FieldName.URI) || field == this.indexConfig.getField(FieldName.XML_STORE)) && doc.getField(fieldName) != null) continue;
            Iterable<?> values = field.getValues(indexer);
            SchemaField schemaField = indexSchema.getField(fieldName);
            if (values != null) {
                for (Object object : values) {
                    LuxUpdateProcessor.addField(doc, schemaField, object, 1.0f);
                }
                continue;
            }
            for (IndexableField indexableField : field.getFieldValues(indexer)) {
                LuxUpdateProcessor.addField(doc, schemaField, indexableField, 1.0f);
            }
        }
    }

    private static void addField(Document doc, SchemaField field, Object val, float boost) {
        if (val instanceof IndexableField) {
            doc.add((IndexableField)val);
        } else {
            for (IndexableField f : field.getType().createFields(field, val, boost)) {
                if (f == null) continue;
                doc.add((IndexableField)((Field)f));
            }
        }
    }
}

