/*
 * Decompiled with CFR 0.152.
 */
package lux.solr;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import lux.Compiler;
import lux.exception.LuxException;
import lux.index.FieldName;
import lux.index.IndexConfiguration;
import lux.index.XmlIndexer;
import lux.index.analysis.WhitespaceGapAnalyzer;
import lux.index.field.FieldDefinition;
import lux.index.field.XPathField;
import net.sf.saxon.s9api.Serializer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.document.Field;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.schema.BinaryField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrField;
import org.apache.solr.schema.TextField;
import org.apache.solr.schema.TrieIntField;
import org.apache.solr.schema.TrieLongField;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrIndexConfig
implements SolrInfoMBean {
    private static final String SOURCE_URL = "https://github.com/msokolov/lux";
    private final IndexConfiguration indexConfig;
    private NamedList<String> xpathFieldConfig;
    private Compiler compiler;
    private ArrayBlockingQueue<XmlIndexer> indexerPool;
    private ArrayBlockingQueue<Serializer> serializerPool;
    private IndexSchema schema;
    private final Logger logger;
    private static URL[] docs;

    public SolrIndexConfig(IndexConfiguration indexConfig) {
        this.indexConfig = indexConfig;
        this.indexerPool = new ArrayBlockingQueue(8);
        this.serializerPool = new ArrayBlockingQueue(8);
        this.compiler = new Compiler(indexConfig);
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public Compiler getCompiler() {
        return this.compiler;
    }

    public XmlIndexer checkoutXmlIndexer() {
        XmlIndexer indexer = this.indexerPool.poll();
        if (indexer == null) {
            indexer = new XmlIndexer(this.indexConfig, this.compiler);
            this.logger.debug("created new XmlIndexer");
        }
        return indexer;
    }

    public void returnXmlIndexer(XmlIndexer doneWithIt) {
        this.indexerPool.offer(doneWithIt);
    }

    public Serializer checkoutSerializer() {
        Serializer serializer = this.serializerPool.poll();
        if (serializer == null) {
            serializer = new Serializer();
            serializer.setOutputProperty(Serializer.Property.ENCODING, "utf-8");
            serializer.setOutputProperty(Serializer.Property.BYTE_ORDER_MARK, "no");
            serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
        }
        return serializer;
    }

    public void returnSerializer(Serializer doneWithIt) {
        this.serializerPool.offer(doneWithIt);
    }

    public static SolrIndexConfig registerIndexConfiguration(SolrCore core) {
        SolrIndexConfig indexConfig;
        SolrInfoMBean configBean;
        NamedList initArgs = null;
        for (PluginInfo info : core.getSolrConfig().getPluginInfos(UpdateRequestProcessorChain.class.getName())) {
            initArgs = info.initArgs;
            if (!"true".equals(info.attributes.get("default"))) continue;
            break;
        }
        if ((configBean = (SolrInfoMBean)core.getInfoRegistry().get(SolrIndexConfig.class.getName())) != null) {
            indexConfig = (SolrIndexConfig)configBean;
        } else {
            int options = 202;
            indexConfig = SolrIndexConfig.makeIndexConfiguration(options, initArgs);
            indexConfig.inform(core);
            core.getInfoRegistry().put(indexConfig.getName(), indexConfig);
        }
        return indexConfig;
    }

    public static SolrIndexConfig makeIndexConfiguration(int options, NamedList<?> args) {
        if (args != null) {
            Object format;
            if ("yes".equals(args.get("strip-namespaces"))) {
                options |= 0x400;
            }
            if ("yes".equals(args.get("namespace-aware"))) {
                options |= 4;
            }
            if ((format = args.get("xml-format")) != null) {
                if ("tiny".equals(format)) {
                    options |= 0x10;
                } else if (!"xml".equals(format)) {
                    throw new LuxException("invalid xml-format: " + format + ", must be one of: (xml,tiny)");
                }
            }
        }
        IndexConfiguration indexConfig = IndexConfiguration.makeIndexConfiguration(options);
        if (args != null) {
            SolrIndexConfig.renameFields(indexConfig, args);
        }
        SolrIndexConfig config = new SolrIndexConfig(indexConfig);
        if (args != null) {
            NamedList namespaces;
            NamedList fields = (NamedList)args.get("fields");
            if (fields != null) {
                config.applyFieldConfiguration((NamedList<String>)fields);
            }
            if ((namespaces = (NamedList)args.get("namespaces")) != null) {
                for (Map.Entry ns : namespaces) {
                    config.getIndexConfig().defineNamespaceMapping((String)ns.getKey(), (String)ns.getValue());
                }
            }
        }
        return config;
    }

    public void applyFieldConfiguration(NamedList<String> fields) {
        if (fields != null) {
            this.xpathFieldConfig = new NamedList();
            for (Map.Entry f : fields) {
                this.xpathFieldConfig.add((String)f.getKey(), f.getValue());
            }
        }
    }

    private static void renameFields(IndexConfiguration indexConfig, NamedList args) {
        NamedList aliases = (NamedList)args.get("fieldAliases");
        if (aliases == null) {
            return;
        }
        for (int i = 0; i < aliases.size(); ++i) {
            String name = aliases.getName(i);
            Object value = aliases.getVal(i);
            if ("xmlFieldName".equals(name)) {
                indexConfig.renameField(indexConfig.getField(FieldName.XML_STORE), value.toString());
                LoggerFactory.getLogger(SolrIndexConfig.class).info("XML storage field name: {}", (Object)value.toString());
                continue;
            }
            if ("uriFieldName".equals(name)) {
                LoggerFactory.getLogger(SolrIndexConfig.class).info("URI field name: {}", (Object)value.toString());
                indexConfig.renameField(indexConfig.getField(FieldName.URI), value.toString());
                continue;
            }
            if (!"textFieldName".equals(name)) continue;
            LoggerFactory.getLogger(SolrIndexConfig.class).info("XML text field name: {}", (Object)value.toString());
            indexConfig.renameField(indexConfig.getField(FieldName.XML_TEXT), value.toString());
        }
    }

    public void inform(SolrCore core) {
        SchemaField uniqueKeyField;
        this.schema = core.getLatestSchema();
        this.informField(this.indexConfig.getField(FieldName.XML_STORE));
        for (FieldDefinition fld : this.indexConfig.getFields()) {
            this.informField(fld);
        }
        if (this.xpathFieldConfig != null) {
            this.addXPathFields();
        }
        if ((uniqueKeyField = this.schema.getUniqueKeyField()) == null) {
            LoggerFactory.getLogger(this.getClass()).error("schema does not define any unique field");
        } else if (!uniqueKeyField.getName().equals(this.indexConfig.getFieldName(FieldName.URI))) {
            LoggerFactory.getLogger(this.getClass()).error("schema defines a different unique field than the uri field declared in lux configuration");
        }
        this.schema.refreshAnalyzers();
    }

    private void informField(FieldDefinition fld) {
        Map fields = this.schema.getFields();
        Map fieldTypes = this.schema.getFieldTypes();
        String fieldName = this.indexConfig.getFieldName(fld);
        FieldDefinition actualField = this.indexConfig.getField(fieldName);
        if (fields.containsKey(fieldName)) {
            this.logger.info("Field already defined: " + fieldName);
            return;
        }
        FieldType fieldType = this.getFieldType(actualField);
        if (!fieldTypes.containsKey(fieldType.getTypeName())) {
            this.logger.info("Defining fieldType: " + fieldType.getTypeName());
            fieldTypes.put(fieldType.getTypeName(), fieldType);
        } else {
            fieldType = (FieldType)fieldTypes.get(fieldType.getTypeName());
        }
        this.logger.info("Defining field: " + fieldName + " of type " + fieldType.getTypeName());
        fields.put(fieldName, new SchemaField(fieldName, fieldType, actualField.getSolrFieldProperties(), ""));
    }

    private void addXPathFields() {
        for (Map.Entry f : this.xpathFieldConfig) {
            SchemaField field = this.schema.getField((String)f.getKey());
            FieldType fieldType = field.getType();
            if (fieldType == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Field " + (String)f.getKey() + " declared in lux config, but not defined in schema");
            }
            XPathField xpathField = new XPathField((String)f.getKey(), (String)f.getValue(), fieldType.getAnalyzer(), field.stored() ? Field.Store.YES : Field.Store.NO, field);
            this.indexConfig.addField(xpathField);
        }
    }

    private FieldType getFieldType(FieldDefinition xmlField) {
        Analyzer analyzer = xmlField.getAnalyzer();
        String fieldName = this.indexConfig.getFieldName(xmlField);
        if (analyzer == null) {
            if (xmlField.isStored() != Field.Store.YES) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "invalid xml field: " + fieldName + "; no analyzer and not stored");
            }
            switch (xmlField.getType()) {
                case STRING: {
                    return new StoredStringField();
                }
                case INT: {
                    return new NamedIntField();
                }
                case LONG: {
                    return new NamedLongField();
                }
                case BYTES: {
                    return new NamedBinaryField();
                }
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "invalid stored field: " + fieldName + " with type: " + (Object)((Object)xmlField.getType()));
        }
        if (xmlField.getType() == FieldDefinition.Type.TOKENS) {
            return new FieldableField();
        }
        if (analyzer == null || analyzer instanceof KeywordAnalyzer) {
            return new StringField();
        }
        if (analyzer instanceof WhitespaceGapAnalyzer) {
            return new PathField();
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "invalid xml field: " + fieldName + "; unknown analyzer type: " + analyzer);
    }

    public IndexSchema getSchema() {
        return this.schema;
    }

    public IndexConfiguration getIndexConfig() {
        return this.indexConfig;
    }

    public String getName() {
        return "lux.solr.SolrIndexConfig";
    }

    public String getVersion() {
        return "1.0";
    }

    public String getDescription() {
        return "Lux index configuration";
    }

    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.OTHER;
    }

    public String getSource() {
        return SOURCE_URL;
    }

    public URL[] getDocs() {
        if (docs == null) {
            try {
                docs = new URL[]{new URL(SOURCE_URL)};
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return docs;
    }

    public NamedList<?> getStatistics() {
        return null;
    }

    class FieldableField
    extends BinaryField {
        FieldableField() {
            this.typeName = "fieldable";
        }

        public Field createField(SchemaField field, Object val, float boost) {
            return (Field)val;
        }
    }

    class PathField
    extends TextField {
        PathField() {
            this.typeName = "lux_text_ws";
            this.setAnalyzer(new WhitespaceGapAnalyzer());
            this.setQueryAnalyzer(new WhitespaceGapAnalyzer());
        }
    }

    class StringField
    extends StrField {
        StringField() {
            this.typeName = "string";
        }
    }

    class NamedBinaryField
    extends BinaryField {
        public NamedBinaryField() {
            this.typeName = "binary";
        }
    }

    class NamedLongField
    extends TrieLongField {
        public NamedLongField() {
            this.typeName = "long";
        }
    }

    class NamedIntField
    extends TrieIntField {
        public NamedIntField() {
            this.typeName = "int";
        }
    }

    class StoredStringField
    extends StrField {
        StoredStringField() {
            this.typeName = "lux_stored_string";
        }
    }
}

