/*
 * Decompiled with CFR 0.152.
 */
package lux.xpath;

import lux.xpath.AbstractExpression;
import lux.xpath.ExpressionVisitor;

public class Sequence
extends AbstractExpression {
    public Sequence(AbstractExpression ... contents) {
        super(AbstractExpression.Type.SEQUENCE);
        this.setSubs(contents);
    }

    @Override
    public void toString(StringBuilder buf) {
        this.seqAsString(buf, this.subs);
    }

    private void seqAsString(StringBuilder buf, AbstractExpression ... contents) {
        buf.append('(');
        Sequence.appendSeqContents(buf, contents, ",", this.getPrecedence());
        buf.append(')');
    }

    static void appendSeqContents(StringBuilder buf, AbstractExpression[] contents, String separator, int precedence) {
        if (contents.length > 0) {
            Sequence.appendSeqItem(buf, separator, precedence, contents[0]);
        }
        for (int i = 1; i < contents.length; ++i) {
            buf.append(separator);
            Sequence.appendSeqItem(buf, separator, precedence, contents[i]);
        }
    }

    private static void appendSeqItem(StringBuilder buf, String separator, int precedence, AbstractExpression arg) {
        if (arg.getType() == AbstractExpression.Type.SEQUENCE) {
            Sequence.appendSeqContents(buf, arg.getSubs(), separator, precedence);
        } else if (arg.getPrecedence() < precedence) {
            buf.append('(');
            arg.toString(buf);
            buf.append(')');
        } else {
            arg.toString(buf);
        }
    }

    @Override
    public AbstractExpression accept(ExpressionVisitor visitor) {
        super.acceptSubs(visitor);
        return visitor.visit(this);
    }

    @Override
    public boolean isDocumentOrdered() {
        return this.subs.length < 2 && super.isDocumentOrdered();
    }

    @Override
    public int getPrecedence() {
        return 1;
    }
}

