/*
 * Decompiled with CFR 0.152.
 */
package lux.functions.file;

import java.io.File;
import java.util.Arrays;
import lux.functions.Function;
import net.sf.saxon.s9api.ExtensionFunction;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.OccurrenceIndicator;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SequenceType;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmEmptySequence;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmValue;

public class FileExtensions {
    public static final String FILE_NAMESPACE = "http://expath.org/ns/file";

    public static void registerFunctions(Processor processor) {
        processor.registerExtensionFunction(FileExtensions.createIsDirFunction());
        processor.registerExtensionFunction(FileExtensions.createExistsFunction());
        processor.registerExtensionFunction(FileExtensions.createListFunction());
    }

    private static ExtensionFunction createExistsFunction() {
        return new Function(new QName("file", FILE_NAMESPACE, "exists"), SequenceType.makeSequenceType((ItemType)ItemType.BOOLEAN, (OccurrenceIndicator)OccurrenceIndicator.ONE), new SequenceType[]{SequenceType.makeSequenceType((ItemType)ItemType.STRING, (OccurrenceIndicator)OccurrenceIndicator.ONE)}){

            @Override
            public XdmValue call(XdmValue[] arguments) throws SaxonApiException {
                String path = arguments[0].itemAt(0).getStringValue();
                boolean result = new File(path).exists();
                return new XdmAtomicValue(result);
            }
        };
    }

    private static ExtensionFunction createIsDirFunction() {
        return new Function(new QName("file", FILE_NAMESPACE, "is-dir"), SequenceType.makeSequenceType((ItemType)ItemType.BOOLEAN, (OccurrenceIndicator)OccurrenceIndicator.ONE), new SequenceType[]{SequenceType.makeSequenceType((ItemType)ItemType.STRING, (OccurrenceIndicator)OccurrenceIndicator.ONE)}){

            @Override
            public XdmValue call(XdmValue[] arguments) throws SaxonApiException {
                String path = arguments[0].itemAt(0).getStringValue();
                boolean result = new File(path).isDirectory();
                return new XdmAtomicValue(result);
            }
        };
    }

    private static ExtensionFunction createListFunction() {
        return new Function(new QName("file", FILE_NAMESPACE, "list"), SequenceType.makeSequenceType((ItemType)ItemType.STRING, (OccurrenceIndicator)OccurrenceIndicator.ZERO_OR_MORE), new SequenceType[]{SequenceType.makeSequenceType((ItemType)ItemType.STRING, (OccurrenceIndicator)OccurrenceIndicator.ONE)}){

            @Override
            public XdmValue call(XdmValue[] arguments) throws SaxonApiException {
                String dir = arguments[0].itemAt(0).getStringValue();
                String[] files = new File(dir).list();
                if (files == null) {
                    return XdmEmptySequence.getInstance();
                }
                XdmItem[] items = new XdmItem[files.length];
                for (int i = 0; i < files.length; ++i) {
                    items[i] = new XdmAtomicValue(files[i]);
                }
                return new XdmValue(Arrays.asList(items));
            }
        };
    }
}

