/*
 * Decompiled with CFR 0.152.
 */
package lux.index;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import lux.xml.StAXHandler;

public class XmlPathMapper
implements StAXHandler {
    protected StringBuilder currentPath = new StringBuilder();
    protected QName currentQName;
    private HashMap<QName, Integer> eltQNameCounts = new HashMap();
    private HashMap<QName, Integer> attQNameCounts = new HashMap();
    private HashMap<String, Integer> pathCounts = new HashMap();
    private boolean namespaceAware = true;

    public Map<QName, Integer> getEltQNameCounts() {
        return this.eltQNameCounts;
    }

    public Map<QName, Integer> getAttQNameCounts() {
        return this.attQNameCounts;
    }

    public Map<String, Integer> getPathCounts() {
        return this.pathCounts;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    @Override
    public void handleEvent(XMLStreamReader reader, int eventType) {
        if (eventType == 1) {
            this.currentQName = this.getEventQName(reader);
            this.currentPath.append(' ');
            this.currentPath.append(this.encodeQName(this.currentQName));
            this.incrCount(this.eltQNameCounts, this.currentQName);
            String curPath = this.currentPath.toString();
            this.incrCount(this.pathCounts, curPath);
            for (int i = 0; i < reader.getAttributeCount(); ++i) {
                QName attQName = this.getEventAttQName(reader, i);
                this.incrCount(this.attQNameCounts, attQName);
                this.incrCount(this.pathCounts, curPath + " @" + this.encodeQName(attQName));
            }
        } else if (eventType == 2) {
            this.currentQName = this.getEventQName(reader);
            this.currentPath.setLength(this.currentPath.length() - this.encodeQName(this.currentQName).length() - 1);
        } else if (eventType == 7) {
            this.currentPath.append("{}");
        }
    }

    protected QName getEventAttQName(XMLStreamReader reader, int i) {
        return this.createQName(reader.getAttributeLocalName(i), reader.getAttributePrefix(i), reader.getAttributeNamespace(i));
    }

    private QName getEventQName(XMLStreamReader reader) {
        return this.createQName(reader.getLocalName(), reader.getPrefix(), reader.getNamespaceURI());
    }

    private QName createQName(String localName, String prefix, String namespace) {
        if (this.namespaceAware) {
            return new QName(namespace, localName);
        }
        if (!prefix.isEmpty()) {
            return new QName(prefix + ':' + localName);
        }
        return new QName(localName);
    }

    private <T> void incrCount(HashMap<T, Integer> map, T o) {
        if (map.containsKey(o)) {
            map.put(o, map.get(o) + 1);
        } else {
            map.put(o, 1);
        }
    }

    protected String encodeQName(QName qname) {
        if (!this.isNamespaceAware()) {
            if (qname.getPrefix().isEmpty()) {
                return qname.getLocalPart();
            }
            return lux.xml.QName.encode(qname.getLocalPart(), qname.getPrefix());
        }
        return lux.xml.QName.encode(qname.getLocalPart(), qname.getNamespaceURI());
    }

    @Override
    public void reset() {
        this.eltQNameCounts.clear();
        this.attQNameCounts.clear();
        this.pathCounts.clear();
        this.currentPath.setLength(0);
    }
}

