/*
 * Decompiled with CFR 0.152.
 */
package lux.index.field;

import java.util.Iterator;
import lux.exception.LuxException;
import lux.index.XmlIndexer;
import lux.index.field.FieldDefinition;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;

public class XPathField<T>
extends FieldDefinition {
    private final String xpath;

    public XPathField(String name, String xpath, Analyzer analyzer, Field.Store isStored, FieldDefinition.Type type) {
        super(name, analyzer, isStored, type);
        this.xpath = xpath;
    }

    public Iterable<T> getValues(XmlIndexer indexer) {
        XdmValue value;
        try {
            value = indexer.evaluateXPath(this.xpath);
        }
        catch (SaxonApiException e) {
            throw new LuxException("error getting values for field: " + this.getDefaultName(), e);
        }
        return new XPathValueIterator(value.iterator());
    }

    class XPathValueIterator
    implements Iterator<T>,
    Iterable<T> {
        private final XdmSequenceIterator sequence;

        XPathValueIterator(XdmSequenceIterator sequence) {
            this.sequence = sequence;
        }

        @Override
        public boolean hasNext() {
            return this.sequence.hasNext();
        }

        @Override
        public T next() {
            XdmItem item = this.sequence.next();
            switch (XPathField.this.getType()) {
                case STRING: 
                case TEXT: {
                    return item.getStringValue();
                }
                case INT: {
                    return Integer.valueOf(item.getStringValue());
                }
                case LONG: {
                    return Long.valueOf(item.getStringValue());
                }
            }
            throw new IllegalStateException((Object)((Object)XPathField.this.getType()) + " is not a valid type for an XPathField");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }
    }
}

