/*
 * Decompiled with CFR 0.152.
 */
package lux.solr;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import lux.solr.XQueryComponent;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.SolrQueryRequest;
import org.slf4j.LoggerFactory;

public class AppServerComponent
extends XQueryComponent {
    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        String path;
        SolrQueryRequest req = rb.req;
        SolrParams params = req.getParams();
        if (rb.getQueryString() == null && !StringUtils.isBlank((String)(path = params.get("lux.xquery")))) {
            String contents = null;
            if (path.startsWith("resource:")) {
                String p = path.substring("resource:".length());
                InputStream in = AppServerComponent.class.getResourceAsStream(p);
                if (in == null) {
                    throw new SolrException(SolrException.ErrorCode.NOT_FOUND, path + " not found");
                }
                try {
                    contents = IOUtils.toString((InputStream)in);
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(AppServerComponent.class).error("An error occurred while reading " + path, (Throwable)e);
                }
                IOUtils.closeQuietly((InputStream)in);
            } else {
                URL url = new URL(path);
                String scheme = url.getProtocol();
                if (!scheme.equals("lux")) {
                    InputStream in = null;
                    try {
                        if (url.getProtocol().equals("file")) {
                            File f = new File(url.getPath());
                            if (!f.exists()) {
                                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, f + " not found");
                            }
                            if (f.isDirectory() || !f.canRead()) {
                                throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "access to " + f + " denied by rule");
                            }
                            in = new FileInputStream(f);
                        } else {
                            in = url.openStream();
                        }
                        contents = IOUtils.toString((InputStream)in);
                    }
                    catch (IOException e) {
                        LoggerFactory.getLogger(AppServerComponent.class).error("An error occurred while reading " + url, (Throwable)e);
                    }
                    if (in != null) {
                        IOUtils.closeQuietly((InputStream)in);
                    }
                }
            }
            rb.setQueryString(contents);
        }
        super.prepare(rb);
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        this.evaluateQuery(rb, -1, -1);
    }
}

