/*
 * Decompiled with CFR 0.152.
 */
package lux.solr;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class LuxDispatchFilter
implements Filter {
    private String baseURI;

    public void init(FilterConfig filterConfig) throws ServletException {
        String expathRepo;
        this.baseURI = filterConfig.getInitParameter("base-uri");
        if (this.baseURI == null) {
            URI uri;
            String path = filterConfig.getServletContext().getRealPath("/");
            path = path == null ? "resource:/" : (File.separatorChar == '\\' ? "///" + path.replace('\\', '/') : "//" + path);
            try {
                uri = new URI("file", path, null);
            }
            catch (URISyntaxException e) {
                throw new ServletException("Malformed URI for path: " + path, (Throwable)e);
            }
            this.baseURI = uri.toString();
        }
        if ((expathRepo = filterConfig.getInitParameter("org.expath.pkg.saxon.repo")) != null) {
            System.setProperty("org.expath.pkg.saxon.repo", expathRepo);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        int pathOffset;
        HttpServletRequest req;
        String path;
        if (request instanceof HttpServletRequest && ((path = (req = (HttpServletRequest)request).getServletPath()).endsWith(".xqy") || path.contains(".xqy/")) && (pathOffset = path.indexOf(47, 1)) > 0) {
            int pathInfoOffset;
            String servletPath = path.substring(0, pathOffset);
            String xquery = path.substring(pathOffset);
            Request wrapper = new Request(req);
            wrapper.setServletPath(servletPath + "/lux");
            String qs = req.getQueryString();
            HashMap<String, String[]> params = null;
            if (req.getMethod().equals("GET")) {
                Map requestParams = req.getParameterMap();
                params = new HashMap<String, String[]>(requestParams);
            }
            if ((pathInfoOffset = xquery.indexOf(".xqy/")) >= 0) {
                String pathInfo = xquery.substring(pathInfoOffset += ".xqy/".length());
                params.put("lux.pathInfo", new String[]{pathInfo});
                xquery = xquery.substring(0, pathInfoOffset - 1);
                qs = this.appendToQueryString(qs, "lux.pathInfo", pathInfo);
            }
            String query = this.baseURI + xquery;
            if (params != null) {
                params.put("lux.xquery", new String[]{query});
                wrapper.setParameterMap(params);
            }
            qs = this.appendToQueryString(qs, "lux.xquery", query);
            wrapper.setQueryString(qs);
            chain.doFilter((ServletRequest)wrapper, response);
            return;
        }
        chain.doFilter(request, response);
    }

    private String appendToQueryString(String qs, String param, String value) throws UnsupportedEncodingException {
        if (qs == null) {
            return param + '=' + URLEncoder.encode(value, "UTF-8");
        }
        return qs + '&' + param + '=' + URLEncoder.encode(value, "utf-8");
    }

    public void destroy() {
    }

    public class Request
    extends HttpServletRequestWrapper {
        private Map<String, String[]> parameterMap;
        private String pathInfo;
        private String servletPath;
        private String queryString;

        public Request(HttpServletRequest req) {
            super(req);
        }

        public String getServletPath() {
            return this.servletPath;
        }

        public String getPathInfo() {
            return this.pathInfo;
        }

        public Map<String, String[]> getParameterMap() {
            return this.parameterMap;
        }

        public String getQueryString() {
            return this.queryString;
        }

        public void setParameterMap(Map<String, String[]> map) {
            this.parameterMap = map;
        }

        public void setServletPath(String path) {
            this.servletPath = path;
        }

        public void setPathInfo(String path) {
            this.pathInfo = path;
        }

        public void setQueryString(String queryString) {
            this.queryString = queryString;
        }
    }
}

