/*
 * Decompiled with CFR 0.152.
 */
package lux.xml;

import java.util.HashMap;
import java.util.LinkedList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import lux.exception.LuxException;
import lux.xml.StAXHandler;
import org.codehaus.stax2.DTDInfo;
import org.codehaus.stax2.XMLStreamReader2;

public class Serializer
implements StAXHandler {
    private StringBuilder doc;
    private HashMap<String, String> nsContextFrame;
    private HashMap<String, String> inScopeNamespaces;
    private LinkedList<HashMap<String, String>> namespaceContexts;

    public String getDocument() {
        return this.doc.toString();
    }

    @Override
    public void handleEvent(XMLStreamReader r, int evtType) {
        switch (evtType) {
            case 7: {
                this.inScopeNamespaces = new HashMap();
                this.inScopeNamespaces.put("", "");
                this.inScopeNamespaces.put("xml", "http://www.w3.org/2001/XMLSchema");
                this.namespaceContexts = new LinkedList();
                this.doc = new StringBuilder();
                break;
            }
            case 12: {
                this.doc.append("<![CDATA[");
                this.doc.append(r.getTextCharacters(), r.getTextStart(), r.getTextLength());
                this.doc.append("]]>");
                break;
            }
            case 4: 
            case 6: {
                this.appendText(r);
                break;
            }
            case 5: {
                this.doc.append("<!--");
                this.appendText(r);
                this.doc.append("-->");
                break;
            }
            case 8: {
                this.doc.append('\n');
                break;
            }
            case 2: {
                this.doc.append("</");
                this.appendQName(r);
                this.doc.append(">");
                this.unwindNamespaceContext();
                break;
            }
            case 14: 
            case 15: {
                break;
            }
            case 9: {
                this.doc.append('&').append(r.getLocalName()).append(';');
                break;
            }
            case 3: {
                this.doc.append("<?").append(r.getPITarget()).append(' ').append(r.getPIData()).append("?>");
                break;
            }
            case 1: {
                int i;
                this.nsContextFrame = null;
                this.doc.append('<');
                this.appendQName(r);
                this.handleNamespace(r.getPrefix(), r.getNamespaceURI());
                int len = r.getNamespaceCount();
                for (i = 0; i < len; ++i) {
                    this.handleNamespace(r.getNamespacePrefix(i), r.getNamespaceURI(i));
                }
                len = r.getAttributeCount();
                for (i = 0; i < len; ++i) {
                    String prefix = r.getAttributePrefix(i);
                    this.doc.append(' ');
                    if (prefix != null && prefix.length() > 0) {
                        this.doc.append(prefix).append(':');
                    }
                    String value = r.getAttributeValue(i).replace("&", "&amp;").replace("\"", "&quot;").replace("<", "&lt;");
                    this.doc.append(r.getAttributeLocalName(i)).append("=\"").append(value).append('\"');
                }
                this.doc.append(">");
                this.namespaceContexts.push(this.nsContextFrame);
                break;
            }
            case 11: {
                DTDInfo dtd;
                try {
                    dtd = ((XMLStreamReader2)r).getDTDInfo();
                }
                catch (XMLStreamException e) {
                    break;
                }
                this.doc.append("<!DOCTYPE ");
                this.doc.append(dtd.getDTDRootName());
                if (dtd.getDTDPublicId() != null) {
                    this.doc.append(" PUBLIC \"");
                    this.doc.append(dtd.getDTDPublicId());
                    this.doc.append('\"');
                }
                if (dtd.getDTDSystemId() != null) {
                    if (dtd.getDTDPublicId() == null) {
                        this.doc.append(" SYSTEM");
                    }
                    this.doc.append(" \"");
                    this.doc.append(dtd.getDTDSystemId());
                    this.doc.append('\"');
                }
                this.doc.append(">\n");
                break;
            }
            default: {
                throw new LuxException("Unexpected StAX event: " + r.getEventType());
            }
        }
    }

    private void appendText(XMLStreamReader r) {
        int end = r.getTextStart() + r.getTextLength();
        char[] c = r.getTextCharacters();
        block4: for (int i = r.getTextStart(); i < end; ++i) {
            switch (c[i]) {
                case '<': {
                    this.doc.append("&lt;");
                    continue block4;
                }
                case '&': {
                    this.doc.append("&amp;");
                    continue block4;
                }
                default: {
                    this.doc.append(c[i]);
                }
            }
        }
    }

    private void unwindNamespaceContext() {
        HashMap<String, String> nsContext = this.namespaceContexts.pop();
        if (nsContext != null) {
            this.inScopeNamespaces.putAll(nsContext);
        }
    }

    private String handleNamespace(String prefix, String namespace) {
        if (namespace == null) {
            namespace = "";
        }
        if (prefix == null) {
            prefix = "";
        }
        if (!namespace.equals(this.inScopeNamespaces.get(prefix))) {
            this.appendNamespaceDeclaration(prefix, namespace);
            if (this.nsContextFrame == null) {
                this.nsContextFrame = new HashMap();
            }
            this.nsContextFrame.put(prefix, this.inScopeNamespaces.get(prefix));
            this.inScopeNamespaces.put(prefix, namespace);
        }
        return namespace;
    }

    private void appendNamespaceDeclaration(String prefix, String namespace) {
        this.doc.append(" xmlns");
        if (prefix.length() > 0) {
            this.doc.append(':').append(prefix);
        }
        this.doc.append("=\"");
        namespace = namespace.replace("\"", "&quot;");
        this.doc.append(namespace);
        this.doc.append("\"");
    }

    @Override
    public void reset() {
        this.doc = null;
        this.namespaceContexts = null;
        this.inScopeNamespaces = null;
        this.namespaceContexts = null;
    }

    private void appendQName(XMLStreamReader r) {
        String elemPrefix = r.getPrefix();
        String ln = r.getLocalName();
        if (elemPrefix != null && elemPrefix.length() > 0) {
            this.doc.append(elemPrefix).append(':');
        }
        this.doc.append(ln);
    }
}

