/*
 * Decompiled with CFR 0.152.
 */
package lux.xpath;

import lux.xpath.AbstractExpression;
import lux.xpath.ExpressionVisitor;
import lux.xpath.FunCall;
import lux.xpath.LiteralExpression;

public class Subsequence
extends AbstractExpression {
    public Subsequence(AbstractExpression sequence, AbstractExpression start, AbstractExpression length) {
        super(AbstractExpression.Type.SUBSEQUENCE);
        this.setSubs(sequence, start, length);
    }

    public Subsequence(AbstractExpression sequence, AbstractExpression start) {
        super(AbstractExpression.Type.SUBSEQUENCE);
        this.setSubs(sequence, start);
    }

    @Override
    public AbstractExpression accept(ExpressionVisitor visitor) {
        this.acceptSubs(visitor);
        return visitor.visit(this);
    }

    public AbstractExpression getSequence() {
        return this.subs[0];
    }

    public void setSequence(AbstractExpression ae) {
        this.subs[0] = ae;
    }

    public AbstractExpression getStartExpr() {
        return this.subs[1];
    }

    public void setStartExpr(AbstractExpression ae) {
        this.subs[1] = ae;
    }

    public AbstractExpression getLengthExpr() {
        return this.subs.length > 2 ? this.subs[2] : null;
    }

    public void setLengthExpr(AbstractExpression ae) {
        this.subs[2] = ae;
    }

    @Override
    public AbstractExpression getRoot() {
        return this.getSequence().getRoot();
    }

    @Override
    public int getPrecedence() {
        if (this.getLengthExpr() == null) {
            return 1;
        }
        return 19;
    }

    @Override
    public void toString(StringBuilder buf) {
        if (this.getLengthExpr() == null) {
            buf.append("subsequence(");
            this.getSequence().toString(buf);
            buf.append(',');
            this.getStartExpr().toString(buf);
            buf.append(')');
        } else if (this.getLengthExpr().equals(LiteralExpression.ONE) && (this.getStartExpr().getType() == AbstractExpression.Type.LITERAL || this.getStartExpr().equals(FunCall.LastExpression))) {
            this.appendSub(buf, this.getSequence());
            buf.append("[");
            this.getStartExpr().toString(buf);
            buf.append(']');
        } else {
            buf.append("subsequence(");
            this.getSequence().toString(buf);
            buf.append(',');
            this.getStartExpr().toString(buf);
            buf.append(',');
            this.getLengthExpr().toString(buf);
            buf.append(')');
        }
    }
}

