/*
 * Decompiled with CFR 0.152.
 */
package lux.xquery;

import lux.xpath.AbstractExpression;
import lux.xpath.ExpressionVisitor;

public class Conditional
extends AbstractExpression {
    public Conditional(AbstractExpression condition, AbstractExpression trueAction, AbstractExpression falseAction) {
        super(AbstractExpression.Type.CONDITIONAL);
        this.subs = new AbstractExpression[]{condition, trueAction, falseAction};
    }

    @Override
    public AbstractExpression accept(ExpressionVisitor visitor) {
        this.acceptSubs(visitor);
        return visitor.visit(this);
    }

    @Override
    public void toString(StringBuilder buf) {
        buf.append("if (");
        this.getCondition().toString(buf);
        buf.append(")\n then (");
        this.getTrueAction().toString(buf);
        if (this.getFalseAction() != null) {
            buf.append(")\n else (");
            this.getFalseAction().toString(buf);
        }
        buf.append(")");
    }

    public final AbstractExpression getCondition() {
        return this.subs[0];
    }

    public final AbstractExpression getTrueAction() {
        return this.subs[1];
    }

    public final AbstractExpression getFalseAction() {
        return this.subs[2];
    }

    @Override
    public int getPrecedence() {
        return 3;
    }
}

