/*
 * Decompiled with CFR 0.152.
 */
package lux;

import java.net.URI;
import javax.xml.transform.ErrorListener;
import lux.Config;
import lux.DocIDNumberAllocator;
import lux.compiler.EXPathSupport;
import lux.compiler.PathOptimizer;
import lux.compiler.SaxonTranslator;
import lux.exception.LuxException;
import lux.functions.Commit;
import lux.functions.Count;
import lux.functions.DeleteDocument;
import lux.functions.Eval;
import lux.functions.Exists;
import lux.functions.ExtensionFunctions;
import lux.functions.FieldTerms;
import lux.functions.FieldValues;
import lux.functions.Highlight;
import lux.functions.InsertDocument;
import lux.functions.Search;
import lux.functions.Transform;
import lux.functions.file.FileExtensions;
import lux.index.FieldName;
import lux.index.IndexConfiguration;
import lux.xml.GentleXmlReader;
import lux.xquery.XQuery;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.CollectionURIResolver;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.tree.util.DocumentNumberAllocator;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;

public class Compiler {
    private final Logger logger;
    private final Processor processor;
    private final CollectionURIResolver defaultCollectionURIResolver;
    private final String uriFieldName;
    private final IndexConfiguration indexConfig;
    private final boolean isSaxonLicensed;
    private XQuery lastOptimized;
    private SearchStrategy searchStrategy;

    public Compiler(IndexConfiguration config) {
        this(Compiler.makeProcessor(), config);
    }

    public Compiler(Processor processor, IndexConfiguration indexConfig) {
        this.indexConfig = indexConfig;
        this.processor = processor;
        Configuration config = processor.getUnderlyingConfiguration();
        config.setDocumentNumberAllocator((DocumentNumberAllocator)new DocIDNumberAllocator());
        config.setConfigurationProperty("http://saxon.sf.net/feature/xqueryPreserveNamespaces", (Object)false);
        GentleXmlReader parser = new GentleXmlReader();
        config.getParseOptions().setEntityResolver((EntityResolver)parser);
        config.setSourceParserClass("lux.xml.GentleXmlReader");
        boolean bl = this.isSaxonLicensed = config.isLicensedFeature(8) || config.isLicensedFeature(4);
        this.searchStrategy = indexConfig == null || !indexConfig.isIndexingEnabled() ? SearchStrategy.NONE : (this.isSaxonLicensed ? SearchStrategy.SAXON_LICENSE : SearchStrategy.LUX_SEARCH);
        this.defaultCollectionURIResolver = config.getCollectionURIResolver();
        this.registerExtensionFunctions();
        this.uriFieldName = indexConfig.getFieldName(FieldName.URI);
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public XQueryExecutable compile(String exprString) throws LuxException {
        return this.compile(exprString, null, null);
    }

    public XQueryExecutable compile(String exprString, ErrorListener errorListener) throws LuxException {
        return this.compile(exprString, errorListener, null);
    }

    public XQueryExecutable compile(String exprString, ErrorListener errorListener, URI baseURI) throws LuxException {
        XQueryExecutable xquery;
        XQueryCompiler xQueryCompiler = this.getXQueryCompiler();
        if (errorListener != null) {
            xQueryCompiler.setErrorListener(errorListener);
        }
        if (baseURI != null) {
            xQueryCompiler.setBaseURI(baseURI);
        }
        try {
            xquery = xQueryCompiler.compile(exprString);
        }
        catch (SaxonApiException e) {
            throw new LuxException(e);
        }
        SaxonTranslator translator = this.makeTranslator();
        XQuery abstractQuery = translator.queryFor(xquery);
        PathOptimizer optimizer = new PathOptimizer(this.indexConfig);
        optimizer.setSearchStrategy(this.searchStrategy);
        XQuery optimizedQuery = null;
        try {
            optimizedQuery = optimizer.optimize(abstractQuery);
        }
        catch (LuxException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("An error occurred while optimizing: " + abstractQuery.toString());
            }
            throw e;
        }
        this.lastOptimized = optimizedQuery;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("optimized xquery: " + optimizedQuery.toString());
        }
        try {
            xquery = xQueryCompiler.compile(optimizedQuery.toString());
        }
        catch (SaxonApiException e) {
            throw new LuxException(e);
        }
        return xquery;
    }

    private static Processor makeProcessor() {
        try {
            if (Class.forName("com.saxonica.config.EnterpriseConfiguration") != null) {
                return new Processor(true);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            if (Class.forName("com.saxonica.config.ProfessionalConfiguration") != null) {
                return new Processor(true);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Processor p = new Processor((Configuration)new Config());
        if (!StringUtils.isEmpty((String)System.getProperty("org.expath.pkg.saxon.repo"))) {
            EXPathSupport.initializeEXPath(p);
        }
        return p;
    }

    private void registerExtensionFunctions() {
        this.processor.registerExtensionFunction((ExtensionFunctionDefinition)new Search());
        this.processor.registerExtensionFunction((ExtensionFunctionDefinition)new Count());
        this.processor.registerExtensionFunction((ExtensionFunctionDefinition)new Exists());
        this.processor.registerExtensionFunction((ExtensionFunctionDefinition)new FieldTerms());
        this.processor.registerExtensionFunction((ExtensionFunctionDefinition)new FieldValues());
        this.processor.registerExtensionFunction((ExtensionFunctionDefinition)new Transform());
        this.processor.registerExtensionFunction((ExtensionFunctionDefinition)new Eval());
        this.processor.registerExtensionFunction((ExtensionFunctionDefinition)new InsertDocument());
        this.processor.registerExtensionFunction((ExtensionFunctionDefinition)new DeleteDocument());
        this.processor.registerExtensionFunction((ExtensionFunctionDefinition)new Commit());
        this.processor.registerExtensionFunction((ExtensionFunctionDefinition)new Highlight());
        FileExtensions.registerFunctions(this.processor);
        ExtensionFunctions.registerFunctions(this.processor);
    }

    public XsltCompiler getXsltCompiler() {
        return this.processor.newXsltCompiler();
    }

    public XQueryCompiler getXQueryCompiler() {
        XQueryCompiler xqueryCompiler = this.processor.newXQueryCompiler();
        xqueryCompiler.declareNamespace("lux", "http://luxdb.net");
        return xqueryCompiler;
    }

    public XPathCompiler getXPathCompiler() {
        XPathCompiler xpathCompiler = this.processor.newXPathCompiler();
        xpathCompiler.declareNamespace("lux", "http://luxdb.net");
        return xpathCompiler;
    }

    public IndexConfiguration getIndexConfiguration() {
        return this.indexConfig;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public SaxonTranslator makeTranslator() {
        return new SaxonTranslator(this.processor.getUnderlyingConfiguration());
    }

    public CollectionURIResolver getDefaultCollectionURIResolver() {
        return this.defaultCollectionURIResolver;
    }

    public String getUriFieldName() {
        return this.uriFieldName;
    }

    public SearchStrategy getSearchStrategy() {
        return this.searchStrategy;
    }

    public void setSearchStrategy(SearchStrategy searchStrategy) {
        this.searchStrategy = searchStrategy;
    }

    public boolean isSaxonLicensed() {
        return this.isSaxonLicensed;
    }

    public XQuery getLastOptimized() {
        return this.lastOptimized;
    }

    public static enum SearchStrategy {
        NONE,
        LUX_SEARCH,
        SAXON_LICENSE;

    }
}

