/*
 * Decompiled with CFR 0.152.
 */
package lux;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lux.exception.LuxException;
import lux.xml.QName;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmValue;

public class QueryContext {
    private HashMap<QName, Object> variables;
    private Object contextItem;

    public void bindVariable(QName varName, Object value) {
        if (this.variables == null) {
            this.variables = new HashMap();
        }
        if (value == null) {
            this.variables.remove(varName);
        } else {
            XdmValue xdmValue = this.getXdmValue(value);
            this.variables.put(varName, xdmValue);
        }
    }

    private XdmValue getXdmValue(Object value) {
        if (value instanceof XdmValue) {
            return (XdmValue)value;
        }
        if (value instanceof String) {
            return new XdmAtomicValue((String)value);
        }
        if (value instanceof Integer) {
            return new XdmAtomicValue((long)((Integer)value).intValue());
        }
        throw new LuxException("No automatic conversion supplied for " + value.getClass().getName());
    }

    public Map<QName, Object> getVariableBindings() {
        if (this.variables == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.variables);
    }

    public void setContextItem(Object contextItem) {
        this.contextItem = contextItem;
    }

    public Object getContextItem() {
        return this.contextItem;
    }
}

