/*
 * Decompiled with CFR 0.152.
 */
package lux.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import lux.Compiler;
import lux.SearchResultIterator;
import lux.compiler.SlopCounter;
import lux.compiler.VarBinding;
import lux.compiler.XPathQuery;
import lux.exception.LuxException;
import lux.index.FieldName;
import lux.index.IndexConfiguration;
import lux.index.field.FieldDefinition;
import lux.query.NodeTextQuery;
import lux.query.ParseableQuery;
import lux.query.SpanTermPQuery;
import lux.query.TermPQuery;
import lux.xml.QName;
import lux.xml.ValueType;
import lux.xpath.AbstractExpression;
import lux.xpath.BinaryOperation;
import lux.xpath.Dot;
import lux.xpath.ExpressionVisitorBase;
import lux.xpath.FunCall;
import lux.xpath.LiteralExpression;
import lux.xpath.NodeTest;
import lux.xpath.PathExpression;
import lux.xpath.PathStep;
import lux.xpath.Predicate;
import lux.xpath.Root;
import lux.xpath.SearchCall;
import lux.xpath.Sequence;
import lux.xpath.Subsequence;
import lux.xquery.FLWOR;
import lux.xquery.FLWORClause;
import lux.xquery.ForClause;
import lux.xquery.FunctionDefinition;
import lux.xquery.LetClause;
import lux.xquery.OrderByClause;
import lux.xquery.SortKey;
import lux.xquery.Variable;
import lux.xquery.VariableBindingClause;
import lux.xquery.VariableContext;
import lux.xquery.WhereClause;
import lux.xquery.XQuery;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;
import org.slf4j.LoggerFactory;

public class PathOptimizer
extends ExpressionVisitorBase {
    private final ArrayList<XPathQuery> queryStack = new ArrayList();
    private final HashMap<QName, VarBinding> varBindings = new HashMap();
    private final IndexConfiguration indexConfig;
    private final XPathQuery MATCH_ALL;
    private final String attrQNameField;
    private final String elementQNameField;
    private boolean optimizeForOrderedResults;
    private static final boolean DEBUG = false;

    public PathOptimizer(IndexConfiguration indexConfig) {
        this.MATCH_ALL = XPathQuery.getMatchAllQuery(indexConfig);
        this.indexConfig = indexConfig;
        this.attrQNameField = indexConfig.getFieldName(FieldName.ATT_QNAME);
        this.elementQNameField = indexConfig.getFieldName(FieldName.ELT_QNAME);
        this.optimizeForOrderedResults = true;
    }

    public XQuery optimize(XQuery query) {
        this.queryStack.clear();
        this.push(this.MATCH_ALL);
        AbstractExpression main = query.getBody();
        if (main != null) {
            main = this.indexConfig.isIndexingEnabled() ? this.optimize(main) : main.replaceRoot(new FunCall(FunCall.FN_COLLECTION, ValueType.DOCUMENT, new AbstractExpression[0]));
            return new XQuery(query.getDefaultElementNamespace(), query.getDefaultFunctionNamespace(), query.getDefaultCollation(), query.getModuleImports(), query.getNamespaceDeclarations(), query.getVariableDefinitions(), this.optimizeFunctionDefinitions(query.getFunctionDefinitions()), main, query.getBaseURI(), query.isPreserveNamespaces(), query.isInheritNamespaces(), query.isEmptyLeast());
        }
        return query;
    }

    private FunctionDefinition[] optimizeFunctionDefinitions(FunctionDefinition[] functionDefinitions) {
        int i = 0;
        while (i < functionDefinitions.length) {
            FunctionDefinition function = functionDefinitions[i];
            AbstractExpression[] abstractExpressionArray = function.getSubs();
            int n = abstractExpressionArray.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractExpression var = abstractExpressionArray[n2];
                this.setUnboundVariable((Variable)var);
                ++n2;
            }
            AbstractExpression body = this.optimize(function.getBody());
            functionDefinitions[i] = function = new FunctionDefinition(function.getName(), function.getReturnType(), function.getCardinality(), (Variable[])function.getSubs(), body);
            AbstractExpression[] abstractExpressionArray2 = function.getSubs();
            int n3 = abstractExpressionArray2.length;
            n = 0;
            while (n < n3) {
                AbstractExpression var = abstractExpressionArray2[n];
                this.descopeVariable(((Variable)var).getQName());
                ++n;
            }
            ++i;
        }
        return functionDefinitions;
    }

    public AbstractExpression optimize(AbstractExpression expr) {
        expr = expr.accept(this);
        return this.optimizeExpression(expr, this.peek());
    }

    private AbstractExpression optimizeExpression(AbstractExpression expr, int i) {
        int j = this.queryStack.size() - i - 1;
        return this.optimizeExpression(expr, this.queryStack.get(j));
    }

    private AbstractExpression optimizeExpression(AbstractExpression expr, XPathQuery query) {
        AbstractExpression tail;
        if (expr instanceof SearchCall) {
            return this.mergeSearchCall((SearchCall)expr, query);
        }
        if (!expr.isAbsolute()) {
            return expr;
        }
        FunCall search = this.createSearchCall(FunCall.LUX_SEARCH, query);
        if (search.getReturnType().equals((Object)ValueType.DOCUMENT) && (tail = expr.getTail()) != null) {
            return new Predicate(search, tail);
        }
        AbstractExpression root = expr.getRoot();
        if (root instanceof Root) {
            for (Map.Entry<QName, VarBinding> entry : this.varBindings.entrySet()) {
                VarBinding binding = entry.getValue();
                if (binding.getExpr() != root) continue;
                this.varBindings.put(entry.getKey(), new VarBinding(binding.getVar(), search, binding.getQuery(), binding.getContext(), binding.getShadowedBinding()));
            }
            return expr.replaceRoot(search);
        }
        return expr;
    }

    private void optimizeSubExpressions(AbstractExpression expr) {
        AbstractExpression[] subs = expr.getSubs();
        int i = 0;
        while (i < subs.length) {
            subs[i] = this.optimizeExpression(subs[i], subs.length - i - 1);
            ++i;
        }
    }

    private void combineTopQueries(int n, BooleanClause.Occur occur) {
        this.combineTopQueries(n, occur, null);
    }

    private void combineTopQueries(int n, BooleanClause.Occur occur, ValueType valueType) {
        if (n <= 0) {
            this.push(this.MATCH_ALL);
            return;
        }
        XPathQuery query = this.pop();
        if (n == 1) {
            ValueType type = valueType == null ? query.getResultType() : query.getResultType().promote(valueType);
            query = XPathQuery.getQuery(query.getParseableQuery(), query.getFacts(), type, this.indexConfig, query.getSortFields());
        } else {
            int i = 0;
            while (i < n - 1) {
                query = this.combineQueries(this.pop(), occur, query, valueType);
                ++i;
            }
        }
        if (valueType == ValueType.DOCUMENT) {
            query.setFact(4, true);
        }
        this.push(query);
    }

    public XPathQuery peek() {
        return this.queryStack.size() == 0 ? null : this.queryStack.get(this.queryStack.size() - 1);
    }

    void push(XPathQuery query) {
        this.queryStack.add(query);
    }

    XPathQuery pop() {
        return this.queryStack.remove(this.queryStack.size() - 1);
    }

    private void debug(String tag, AbstractExpression expr) {
        int i = 0;
        while (i < this.queryStack.size()) {
            System.err.print(' ');
            ++i;
        }
        String desc = expr.toString();
        if (desc.length() > 30) {
            desc = desc.substring(0, 30);
            desc = desc.replaceAll("\\s+", " ");
        }
        System.err.println(String.valueOf(tag) + ' ' + (Object)((Object)expr.getType()) + ' ' + desc + "  depth=" + this.queryStack.size() + ", query: " + this.peek());
    }

    @Override
    public AbstractExpression visit(Root expr) {
        this.push(this.MATCH_ALL);
        return expr;
    }

    @Override
    public AbstractExpression visit(PathExpression pathExpr) {
        XPathQuery rq = this.pop();
        XPathQuery lq = this.pop();
        AbstractExpression lhs = pathExpr.getLHS();
        XPathQuery query = this.combineAdjacentQueries(lhs, pathExpr.getRHS(), lq, rq, ResultOrientation.RIGHT);
        this.push(query);
        return pathExpr;
    }

    @Override
    public AbstractExpression visit(Predicate predicate) {
        AbstractExpression filter = predicate.getFilter();
        predicate.setFilter(this.optimizeExpression(filter, this.peek()));
        XPathQuery filterQuery = this.pop();
        XPathQuery baseQuery = this.pop();
        XPathQuery query = this.combineAdjacentQueries(predicate.getBase(), filter, baseQuery, filterQuery, ResultOrientation.LEFT);
        query.setBaseQuery(baseQuery);
        this.push(query);
        this.optimizeComparison(predicate);
        this.peek().setFact(4, baseQuery.isFact(4));
        return predicate;
    }

    private XPathQuery combineAdjacentQueries(AbstractExpression left, AbstractExpression right, XPathQuery lq, XPathQuery rq, ResultOrientation orient) {
        XPathQuery query;
        AbstractExpression binding;
        Integer rSlop = null;
        Integer lSlop = null;
        if (left instanceof Variable && (binding = this.getBoundExpression(((Variable)left).getQName())) != null) {
            left = binding;
        }
        if (this.indexConfig.isOption(64)) {
            SlopCounter slopCounter = new SlopCounter();
            right.accept(slopCounter);
            rSlop = slopCounter.getSlop();
            if (rSlop != null) {
                slopCounter.reset();
                slopCounter.setReverse(true);
                left.accept(slopCounter);
                lSlop = slopCounter.getSlop();
            }
        }
        ValueType resultType = orient == ResultOrientation.RIGHT ? rq.getResultType() : lq.getResultType();
        XPathQuery baseQuery = lq.getBaseQuery();
        if (rSlop != null && lSlop != null) {
            XPathQuery base = baseQuery != null ? baseQuery : lq;
            query = base.combineSpanQueries(rq, BooleanClause.Occur.MUST, resultType, rSlop + lSlop, this.indexConfig);
            if (baseQuery != null) {
                query = this.combineQueries(lq, BooleanClause.Occur.MUST, query, query.getResultType());
            }
        } else {
            query = this.combineQueries(lq, BooleanClause.Occur.MUST, rq, resultType);
        }
        return query;
    }

    @Override
    public AbstractExpression visit(PathStep step) {
        XPathQuery query;
        boolean isMinimal;
        QName name = step.getNodeTest().getQName();
        PathStep.Axis axis = step.getAxis();
        XPathQuery currentQuery = this.peek();
        boolean isSingular = currentQuery.isFact(4);
        if (axis == PathStep.Axis.Descendant || axis == PathStep.Axis.DescendantSelf || axis == PathStep.Axis.Attribute) {
            isMinimal = !step.getNodeTest().isWild() || currentQuery.isEmpty();
            if (axis != PathStep.Axis.Attribute) {
                isSingular = false;
            }
        } else {
            boolean isElementStep = step.getNodeTest().getType().is(ValueType.ELEMENT);
            if (axis == PathStep.Axis.Child) {
                boolean isPathIndexed = this.indexConfig.isOption(64);
                ValueType type = currentQuery.getResultType();
                boolean currentMinimal = currentQuery.isFact(2);
                if (ValueType.NODE.is(type)) {
                    isMinimal = currentMinimal;
                    isSingular = false;
                } else if (ValueType.DOCUMENT == type) {
                    isMinimal = isPathIndexed && currentMinimal || step.getNodeTest().isWild();
                    isSingular = (isPathIndexed || step.getNodeTest().isWild()) && isElementStep;
                } else {
                    isMinimal = isPathIndexed && isElementStep && currentMinimal;
                    isSingular = false;
                }
            } else if (axis == PathStep.Axis.Ancestor || axis == PathStep.Axis.AncestorSelf || axis == PathStep.Axis.Self) {
                isMinimal = !step.getNodeTest().isWild() || currentQuery.isEmpty() || !isElementStep;
                isSingular = false;
            } else {
                isMinimal = false;
            }
        }
        long facts = currentQuery.getFacts() & 0xFFFFFFFFFFFFFFBFL;
        facts = !isSingular ? (facts &= 0xFFFFFFFFFFFFFFFBL) : (facts |= 4L);
        if (!isMinimal) {
            facts &= 0xFFFFFFFFFFFFFFFDL;
        }
        if (name == null) {
            ValueType type = step.getNodeTest().getType();
            if (axis == PathStep.Axis.Self && (type == ValueType.NODE || type == ValueType.VALUE)) {
                type = currentQuery.getResultType();
            } else if (axis == PathStep.Axis.AncestorSelf && (type == ValueType.NODE || type == ValueType.VALUE) && currentQuery.getResultType() == ValueType.DOCUMENT) {
                type = ValueType.DOCUMENT;
            }
            query = XPathQuery.getQuery(this.MATCH_ALL.getParseableQuery(), facts, type, this.indexConfig, currentQuery.getSortFields());
        } else {
            ParseableQuery termQuery = this.nodeNameTermQuery(step.getAxis(), name);
            query = XPathQuery.getQuery(termQuery, facts, step.getNodeTest().getType(), this.indexConfig, currentQuery.getSortFields());
        }
        this.push(query);
        return step;
    }

    @Override
    public AbstractExpression visit(FunCall funcall) {
        QName name = funcall.getName();
        AbstractExpression luxfunc = this.optimizeFunCall(funcall);
        if (luxfunc != funcall) {
            return luxfunc;
        }
        this.optimizeSubExpressions(funcall);
        BooleanClause.Occur occur = name.equals(FunCall.FN_ROOT) || name.equals(FunCall.FN_DATA) || name.equals(FunCall.FN_EXISTS) ? BooleanClause.Occur.MUST : BooleanClause.Occur.SHOULD;
        AbstractExpression[] args = funcall.getSubs();
        this.combineTopQueries(args.length, occur, funcall.getReturnType());
        if (occur == BooleanClause.Occur.SHOULD) {
            this.push(this.pop().setFact(32, true));
        }
        if (name.equals(FunCall.LUX_FIELD_VALUES) && args.length > 0) {
            AbstractExpression sortContext;
            AbstractExpression arg = args[0];
            if (args.length > 1) {
                sortContext = args[1];
            } else {
                sortContext = funcall.getSuper();
                if (sortContext == null) {
                    return funcall;
                }
            }
            VariableContext binding = sortContext.getBindingContext();
            if (binding == null || !(binding instanceof ForClause)) {
                return funcall;
            }
            if (arg.getType() == AbstractExpression.Type.LITERAL) {
                SortField.Type sortType;
                String fieldName = ((LiteralExpression)arg).getValue().toString();
                FieldDefinition fieldDefinition = this.indexConfig.getField(fieldName);
                if (fieldDefinition != null) {
                    sortType = fieldDefinition.getType().getLuceneSortFieldType();
                } else {
                    sortType = FieldDefinition.Type.STRING.getLuceneSortFieldType();
                    LoggerFactory.getLogger(PathOptimizer.class).warn("Sorting by unknown field: {}", (Object)fieldName);
                }
                this.peek().setSortFields(new SortField[]{new SortField(fieldName, sortType)});
            }
        }
        return funcall;
    }

    private AbstractExpression optimizeFunCall(FunCall funcall) {
        AbstractExpression[] subs = funcall.getSubs();
        QName fname = funcall.getName();
        AbstractExpression searchArg = null;
        if (subs.length == 1 && this.isSearchCall(subs[0])) {
            if (fname.equals(FunCall.FN_COUNT) || fname.equals(FunCall.FN_EXISTS) || fname.equals(FunCall.FN_EMPTY)) {
                searchArg = subs[0].getSubs()[0];
            }
        } else {
            if (fname.equals(FunCall.LUX_SEARCH) && !(funcall instanceof SearchCall)) {
                if (subs.length == 1) {
                    return new SearchCall(subs[0]);
                }
                return funcall;
            }
            if (subs.length == 1 && !subs[0].isAbsolute()) {
                return funcall;
            }
        }
        if (fname.equals(FunCall.FN_COLLECTION) && subs.length == 0) {
            this.push(this.MATCH_ALL);
            return new Root();
        }
        XPathQuery query = this.pop();
        if (query.isMinimal()) {
            int functionFacts = 0;
            ValueType returnType = null;
            QName qname = null;
            if (fname.equals(FunCall.FN_COUNT) && query.isFact(4)) {
                functionFacts = 4;
                returnType = ValueType.INT;
                qname = FunCall.LUX_COUNT;
            } else if (fname.equals(FunCall.FN_EXISTS)) {
                returnType = ValueType.BOOLEAN;
                qname = FunCall.LUX_EXISTS;
            } else if (fname.equals(FunCall.FN_EMPTY)) {
                functionFacts = 16;
                returnType = ValueType.BOOLEAN_FALSE;
                qname = FunCall.LUX_EXISTS;
            } else if (fname.equals(FunCall.FN_CONTAINS)) {
                if (!subs[0].isAbsolute()) {
                    this.push(query);
                    return funcall;
                }
                returnType = ValueType.BOOLEAN;
                qname = FunCall.LUX_SEARCH;
            }
            if (qname != null) {
                if (searchArg != null) {
                    this.push(this.MATCH_ALL);
                    return new FunCall(qname, returnType, searchArg, new LiteralExpression(2));
                }
                query = query.setFact(functionFacts, true);
                query.setType(returnType);
                AbstractExpression root = subs[0].getRoot();
                if (!this.isSearchCall(root)) {
                    this.push(this.MATCH_ALL);
                    return this.createSearchCall(qname, query);
                }
            }
        }
        this.push(query);
        return funcall;
    }

    private boolean isSearchCall(AbstractExpression root) {
        return root instanceof SearchCall || root instanceof FunCall && ((FunCall)root).getName().equals(FunCall.LUX_SEARCH);
    }

    private XPathQuery combineQueries(XPathQuery lq, BooleanClause.Occur occur, XPathQuery rq, ValueType resultType) {
        XPathQuery query = this.indexConfig.isOption(64) ? lq.combineSpanQueries(rq, occur, resultType, -1, this.indexConfig) : lq.combineBooleanQueries(occur, rq, occur, resultType, this.indexConfig);
        return query;
    }

    private ParseableQuery nodeNameTermQuery(PathStep.Axis axis, QName name) {
        String nodeName = name.getEncodedName();
        if (this.indexConfig.isOption(64)) {
            if (axis == PathStep.Axis.Attribute) {
                nodeName = String.valueOf('@') + nodeName;
            }
            Term term = new Term(this.indexConfig.getFieldName(FieldName.PATH), nodeName);
            return new SpanTermPQuery(term);
        }
        String fieldName = axis == PathStep.Axis.Attribute ? this.attrQNameField : this.elementQNameField;
        Term term = new Term(fieldName, nodeName);
        return new TermPQuery(term);
    }

    @Override
    public AbstractExpression visit(Dot dot) {
        this.push(this.MATCH_ALL);
        return dot;
    }

    @Override
    public AbstractExpression visit(BinaryOperation op) {
        this.optimizeSubExpressions(op);
        XPathQuery rq = this.pop();
        XPathQuery lq = this.pop();
        ValueType argType = lq.getResultType().promote(rq.getResultType());
        ValueType resultType = null;
        BooleanClause.Occur occur = BooleanClause.Occur.SHOULD;
        boolean minimal = false;
        boolean required = false;
        switch (op.getOperator()) {
            case AND: {
                occur = BooleanClause.Occur.MUST;
            }
            case OR: {
                minimal = true;
                required = true;
                resultType = ValueType.BOOLEAN;
                break;
            }
            case ADD: 
            case SUB: 
            case MUL: 
            case DIV: 
            case IDIV: 
            case MOD: {
                resultType = ValueType.ATOMIC;
                break;
            }
            case AEQ: 
            case ANE: 
            case ALT: 
            case ALE: 
            case AGT: 
            case AGE: {
                if (lq.getResultType().isNode || rq.getResultType().isNode) {
                    required = true;
                    occur = BooleanClause.Occur.MUST;
                }
                resultType = ValueType.BOOLEAN;
                break;
            }
            case EQUALS: 
            case NE: 
            case LT: 
            case GT: 
            case LE: 
            case GE: {
                if (lq.getResultType().isNode || rq.getResultType().isNode) {
                    required = true;
                    occur = BooleanClause.Occur.MUST;
                }
                resultType = ValueType.BOOLEAN;
                break;
            }
            case IS: 
            case BEFORE: 
            case AFTER: {
                required = true;
                resultType = ValueType.BOOLEAN;
                break;
            }
            case INTERSECT: {
                occur = BooleanClause.Occur.MUST;
            }
            case UNION: {
                minimal = true;
                required = true;
                resultType = argType;
                break;
            }
            case EXCEPT: {
                this.push(this.combineQueries(lq, BooleanClause.Occur.MUST, rq, argType));
                resultType = argType;
                required = true;
                return op;
            }
            case TO: {
                resultType = ValueType.INTEGER;
            }
        }
        XPathQuery query = this.combineQueries(lq, occur, rq, resultType);
        if (!minimal) {
            query = query.setFact(2, false);
        }
        if (!required) {
            query = query.setFact(32, true);
        }
        this.push(query);
        return op;
    }

    private void optimizeComparison(Predicate predicate) {
        if (!this.indexConfig.isOption(128)) {
            return;
        }
        LiteralExpression value = null;
        AbstractExpression path = null;
        AbstractExpression filter = predicate.getFilter();
        if (filter.getType() == AbstractExpression.Type.BINARY_OPERATION) {
            BinaryOperation op = (BinaryOperation)predicate.getFilter();
            if (op.getOperator() != BinaryOperation.Operator.EQUALS && op.getOperator() != BinaryOperation.Operator.AEQ) {
                return;
            }
        } else if (filter.getType() == AbstractExpression.Type.FUNCTION_CALL) {
            if (!((FunCall)filter).getName().equals(FunCall.FN_CONTAINS)) {
                return;
            }
        } else {
            return;
        }
        if (filter.getSubs()[0].getType() == AbstractExpression.Type.LITERAL) {
            value = (LiteralExpression)filter.getSubs()[0];
            path = filter.getSubs()[1];
        } else if (filter.getSubs()[1].getType() == AbstractExpression.Type.LITERAL) {
            value = (LiteralExpression)filter.getSubs()[1];
            path = filter.getSubs()[0];
        } else {
            return;
        }
        AbstractExpression last = path.getLastContextStep();
        if (last.getType() == AbstractExpression.Type.DOT) {
            last = predicate.getBase().getLastContextStep();
        }
        if (last.getType() == AbstractExpression.Type.PATH_STEP) {
            String v = value.getValue().toString();
            if (filter.getType() == AbstractExpression.Type.FUNCTION_CALL) {
                if (v.matches("\\w+")) {
                    this.createTermQuery((PathStep)last, path, "*" + v + "*");
                }
            } else {
                this.createTermQuery((PathStep)last, path, v);
            }
        }
    }

    private void createTermQuery(PathStep context, AbstractExpression path, String value) {
        NodeTest nodeTest = context.getNodeTest();
        QName nodeName = nodeTest.getQName();
        ParseableQuery termQuery = null;
        if (nodeName == null || "*".equals(nodeName.getPrefix()) || "*".equals(nodeName.getLocalPart())) {
            termQuery = PathOptimizer.makeTextQuery(value, this.indexConfig);
        } else if (nodeTest.getType() == ValueType.ELEMENT) {
            termQuery = PathOptimizer.makeElementValueQuery(nodeName, value, this.indexConfig);
        } else if (nodeTest.getType() == ValueType.ATTRIBUTE) {
            termQuery = PathOptimizer.makeAttributeValueQuery(nodeName, value, this.indexConfig);
        }
        if (termQuery != null) {
            XPathQuery query = XPathQuery.getQuery(termQuery, 2L, nodeTest.getType(), this.indexConfig, null);
            XPathQuery baseQuery = this.pop();
            query = this.combineQueries(query, BooleanClause.Occur.MUST, baseQuery, baseQuery.getResultType());
            this.push(query);
        }
    }

    public static NodeTextQuery makeElementValueQuery(QName qname, String value, IndexConfiguration config) {
        return new NodeTextQuery(new Term(config.getFieldName(IndexConfiguration.ELEMENT_TEXT), value), qname.getEncodedName());
    }

    public static ParseableQuery makeAttributeValueQuery(QName qname, String value, IndexConfiguration config) {
        return new NodeTextQuery(new Term(config.getFieldName(IndexConfiguration.ATTRIBUTE_TEXT), value), qname.getEncodedName());
    }

    public static ParseableQuery makeTextQuery(String value, IndexConfiguration config) {
        return new NodeTextQuery(new Term(config.getFieldName(IndexConfiguration.XML_TEXT), value));
    }

    @Override
    public AbstractExpression visit(LiteralExpression literal) {
        this.push(this.MATCH_ALL.setFact(32, true));
        return literal;
    }

    @Override
    public AbstractExpression visit(Variable variable) {
        QName qName = variable.getQName();
        VarBinding varBinding = this.varBindings.get(qName);
        if (varBinding != null) {
            XPathQuery q = varBinding.getQuery();
            this.push(q);
            AbstractExpression value = varBinding.getExpr();
            variable.setValue(value);
            variable.setBindingContext(varBinding.getContext());
        } else {
            this.push(this.MATCH_ALL.setFact(32, true));
        }
        return variable;
    }

    @Override
    public AbstractExpression visit(Subsequence subsequence) {
        this.optimizeSubExpressions(subsequence);
        AbstractExpression length = subsequence.getLengthExpr();
        AbstractExpression start = subsequence.getStartExpr();
        if (length != null) {
            this.pop();
        }
        this.pop();
        if (start == FunCall.LastExpression || start.equals(LiteralExpression.ONE) && length.equals(LiteralExpression.ONE)) {
            return subsequence;
        }
        this.push(this.pop().setFact(6, false));
        return this.optimizeStart(subsequence);
    }

    private AbstractExpression optimizeStart(Subsequence subsequence) {
        boolean isSingular;
        AbstractExpression sequence = subsequence.getSequence();
        AbstractExpression start = subsequence.getStartExpr();
        AbstractExpression length = subsequence.getLengthExpr();
        AbstractExpression root = sequence.getRoot();
        if (root == null || root.getType() != AbstractExpression.Type.FUNCTION_CALL || LiteralExpression.ONE.equals(start)) {
            return subsequence;
        }
        FunCall search = (FunCall)root;
        AbstractExpression[] args = search.getSubs();
        if (args.length >= 4) {
            return subsequence;
        }
        if (args.length < 1) {
            isSingular = true;
        } else {
            LiteralExpression factsArg = (LiteralExpression)args[1];
            long facts = factsArg.equals(LiteralExpression.EMPTY) ? 0L : (Long)factsArg.getValue();
            boolean bl = isSingular = (facts & 4L) != 0L;
        }
        if (isSingular) {
            AbstractExpression[] newArgs = new AbstractExpression[4];
            int i = 0;
            while (i < args.length) {
                newArgs[i] = args[i];
                ++i;
            }
            while (i < 3) {
                newArgs[i++] = LiteralExpression.EMPTY;
            }
            newArgs[i] = start;
            search.setArguments(newArgs);
            if (length == null || length.equals(LiteralExpression.EMPTY)) {
                return search;
            }
            subsequence.setStartExpr(LiteralExpression.ONE);
        }
        return subsequence;
    }

    private SearchCall mergeSearchCall(SearchCall search, XPathQuery query) {
        search.combineQuery(query, this.indexConfig);
        return search;
    }

    private FunCall createSearchCall(QName functionName, XPathQuery query) {
        if (functionName.equals(FunCall.LUX_SEARCH)) {
            return new SearchCall(query, this.indexConfig);
        }
        return new FunCall(functionName, query.getResultType(), query.toXmlNode(this.indexConfig.getDefaultFieldName(), this.indexConfig), new LiteralExpression(query.getFacts()));
    }

    @Override
    public AbstractExpression visit(Sequence sequence) {
        this.optimizeSubExpressions(sequence);
        this.combineTopQueries(sequence.getSubs().length, BooleanClause.Occur.SHOULD);
        return sequence;
    }

    private void popChildQueries(AbstractExpression expr) {
        int i = 0;
        while (i < expr.getSubs().length) {
            this.pop();
            ++i;
        }
        this.push(this.MATCH_ALL);
    }

    @Override
    public AbstractExpression visitDefault(AbstractExpression expr) {
        this.optimizeSubExpressions(expr);
        this.popChildQueries(expr);
        return expr;
    }

    @Override
    public AbstractExpression visit(FLWOR flwor) {
        flwor.getSubs()[0] = this.optimizeExpression(flwor.getReturnExpression(), this.peek());
        this.peek().setSortFields(null);
        int length = flwor.getClauses().length;
        int i = length - 1;
        while (i >= 0) {
            FLWORClause clause = flwor.getClauses()[i];
            AbstractExpression seq = clause.getSequence();
            if (clause instanceof VariableBindingClause) {
                QName varName = ((VariableBindingClause)clause).getVariable().getQName();
                this.descopeVariable(varName);
            }
            if (clause instanceof LetClause) {
                XPathQuery top = this.pop();
                XPathQuery letQuery = this.pop();
                letQuery.setFact(32, false);
                letQuery = this.combineQueries(letQuery, BooleanClause.Occur.MUST, top, letQuery.getResultType());
                clause.setSequence(this.optimizeExpression(seq, letQuery));
                this.push(top);
            } else {
                this.combineTopQueries(2, BooleanClause.Occur.MUST);
            }
            if (clause instanceof ForClause) {
                clause.setSequence(this.optimizeExpression(seq, this.peek()));
            }
            --i;
        }
        return flwor;
    }

    private void descopeVariable(QName varName) {
        VarBinding binding = this.varBindings.remove(varName);
        if (binding != null && binding.getShadowedBinding() != null) {
            this.varBindings.put(varName, binding.getShadowedBinding());
        }
    }

    @Override
    public OrderByClause visit(OrderByClause orderByClause) {
        LinkedList<SortField> sortFields = new LinkedList<SortField>();
        ArrayList<SortKey> sortKeys = orderByClause.getSortKeys();
        boolean foundUnindexedSort = false;
        int stackOffset = this.queryStack.size() - sortKeys.size();
        int i = 0;
        while (i < sortKeys.size()) {
            XPathQuery q = this.queryStack.remove(stackOffset);
            SortKey sortKey = sortKeys.get(i);
            AbstractExpression key = sortKey.getKey();
            if (q.getSortFields() == null) {
                foundUnindexedSort = true;
            } else if (!foundUnindexedSort) {
                FunCall keyFun;
                if (key instanceof FunCall && (keyFun = (FunCall)key).getName().equals(FunCall.LUX_FIELD_VALUES) && keyFun.getSubs().length < 2) {
                    throw new LuxException("lux:field-values($key) depends on the context where there is no context defined");
                }
                String order = sortKey.getOrder().getValue().toString();
                SortField sortField = q.getSortFields()[0];
                if (!sortKey.isEmptyLeast()) {
                    sortField = new SortField(sortField.getField(), (FieldComparatorSource)SearchResultIterator.MISSING_LAST, order.toString().equals("descending"));
                } else if (order.toString().equals("descending")) {
                    sortField = new SortField(sortField.getField(), sortField.getType(), true);
                }
                sortFields.add(sortField);
                sortKeys.remove(i);
                --i;
            }
            ++i;
        }
        if (sortFields.isEmpty()) {
            this.push(this.MATCH_ALL);
        } else {
            XPathQuery query = XPathQuery.getQuery(this.MATCH_ALL.getParseableQuery(), this.MATCH_ALL.getFacts(), this.MATCH_ALL.getResultType(), this.indexConfig, sortFields.toArray(new SortField[sortFields.size()]));
            this.push(query);
        }
        return orderByClause;
    }

    @Override
    public ForClause visit(ForClause forClause) {
        this.visitVariableBinding(forClause);
        return forClause;
    }

    @Override
    public WhereClause visit(WhereClause whereClause) {
        this.pop();
        this.push(this.MATCH_ALL);
        return whereClause;
    }

    @Override
    public LetClause visit(LetClause letClause) {
        this.visitVariableBinding(letClause);
        this.peek().setFact(32, true);
        return letClause;
    }

    private void visitVariableBinding(VariableBindingClause clause) {
        XPathQuery q = this.peek();
        q.setSortFields(null);
        this.setBoundExpression(clause, q);
    }

    private void setUnboundVariable(Variable var) {
        QName name = var.getQName();
        VarBinding currentBinding = this.varBindings.get(name);
        VarBinding newBinding = new VarBinding(var, null, this.MATCH_ALL, null, currentBinding);
        this.varBindings.put(name, newBinding);
    }

    private void setBoundExpression(VariableBindingClause clause, XPathQuery q) {
        Variable var = clause.getVariable();
        QName name = var.getQName();
        VarBinding currentBinding = this.varBindings.get(name);
        VarBinding newBinding = new VarBinding(var, clause.getSequence(), q, clause, currentBinding);
        this.varBindings.put(name, newBinding);
    }

    public AbstractExpression getBoundExpression(QName name) {
        VarBinding binding = this.varBindings.get(name);
        while (binding != null && binding.getExpr() instanceof Variable) {
            binding = this.varBindings.get(((Variable)binding.getExpr()).getQName());
        }
        return binding == null ? null : binding.getExpr();
    }

    public boolean isOptimizedForOrderedResults() {
        return this.optimizeForOrderedResults;
    }

    public void setSearchStrategy(Compiler.SearchStrategy searchStrategy) {
        this.optimizeForOrderedResults = searchStrategy == Compiler.SearchStrategy.LUX_SEARCH;
    }

    private static enum ResultOrientation {
        LEFT,
        RIGHT;

    }
}

