/*
 * Decompiled with CFR 0.152.
 */
package lux.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lux.exception.LuxException;
import lux.xml.QName;
import lux.xml.ValueType;
import lux.xpath.AbstractExpression;
import lux.xpath.BinaryOperation;
import lux.xpath.Dot;
import lux.xpath.FunCall;
import lux.xpath.LiteralExpression;
import lux.xpath.Namespace;
import lux.xpath.PathExpression;
import lux.xpath.PathStep;
import lux.xpath.Predicate;
import lux.xpath.Root;
import lux.xpath.Sequence;
import lux.xpath.Subsequence;
import lux.xpath.UnaryMinus;
import lux.xquery.AttributeConstructor;
import lux.xquery.CommentConstructor;
import lux.xquery.ComputedElementConstructor;
import lux.xquery.Conditional;
import lux.xquery.DocumentConstructor;
import lux.xquery.ElementConstructor;
import lux.xquery.FLWOR;
import lux.xquery.FLWORClause;
import lux.xquery.FunctionDefinition;
import lux.xquery.InstanceOf;
import lux.xquery.LetClause;
import lux.xquery.ModuleImport;
import lux.xquery.OrderByClause;
import lux.xquery.ProcessingInstructionConstructor;
import lux.xquery.Satisfies;
import lux.xquery.SortKey;
import lux.xquery.TextConstructor;
import lux.xquery.TreatAs;
import lux.xquery.Variable;
import lux.xquery.VariableDefinition;
import lux.xquery.XQuery;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.CastableExpression;
import net.sf.saxon.expr.CompareToIntegerConstant;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.InstanceOfExpression;
import net.sf.saxon.expr.IntegerRangeTest;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.LastItemExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.NegateExpression;
import net.sf.saxon.expr.ParentNodeExpression;
import net.sf.saxon.expr.PositionVariable;
import net.sf.saxon.expr.QuantifiedExpression;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.TailCallLoop;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.flwor.Clause;
import net.sf.saxon.expr.flwor.FLWORExpression;
import net.sf.saxon.expr.flwor.ForClause;
import net.sf.saxon.expr.flwor.LocalVariableBinding;
import net.sf.saxon.expr.flwor.WhereClause;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.instruct.Comment;
import net.sf.saxon.expr.instruct.ComputedAttribute;
import net.sf.saxon.expr.instruct.ComputedElement;
import net.sf.saxon.expr.instruct.CopyOf;
import net.sf.saxon.expr.instruct.DocumentInstr;
import net.sf.saxon.expr.instruct.FixedAttribute;
import net.sf.saxon.expr.instruct.FixedElement;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.ProcessingInstruction;
import net.sf.saxon.expr.instruct.UserFunctionParameter;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.expr.sort.IntSet;
import net.sf.saxon.expr.sort.IntUniversalSet;
import net.sf.saxon.expr.sort.SortKeyDefinition;
import net.sf.saxon.functions.StandardFunction;
import net.sf.saxon.lib.NamespaceConstant;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.LocalNameTest;
import net.sf.saxon.pattern.NamespaceTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.query.GlobalVariableDefinition;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;
import org.apache.commons.lang.StringUtils;

public class SaxonTranslator {
    public static final String CODEPOINT_COLLATION = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    private Configuration config;
    private HashMap<String, String> namespaceDeclarations;
    private static final HashMap<String, ExprClass> dispatcher = new HashMap();
    private QueryModule queryModule;
    private ItemType lastTypeSeen;
    private static final StructuredQName itemAtQName;
    private static /* synthetic */ int[] $SWITCH_TABLE$lux$compiler$SaxonTranslator$ExprClass;

    static {
        ExprClass[] exprClassArray = ExprClass.values();
        int n = exprClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExprClass eclass = exprClassArray[n2];
            dispatcher.put(eclass.toString(), eclass);
            ++n2;
        }
        itemAtQName = new StructuredQName("", "http://saxon.sf.net/", "item-at");
    }

    public SaxonTranslator(Configuration config) {
        this.config = config;
        this.namespaceDeclarations = new HashMap();
    }

    public XQuery queryFor(XQueryExecutable xquery) {
        XQueryExpression saxonQuery = xquery.getUnderlyingCompiledQuery();
        this.queryModule = saxonQuery.getStaticContext();
        Iterator moduleIter = this.queryModule.getExecutable().getQueryLibraryModules();
        ArrayList<ModuleImport> importedModules = new ArrayList<ModuleImport>();
        while (moduleIter.hasNext()) {
            QueryModule importedModule = (QueryModule)moduleIter.next();
            String moduleNamespace = importedModule.getModuleNamespace();
            String prefix = this.getPrefixForNamespace(moduleNamespace);
            if (StringUtils.isBlank((String)prefix)) continue;
            importedModules.add(new ModuleImport(prefix, moduleNamespace, importedModule.getSystemId()));
        }
        this.initializeNamespaces(saxonQuery);
        FunctionDefinition[] functionDefinitions = this.getFunctionDefinitions();
        AbstractExpression body = this.exprFor(saxonQuery.getExpression());
        String defaultCollation = this.queryModule.getDefaultCollationName();
        if (defaultCollation.equals(CODEPOINT_COLLATION)) {
            defaultCollation = null;
        }
        VariableDefinition[] variableDefinitions = this.getVariableDefinitions(this.queryModule);
        Boolean isPreserveNamespaces = (Boolean)this.config.getConfigurationProperty("http://saxon.sf.net/feature/xqueryPreserveNamespaces");
        Boolean isInheritNamespaces = (Boolean)this.config.getConfigurationProperty("http://saxon.sf.net/feature/xqueryInheritNamespaces");
        if (this.queryModule.isPreserveNamespaces() == isPreserveNamespaces.booleanValue() && this.queryModule.isInheritNamespaces() == isInheritNamespaces.booleanValue()) {
            isInheritNamespaces = null;
            isPreserveNamespaces = null;
        } else {
            isPreserveNamespaces = this.queryModule.isPreserveNamespaces();
            isInheritNamespaces = this.queryModule.isInheritNamespaces();
        }
        return new XQuery(this.queryModule.getDefaultElementNamespace(), this.queryModule.getDefaultFunctionNamespace(), defaultCollation, importedModules.toArray(new ModuleImport[importedModules.size()]), this.getNamespaceDeclarations(), variableDefinitions, functionDefinitions, body, this.queryModule.getBaseURI(), isPreserveNamespaces, isInheritNamespaces, this.queryModule.isEmptyLeast());
    }

    private void initializeNamespaces(XQueryExpression saxonQuery) {
        this.namespaceDeclarations.clear();
        NamespaceResolver ns = saxonQuery.getStaticContext().getNamespaceResolver();
        Iterator prefixes = ns.iteratePrefixes();
        while (prefixes.hasNext()) {
            String prefix = (String)prefixes.next();
            String nsURI = ns.getURIForPrefix(prefix, false);
            if (NamespaceConstant.isReservedInQuery((String)nsURI) || prefix.equals("saxon") && nsURI.equals("http://saxon.sf.net/") || prefix.equals("local") && nsURI.equals("http://www.w3.org/2005/xquery-local-functions") || prefix.equals("err") && nsURI.equals("http://www.w3.org/2005/xqt-errors") || prefix.equals("lux") && nsURI.equals("http://luxdb.net")) continue;
            this.namespaceDeclarations.put(prefix, nsURI);
        }
    }

    private Namespace[] getNamespaceDeclarations() {
        Namespace[] decls = new Namespace[this.namespaceDeclarations.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : this.namespaceDeclarations.entrySet()) {
            decls[i++] = new Namespace(entry.getKey(), entry.getValue());
        }
        return decls;
    }

    private VariableDefinition[] getVariableDefinitions(QueryModule module) {
        ArrayList<VariableDefinition> defs = new ArrayList<VariableDefinition>();
        Iterator decls = module.getModuleVariables();
        while (decls.hasNext()) {
            GlobalVariableDefinition decl = (GlobalVariableDefinition)decls.next();
            GlobalVariable global = decl.getCompiledVariable();
            String typeDesc = this.getTypeDescription(decl.getRequiredType());
            Variable var = global != null ? (Variable)this.exprFor(global) : new Variable(this.qnameFor(decl.getVariableQName()));
            int order = decl.getLineNumber() * 1000000 + decl.getColumnNumber();
            VariableDefinition def = new VariableDefinition(var, this.exprFor(decl.getValueExpression()), typeDesc, order);
            defs.add(def);
        }
        Object[] orderedDefs = defs.toArray(new VariableDefinition[0]);
        Arrays.sort(orderedDefs);
        return orderedDefs;
    }

    private void addNamespaceDeclaration(QName qname) {
        String prefix = qname.getPrefix();
        String namespaceURI = qname.getNamespaceURI();
        if (!this.namespaceDeclarations.containsKey(prefix)) {
            this.namespaceDeclarations.put(prefix, namespaceURI);
        }
    }

    private FunctionDefinition[] getFunctionDefinitions() {
        ArrayList<FunctionDefinition> functionDefinitions = new ArrayList<FunctionDefinition>();
        Iterator functions = this.queryModule.getLocalFunctionLibrary().getFunctionDefinitions();
        while (functions.hasNext()) {
            XQueryFunction function = (XQueryFunction)functions.next();
            UserFunctionParameter[] params = function.getParameterDefinitions();
            Variable[] args = new Variable[params.length];
            int i = 0;
            while (i < params.length) {
                QName argname = this.qnameFor(params[i].getVariableQName());
                this.addNamespaceDeclaration(argname);
                args[i] = new Variable(argname, this.getTypeDescription(params[i].getRequiredType()));
                ++i;
            }
            QName fname = this.qnameFor(function.getFunctionName());
            this.addNamespaceDeclaration(fname);
            SequenceType resultType = function.getResultType();
            FunctionDefinition fdef = new FunctionDefinition(fname, this.valueTypeForItemType(resultType.getPrimaryType()), SaxonTranslator.cardinalityOf(resultType), args, this.exprFor(function.getBody()));
            functionDefinitions.add(fdef);
        }
        FunctionDefinition[] defs = functionDefinitions.toArray(new FunctionDefinition[0]);
        return defs;
    }

    private String getTypeDescription(SequenceType sequenceType) {
        String typeDesc;
        if (sequenceType == null) {
            return null;
        }
        ItemType itemType = sequenceType.getPrimaryType();
        if (itemType.isAtomicType()) {
            typeDesc = sequenceType.toString();
        } else {
            typeDesc = itemType.getPrimitiveItemType().toString();
            int cardinality = sequenceType.getCardinality();
            if (cardinality == 49152) {
                typeDesc = String.valueOf(typeDesc) + '+';
            } else if (cardinality == 57344) {
                typeDesc = String.valueOf(typeDesc) + '*';
            } else if (cardinality == 24576) {
                typeDesc = String.valueOf(typeDesc) + '?';
            }
        }
        return typeDesc;
    }

    public AbstractExpression exprFor(AtomicSequenceConverter atomizer) {
        ItemType type;
        ItemType itemType = type = atomizer.isAllItemsConverted() || this.lastTypeSeen == null ? atomizer.getItemType(this.config.getTypeHierarchy()) : this.lastTypeSeen;
        if (!type.isAtomicType()) {
            throw new LuxException("AtomicSequenceConverter converting to non-atomic type: " + type);
        }
        AtomicType atomicType = (AtomicType)type;
        Variable var = new Variable(new QName("x"));
        return new FLWOR(this.castExprFor(var, atomicType), new lux.xquery.ForClause(var, null, this.exprFor(atomizer.getBaseExpression())));
    }

    private QName qnameFor(AtomicType type) {
        if (type.isBuiltInType()) {
            return this.qnameFor(((BuiltInAtomicType)type).getQualifiedName());
        }
        return this.qnameForNameCode(type.getNameCode());
    }

    public AbstractExpression exprFor(Atomizer atomizer) {
        Expression base = atomizer.getBaseExpression();
        return new FunCall(FunCall.FN_DATA, ValueType.ATOMIC, this.exprFor(base));
    }

    public AbstractExpression exprFor(AxisExpression expr) {
        PathStep.Axis axis;
        switch (expr.getAxis()) {
            case 0: {
                axis = PathStep.Axis.Ancestor;
                break;
            }
            case 9: {
                axis = PathStep.Axis.Parent;
                break;
            }
            case 4: {
                axis = PathStep.Axis.Descendant;
                break;
            }
            case 10: {
                axis = PathStep.Axis.Preceding;
                break;
            }
            case 6: {
                axis = PathStep.Axis.Following;
                break;
            }
            case 12: {
                axis = PathStep.Axis.Self;
                break;
            }
            case 11: {
                axis = PathStep.Axis.PrecedingSibling;
                break;
            }
            case 7: {
                axis = PathStep.Axis.FollowingSibling;
                break;
            }
            case 1: {
                axis = PathStep.Axis.AncestorSelf;
                break;
            }
            case 5: {
                axis = PathStep.Axis.DescendantSelf;
                break;
            }
            case 2: {
                axis = PathStep.Axis.Attribute;
                break;
            }
            case 3: {
                axis = PathStep.Axis.Child;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported axis in expression: " + expr.toString());
            }
        }
        AbstractExpression ae = this.exprFor(axis, expr.getNodeTest());
        return ae;
    }

    private BinaryOperation exprFor(PathStep.Axis axis, CombinedNodeTest nodeTest) {
        CombinedNodeTest combinedNodeTest = nodeTest;
        NodeTest[] tests = combinedNodeTest.getComponentNodeTests();
        BinaryOperation.Operator op = SaxonTranslator.operatorFor(combinedNodeTest.getOperator());
        return new BinaryOperation(this.exprFor(axis, tests[0]), op, this.exprFor(axis, tests[1]));
    }

    private lux.xpath.NodeTest nodeTestFor(DocumentNodeTest nodeTest) {
        NodeTest elementTest = nodeTest.getElementTest();
        int nameCode = elementTest.getFingerprint();
        return new lux.xpath.NodeTest(ValueType.DOCUMENT, this.qnameForNameCode(nameCode));
    }

    private QName qnameForNameCode(int nameCode) {
        StructuredQName sqname = this.config.getNamePool().getStructuredQName(nameCode);
        String prefix = sqname.getPrefix();
        String namespace = sqname.getURI();
        if (StringUtils.isBlank((String)prefix) && StringUtils.isNotBlank((String)namespace)) {
            prefix = this.getPrefixForNamespace(namespace);
        }
        QName name = new QName(namespace, sqname.getLocalPart(), prefix);
        return name;
    }

    public AbstractExpression exprFor(PathStep.Axis axis, NodeTest nodeTest) {
        if (nodeTest != null && nodeTest instanceof CombinedNodeTest) {
            return this.exprFor(axis, (CombinedNodeTest)nodeTest);
        }
        return new PathStep(axis, this.nodeTestFor(nodeTest));
    }

    private lux.xpath.NodeTest nodeTestFor(NodeTest nodeTest) {
        if (nodeTest == null) {
            return new lux.xpath.NodeTest(ValueType.NODE);
        }
        if (nodeTest instanceof DocumentNodeTest) {
            return this.nodeTestFor((DocumentNodeTest)nodeTest);
        }
        int nameCode = nodeTest.getFingerprint();
        ValueType nodeType = this.valueTypeForItemType((ItemType)nodeTest);
        if (nameCode >= 0) {
            return new lux.xpath.NodeTest(nodeType, this.qnameForNameCode(nameCode));
        }
        if (nodeTest instanceof LocalNameTest) {
            return new lux.xpath.NodeTest(nodeType, new QName(null, ((LocalNameTest)nodeTest).getLocalName(), "*"));
        }
        if (nodeTest instanceof NamespaceTest) {
            NamespaceTest namespaceTest = (NamespaceTest)nodeTest;
            String namespace = namespaceTest.getNamespaceURI();
            String prefix = this.getPrefixForNamespace(namespace);
            QName qname = new QName(namespace, "*", prefix);
            this.addNamespaceDeclaration(qname);
            return new lux.xpath.NodeTest(nodeType, qname);
        }
        IntSet nameCodes = nodeTest.getRequiredNodeNames();
        if (nameCodes == IntUniversalSet.getInstance()) {
            return new lux.xpath.NodeTest(nodeType);
        }
        throw new IllegalArgumentException("Unsupported node test: " + nodeTest.toString());
    }

    private String getPrefixForNamespace(String namespace) {
        String prefix = this.config.getNamePool().suggestPrefixForURI(namespace);
        if (prefix == null && this.queryModule != null) {
            NamespaceResolver resolver = this.queryModule.getNamespaceResolver();
            Iterator prefixes = resolver.iteratePrefixes();
            while (prefixes.hasNext()) {
                String p = (String)prefixes.next();
                if (!namespace.equals(resolver.getURIForPrefix(p, true))) continue;
                prefix = p;
                break;
            }
        }
        if (prefix != null) {
            this.namespaceDeclarations.put(prefix, namespace);
        } else {
            for (Map.Entry<String, String> ns : this.namespaceDeclarations.entrySet()) {
                if (!ns.getValue().equals(namespace)) continue;
                return ns.getKey();
            }
            prefix = "";
        }
        return prefix;
    }

    public AbstractExpression exprFor(BinaryExpression expr) {
        Expression[] operands = expr.getOperands();
        BinaryOperation.Operator op = SaxonTranslator.operatorFor(expr.getOperator());
        if (operands[0] instanceof AtomicSequenceConverter || operands[1] instanceof AtomicSequenceConverter) {
            op = SaxonTranslator.generalizeOperator(op);
        }
        return new BinaryOperation(this.exprFor(operands[0]), op, this.exprFor(operands[1]));
    }

    private static BinaryOperation.Operator generalizeOperator(BinaryOperation.Operator op) {
        switch (op) {
            case AEQ: {
                return BinaryOperation.Operator.EQUALS;
            }
            case ANE: {
                return BinaryOperation.Operator.NE;
            }
            case ALT: {
                return BinaryOperation.Operator.LT;
            }
            case ALE: {
                return BinaryOperation.Operator.LE;
            }
            case AGT: {
                return BinaryOperation.Operator.GT;
            }
            case AGE: {
                return BinaryOperation.Operator.GE;
            }
        }
        return op;
    }

    private static BinaryOperation.Operator operatorFor(int op) {
        switch (op) {
            case 10: {
                return BinaryOperation.Operator.AND;
            }
            case 9: {
                return BinaryOperation.Operator.OR;
            }
            case 23: {
                return BinaryOperation.Operator.INTERSECT;
            }
            case 24: {
                return BinaryOperation.Operator.EXCEPT;
            }
            case 1: {
                return BinaryOperation.Operator.UNION;
            }
            case 15: {
                return BinaryOperation.Operator.ADD;
            }
            case 16: {
                return BinaryOperation.Operator.SUB;
            }
            case 17: {
                return BinaryOperation.Operator.MUL;
            }
            case 18: {
                return BinaryOperation.Operator.DIV;
            }
            case 56: {
                return BinaryOperation.Operator.IDIV;
            }
            case 19: {
                return BinaryOperation.Operator.MOD;
            }
            case 6: {
                return BinaryOperation.Operator.EQUALS;
            }
            case 22: {
                return BinaryOperation.Operator.NE;
            }
            case 12: {
                return BinaryOperation.Operator.LT;
            }
            case 11: {
                return BinaryOperation.Operator.GT;
            }
            case 14: {
                return BinaryOperation.Operator.LE;
            }
            case 13: {
                return BinaryOperation.Operator.GE;
            }
            case 50: {
                return BinaryOperation.Operator.AEQ;
            }
            case 51: {
                return BinaryOperation.Operator.ANE;
            }
            case 53: {
                return BinaryOperation.Operator.ALT;
            }
            case 55: {
                return BinaryOperation.Operator.ALE;
            }
            case 52: {
                return BinaryOperation.Operator.AGT;
            }
            case 54: {
                return BinaryOperation.Operator.AGE;
            }
            case 20: {
                return BinaryOperation.Operator.IS;
            }
            case 38: {
                return BinaryOperation.Operator.BEFORE;
            }
            case 39: {
                return BinaryOperation.Operator.AFTER;
            }
            case 29: {
                return BinaryOperation.Operator.TO;
            }
            case 299: {
                return BinaryOperation.Operator.SUB;
            }
        }
        throw new IllegalArgumentException("Unsupported operator: " + op);
    }

    public AbstractExpression exprFor(Block expr) {
        return this.exprFor(expr.getChildren());
    }

    public AbstractExpression exprFor(CastExpression expr) {
        Expression base = expr.getBaseExpression();
        AtomicType type = expr.getTargetType();
        return this.castExprFor(this.exprFor(base), type);
    }

    public AbstractExpression exprFor(CastableExpression expr) {
        Expression base = expr.getBaseExpression();
        AtomicType type = expr.getTargetType();
        return new lux.xquery.CastableExpression(this.exprFor(base), type.toString());
    }

    private AbstractExpression castExprFor(AbstractExpression ae, AtomicType type) {
        if (type.isAbstract()) {
            return ae;
        }
        return new FunCall(this.qnameFor(type), this.valueTypeForItemType((ItemType)type), ae);
    }

    public AbstractExpression exprFor(ItemChecker checker) {
        Expression base = checker.getBaseExpression();
        ItemType type = checker.getRequiredType();
        ItemType previousLastTypeSeen = this.lastTypeSeen;
        this.lastTypeSeen = type;
        ValueType valueType = this.valueTypeForItemType(type);
        int cardinality = checker.getCardinality();
        String occurrence = cardinality == 8192 ? "" : Cardinality.getOccurrenceIndicator((int)cardinality);
        AbstractExpression baseExpr = this.exprFor(base);
        this.lastTypeSeen = previousLastTypeSeen;
        if (valueType.isNode) {
            return new TreatAs(baseExpr, this.nodeTestFor((NodeTest)type), occurrence);
        }
        return new TreatAs(baseExpr, valueType, occurrence);
    }

    private Sequence exprFor(Expression[] exprs) {
        AbstractExpression[] aex = new AbstractExpression[exprs.length];
        int i = 0;
        while (i < exprs.length) {
            aex[i] = this.exprFor(exprs[i]);
            ++i;
        }
        return new Sequence(aex);
    }

    public AbstractExpression exprFor(Choose choose) {
        Expression[] conds = choose.getConditions();
        Expression[] actions = choose.getActions();
        int l = conds.length;
        if (actions.length != conds.length) {
            throw new LuxException("Choose must have the same number of actions as conditions");
        }
        if (l < 2) {
            return new Conditional(this.exprFor(conds[0]), this.exprFor(actions[0]), LiteralExpression.EMPTY);
        }
        Conditional tail = new Conditional(this.exprFor(conds[l -= 2]), this.exprFor(actions[l]), this.exprFor(actions[l + 1]));
        while (l-- > 0) {
            tail = new Conditional(this.exprFor(conds[l]), this.exprFor(actions[l]), tail);
        }
        return tail;
    }

    public AbstractExpression exprFor(Comment expr) {
        return new CommentConstructor(this.exprFor(expr.getContentExpression()));
    }

    public AbstractExpression exprFor(ComputedAttribute expr) {
        return new AttributeConstructor(this.exprFor(expr.getNameExpression()), this.exprFor(expr.getContentExpression()));
    }

    public AbstractExpression exprFor(ComputedElement expr) {
        return new ComputedElementConstructor(this.exprFor(expr.getNameExpression()), this.exprFor(expr.getContentExpression()));
    }

    public AbstractExpression exprFor(ContextItemExpression expr) {
        return Dot.getInstance();
    }

    private AbstractExpression exprFor(CopyOf expr) {
        return this.exprFor(expr.getSelectExpression());
    }

    public AbstractExpression exprFor(DocumentInstr documentInstr) {
        return new DocumentConstructor(this.exprFor(documentInstr.getContentExpression()));
    }

    public AbstractExpression exprFor(FilterExpression expr) {
        AbstractExpression filtered = this.exprFor(expr.getControllingExpression());
        AbstractExpression filter = this.exprFor(expr.getFilter());
        return new Predicate(filtered, filter);
    }

    public AbstractExpression exprFor(FirstItemExpression expr) {
        return new Subsequence(this.exprFor(expr.getBaseExpression()), LiteralExpression.ONE, LiteralExpression.ONE);
    }

    public AbstractExpression exprFor(FixedAttribute attribute) {
        NodeName name = attribute.getAttributeName();
        QName qname = this.qnameFor(name.getStructuredQName());
        AttributeConstructor att = new AttributeConstructor(new LiteralExpression(qname.toString(), ValueType.STRING), this.exprFor(attribute.getContentExpression()));
        return att;
    }

    public AbstractExpression exprFor(FixedElement element) {
        NodeName name = element.getElementName();
        QName qname = this.qnameFor(name.getStructuredQName());
        AbstractExpression content = this.exprFor(element.getContentExpression());
        Namespace[] namespaces = this.namespacesFor(element.getActiveNamespaces());
        ElementConstructor elcon = new ElementConstructor(qname, namespaces, content, new AttributeConstructor[0]);
        return elcon;
    }

    public AbstractExpression exprFor(ForExpression forExpr) {
        StructuredQName var = forExpr.getVariableQName();
        Expression seq = forExpr.getSequence();
        Expression returns = forExpr.getAction();
        PositionVariable posvar = forExpr.getPositionVariable();
        Variable pos = null;
        if (posvar != null) {
            pos = new Variable(this.qnameFor(posvar.getVariableQName()));
        }
        return new FLWOR(this.exprFor(returns), new lux.xquery.ForClause(new Variable(this.qnameFor(var)), pos, this.exprFor(seq)));
    }

    public AbstractExpression exprFor(FunctionCall funcall) {
        if (funcall.getFunctionName().equals((Object)itemAtQName)) {
            return new Subsequence(this.exprFor(funcall.getArguments()[0]), this.exprFor(funcall.getArguments()[1]), LiteralExpression.ONE);
        }
        if (this.functionEqualsBuiltin(funcall, "reverse")) {
            Expression arg = funcall.getArguments()[0];
            if ((arg.getSpecialProperties() & 0x40000) != 0 || !Cardinality.allowsMany((int)arg.getCardinality())) {
                return new Sequence(this.exprFor(arg));
            }
        } else if (this.functionEqualsBuiltin(funcall, "subsequence")) {
            if (funcall.getNumberOfArguments() == 2) {
                return new Subsequence(this.exprFor(funcall.getArguments()[0]), this.exprFor(funcall.getArguments()[1]));
            }
            if (funcall.getNumberOfArguments() != 3) {
                throw new LuxException("call to subsequence has " + funcall.getNumberOfArguments() + " arguments?");
            }
            return new Subsequence(this.exprFor(funcall.getArguments()[0]), this.exprFor(funcall.getArguments()[1]), this.exprFor(funcall.getArguments()[2]));
        }
        Expression[] args = funcall.getArguments();
        AbstractExpression[] aargs = new AbstractExpression[args.length];
        int i = 0;
        while (i < args.length) {
            aargs[i] = this.exprFor(args[i]);
            ++i;
        }
        StandardFunction.Entry entry = StandardFunction.getFunction((String)funcall.getFunctionName().getDisplayName(), (int)aargs.length);
        ValueType returnType = entry != null ? this.valueTypeForItemType(entry.itemType) : ValueType.VALUE;
        QName fnQName = this.qnameFor(funcall.getFunctionName());
        if (this.functionEqualsBuiltin(funcall, "root") || fnQName.equals(FunCall.LUX_SEARCH)) {
            returnType = ValueType.DOCUMENT;
        }
        return new FunCall(this.qnameFor(funcall.getFunctionName()), returnType, aargs);
    }

    private boolean functionEqualsBuiltin(FunctionCall funcall, String builtinFunction) {
        return funcall.getFunctionName().getDisplayName().equals(builtinFunction);
    }

    public AbstractExpression exprFor(GlobalVariable var) {
        return new Variable(this.qnameFor(var.getVariableQName()));
    }

    public AbstractExpression exprFor(IntegerRangeTest rangeTest) {
        return new BinaryOperation(new BinaryOperation(this.exprFor(rangeTest.getValueExpression()), BinaryOperation.Operator.ALE, this.exprFor(rangeTest.getMaxValueExpression())), BinaryOperation.Operator.AND, new BinaryOperation(this.exprFor(rangeTest.getValueExpression()), BinaryOperation.Operator.AGE, this.exprFor(rangeTest.getMinValueExpression())));
    }

    private AbstractExpression exprFor(InstanceOfExpression expr) {
        String typeExpr;
        ItemType type = expr.getRequiredItemType();
        if (type.isPlainType()) {
            typeExpr = type.toString();
        } else if (type instanceof NodeTest) {
            lux.xpath.NodeTest nodeTest = this.nodeTestFor((NodeTest)type);
            typeExpr = nodeTest.toString();
        } else {
            throw new LuxException("Unsupported node test in instance-of expression: " + expr.toString());
        }
        return new InstanceOf(typeExpr, this.exprFor(expr.getBaseExpression()));
    }

    private ValueType valueTypeForItemType(ItemType itemType) {
        if (itemType.isAtomicType()) {
            switch (itemType.getPrimitiveType()) {
                case 513: 
                case 529: {
                    return ValueType.STRING;
                }
                case 521: {
                    return ValueType.DATE;
                }
                case 519: {
                    return ValueType.DATE_TIME;
                }
                case 523: {
                    return ValueType.YEAR;
                }
                case 522: {
                    return ValueType.YEAR_MONTH;
                }
                case 526: {
                    return ValueType.MONTH;
                }
                case 525: {
                    return ValueType.DAY;
                }
                case 524: {
                    return ValueType.MONTH_DAY;
                }
                case 537: {
                    return ValueType.INT;
                }
                case 533: {
                    if (itemType.equals(BuiltInAtomicType.INT)) {
                        return ValueType.INT;
                    }
                    return ValueType.INTEGER;
                }
                case 517: {
                    return ValueType.DOUBLE;
                }
                case 516: {
                    return ValueType.FLOAT;
                }
                case 515: {
                    return ValueType.DECIMAL;
                }
                case 514: {
                    return ValueType.BOOLEAN;
                }
                case 520: {
                    return ValueType.TIME;
                }
                case 527: {
                    return ValueType.HEX_BINARY;
                }
                case 528: {
                    return ValueType.BASE64_BINARY;
                }
                case 631: {
                    return ValueType.UNTYPED_ATOMIC;
                }
                case 530: {
                    return ValueType.QNAME;
                }
            }
            return ValueType.ATOMIC;
        }
        if (itemType instanceof NodeTest) {
            NodeTest nodeTest = (NodeTest)itemType;
            switch (nodeTest.getPrimitiveType()) {
                case 0: {
                    return ValueType.NODE;
                }
                case 1: {
                    return ValueType.ELEMENT;
                }
                case 3: {
                    return ValueType.TEXT;
                }
                case 2: {
                    return ValueType.ATTRIBUTE;
                }
                case 9: {
                    return ValueType.DOCUMENT;
                }
                case 7: {
                    return ValueType.PROCESSING_INSTRUCTION;
                }
                case 8: {
                    return ValueType.COMMENT;
                }
                case 15: {
                    return ValueType.EMPTY;
                }
            }
        }
        return ValueType.VALUE;
    }

    public AbstractExpression exprFor(LastItemExpression expr) {
        return new Subsequence(this.exprFor(expr.getBaseExpression()), FunCall.LastExpression, LiteralExpression.ONE);
    }

    public AbstractExpression exprFor(LetExpression let) {
        StructuredQName var = let.getVariableQName();
        Expression seq = let.getSequence();
        Expression returns = let.getAction();
        return new FLWOR(this.exprFor(returns), new LetClause(new Variable(this.qnameFor(var), this.getTypeDescription(let.getRequiredType())), this.exprFor(seq)));
    }

    public AbstractExpression exprFor(Literal literal) {
        Value value = literal.getValue();
        try {
            int len = value.getLength();
            if (len == 0) {
                return LiteralExpression.EMPTY;
            }
            SequenceIterator iter = value.iterate();
            if (len > 1) {
                Item member;
                ArrayList<LiteralExpression> items = new ArrayList<LiteralExpression>();
                while ((member = iter.next()) != null) {
                    if (member instanceof AtomicValue) {
                        items.add(this.exprFor((AtomicValue)member));
                        continue;
                    }
                    throw new LuxException("unsupported node in a literal sequence: " + literal.toString());
                }
                return new Sequence(items.toArray(new LiteralExpression[0]));
            }
            return this.exprFor((AtomicValue)iter.next());
        }
        catch (XPathException e) {
            throw new LuxException(e);
        }
    }

    public LiteralExpression exprFor(AtomicValue value) {
        ValueType type = this.valueTypeForItemType(value.getItemType(this.config.getTypeHierarchy()));
        if (value instanceof CalendarValue || value instanceof DurationValue || value instanceof BigIntegerValue) {
            return new LiteralExpression(value.getStringValue(), type);
        }
        if (value instanceof QNameValue) {
            return new LiteralExpression(this.qnameFor(((QNameValue)value).getStructuredQName()), type);
        }
        try {
            Object oval = Value.convertToJava((Item)value.asItem());
            return new LiteralExpression(oval, type);
        }
        catch (XPathException e) {
            throw new LuxException(e);
        }
    }

    public AbstractExpression exprFor(NegateExpression expr) {
        return new UnaryMinus(this.exprFor(expr.getBaseExpression()));
    }

    public AbstractExpression exprFor(ParentNodeExpression expr) {
        return new PathStep(PathStep.Axis.Parent, new lux.xpath.NodeTest(ValueType.NODE));
    }

    public AbstractExpression exprFor(ProcessingInstruction pi) {
        return new ProcessingInstructionConstructor(this.exprFor(pi.getNameExpression()), this.exprFor(pi.getContentExpression()));
    }

    public AbstractExpression exprFor(QuantifiedExpression expr) {
        Satisfies.Quantifier quantifier = expr.getOperator() == 32 ? Satisfies.Quantifier.SOME : Satisfies.Quantifier.EVERY;
        return new Satisfies(quantifier, new Variable(this.qnameFor(expr.getVariableQName())), this.exprFor(expr.getSequence()), this.exprFor(expr.getAction()));
    }

    public AbstractExpression exprFor(RootExpression expr) {
        return new Root();
    }

    public AbstractExpression exprFor(SlashExpression expr) {
        AbstractExpression lq = this.exprFor(expr.getControllingExpression());
        AbstractExpression rq = this.exprFor(expr.getControlledExpression());
        return new PathExpression(lq, rq);
    }

    public AbstractExpression exprFor(TailExpression expr) {
        return new Subsequence(this.exprFor(expr.getBaseExpression()), new LiteralExpression(expr.getStart()));
    }

    public AbstractExpression exprFor(TailCallLoop expr) {
        return this.exprFor(expr.getBaseExpression());
    }

    public AbstractExpression exprFor(UnaryExpression expr) {
        return this.exprFor(expr.getBaseExpression());
    }

    public AbstractExpression exprFor(ValueOf valueOf) {
        return new TextConstructor(this.exprFor(valueOf.getContentExpression()));
    }

    public AbstractExpression exprFor(VariableReference var) {
        if (var.getBinding() != null) {
            StructuredQName varName = var.getBinding().getVariableQName();
            return new Variable(this.qnameFor(varName));
        }
        try {
            Expression o = var.optimize(null, null);
            if (o instanceof Literal) {
                return this.exprFor((Literal)o);
            }
        }
        catch (XPathException e) {
            throw new LuxException("Unsupported variable reference: " + var);
        }
        throw new LuxException("Unsupported variable reference: " + var);
    }

    private QName qnameFor(StructuredQName name) {
        QName qname = new QName(name.getNamespaceBinding().getURI(), name.getLocalPart(), name.getNamespaceBinding().getPrefix());
        if (!(qname.getPrefix().equals("fn") && qname.getNamespaceURI().equals("http://www.w3.org/2005/xpath-functions") || qname.getPrefix().equals("local") && qname.getNamespaceURI().equals("http://www.w3.org/2005/xquery-local-functions") || qname.getPrefix().equals("xs") && qname.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema"))) {
            this.addNamespaceDeclaration(qname);
        }
        return qname;
    }

    public AbstractExpression exprFor(CompareToIntegerConstant comp) {
        BinaryOperation.Operator op = SaxonTranslator.operatorFor(comp.getComparisonOperator());
        long num = comp.getComparand();
        return new BinaryOperation(this.exprFor(comp.getOperand()), op, new LiteralExpression(num));
    }

    private Namespace[] namespacesFor(NamespaceBinding[] activeNamespaces) {
        if (activeNamespaces == null) {
            return null;
        }
        Namespace[] namespaces = new Namespace[activeNamespaces.length];
        int i = 0;
        NamespaceBinding[] namespaceBindingArray = activeNamespaces;
        int n = activeNamespaces.length;
        int n2 = 0;
        while (n2 < n) {
            NamespaceBinding binding = namespaceBindingArray[n2];
            namespaces[i++] = new Namespace(binding.getPrefix(), binding.getURI());
            ++n2;
        }
        return namespaces;
    }

    public AbstractExpression exprFor(FLWORExpression flwor) {
        int j;
        FLWORClause[] clauses;
        List saxonClauses = flwor.getClauseList();
        int i = 0;
        while (i < saxonClauses.size() && ((Clause)saxonClauses.get(i)).getClauseKey() == 6) {
            ++i;
        }
        int k = 0;
        if (i < saxonClauses.size()) {
            clauses = new FLWORClause[saxonClauses.size()];
            j = i;
            while (j < saxonClauses.size() && ((Clause)saxonClauses.get(j)).getClauseKey() != 5) {
                clauses[k++] = this.clauseFor((Clause)saxonClauses.get(j));
                ++j;
            }
        } else {
            clauses = new FLWORClause[saxonClauses.size() + 1];
        }
        if (k == 0) {
            clauses[k++] = new LetClause(new Variable(new QName("x")), LiteralExpression.ONE);
        }
        if (i > 0) {
            j = 0;
            while (j < i) {
                clauses[k++] = this.clauseFor((Clause)saxonClauses.get(j));
                ++j;
            }
        }
        while (k < saxonClauses.size()) {
            clauses[k] = this.clauseFor((Clause)saxonClauses.get(k));
            ++k;
        }
        return new FLWOR(this.exprFor(flwor.getReturnClause()), clauses);
    }

    private FLWORClause clauseFor(Clause clause) {
        switch (clause.getClauseKey()) {
            case 1: {
                return this.clauseFor((net.sf.saxon.expr.flwor.LetClause)clause);
            }
            case 0: {
                return this.clauseFor((ForClause)clause);
            }
            case 6: {
                return this.clauseFor((WhereClause)clause);
            }
            case 5: {
                return this.clauseFor((net.sf.saxon.expr.flwor.OrderByClause)clause);
            }
        }
        throw new LuxException("Unsupported FLWOR clause " + clause.getClass().getSimpleName());
    }

    private FLWORClause clauseFor(ForClause clause) {
        AbstractExpression seq = this.exprFor(clause.getSequence());
        Variable var = new Variable(this.qnameFor(clause.getRangeVariable().getVariableQName()));
        LocalVariableBinding positionVariable = clause.getPositionVariable();
        Variable pos = positionVariable != null ? new Variable(this.qnameFor(positionVariable.getVariableQName())) : null;
        return new lux.xquery.ForClause(var, pos, seq);
    }

    private FLWORClause clauseFor(net.sf.saxon.expr.flwor.LetClause clause) {
        AbstractExpression seq = this.exprFor(clause.getSequence());
        Variable var = new Variable(this.qnameFor(clause.getRangeVariable().getVariableQName()));
        return new LetClause(var, seq);
    }

    private FLWORClause clauseFor(WhereClause clause) {
        return new lux.xquery.WhereClause(this.exprFor(clause.getPredicate()));
    }

    private FLWORClause clauseFor(net.sf.saxon.expr.flwor.OrderByClause clause) {
        SortKeyDefinition[] sortKeyDefs = clause.getSortKeyDefinitions();
        SortKey[] sortKeys = new SortKey[sortKeyDefs.length];
        int i = 0;
        while (i < sortKeyDefs.length) {
            sortKeys[i] = this.sortKeyFor(sortKeyDefs[i]);
            ++i;
        }
        return new OrderByClause(sortKeys);
    }

    private SortKey sortKeyFor(SortKeyDefinition sortKeyDef) {
        return new SortKey(this.exprFor(sortKeyDef.getSortKey()), (LiteralExpression)this.exprFor(sortKeyDef.getOrder()), this.exprFor(sortKeyDef.getCollationNameExpression()), sortKeyDef.getEmptyLeast());
    }

    private static int cardinalityOf(SequenceType type) {
        int cardinality = type.getCardinality();
        if (cardinality == 49152) {
            return 3;
        }
        if (cardinality == 57344) {
            return 4;
        }
        if (cardinality == 24576) {
            return 2;
        }
        if (cardinality == 16384) {
            return 1;
        }
        return 0;
    }

    public AbstractExpression exprFor(Expression expr) {
        if (expr == null) {
            return null;
        }
        Enum exprClass = null;
        Class<?> cls = expr.getClass();
        while (exprClass == null && cls != Object.class) {
            exprClass = dispatcher.get(cls.getSimpleName());
            cls = cls.getSuperclass();
        }
        if (exprClass == null) {
            throw new UnsupportedOperationException("unhandled expression type: " + expr.getClass().getSimpleName() + " in " + expr.toString());
        }
        switch (SaxonTranslator.$SWITCH_TABLE$lux$compiler$SaxonTranslator$ExprClass()[exprClass.ordinal()]) {
            case 1: {
                return this.exprFor((AtomicSequenceConverter)expr);
            }
            case 2: {
                return this.exprFor((Atomizer)expr);
            }
            case 3: {
                return this.exprFor((AxisExpression)expr);
            }
            case 4: {
                return this.exprFor((BinaryExpression)expr);
            }
            case 35: {
                return this.exprFor((Block)expr);
            }
            case 5: {
                return this.exprFor((CastExpression)expr);
            }
            case 6: {
                return this.exprFor((CastableExpression)expr);
            }
            case 36: {
                return this.exprFor((Choose)expr);
            }
            case 37: {
                return this.exprFor((Comment)expr);
            }
            case 7: {
                return this.exprFor((CompareToIntegerConstant)expr);
            }
            case 8: {
                return this.exprFor((ComputedAttribute)expr);
            }
            case 9: {
                return this.exprFor((ComputedElement)expr);
            }
            case 10: {
                return this.exprFor((ContextItemExpression)expr);
            }
            case 11: {
                return this.exprFor((CopyOf)expr);
            }
            case 38: {
                return this.exprFor((DocumentInstr)expr);
            }
            case 14: {
                return this.exprFor((FilterExpression)expr);
            }
            case 15: {
                return this.exprFor((FirstItemExpression)expr);
            }
            case 39: {
                return this.exprFor((FixedAttribute)expr);
            }
            case 40: {
                return this.exprFor((FixedElement)expr);
            }
            case 34: {
                return this.exprFor((FLWORExpression)expr);
            }
            case 16: {
                return this.exprFor((ForExpression)expr);
            }
            case 17: {
                return this.exprFor((FunctionCall)expr);
            }
            case 18: {
                return this.exprFor((InstanceOfExpression)expr);
            }
            case 19: {
                return this.exprFor((IntegerRangeTest)expr);
            }
            case 20: {
                return this.exprFor((ItemChecker)expr);
            }
            case 21: {
                return this.exprFor((LastItemExpression)expr);
            }
            case 22: {
                return this.exprFor((LetExpression)expr);
            }
            case 23: {
                return this.exprFor((Literal)expr);
            }
            case 24: {
                return this.exprFor((NegateExpression)expr);
            }
            case 26: {
                return this.exprFor((ParentNodeExpression)expr);
            }
            case 25: {
                return this.exprFor((ProcessingInstruction)expr);
            }
            case 27: {
                return this.exprFor((QuantifiedExpression)expr);
            }
            case 28: {
                return this.exprFor((RootExpression)expr);
            }
            case 29: {
                return this.exprFor((SlashExpression)expr);
            }
            case 30: {
                return this.exprFor((TailExpression)expr);
            }
            case 31: {
                return this.exprFor((ItemChecker)expr);
            }
            case 32: {
                return this.exprFor((UnaryExpression)expr);
            }
            case 42: {
                return this.exprFor((ValueOf)expr);
            }
            case 33: {
                return this.exprFor((VariableReference)expr);
            }
            case 12: {
                throw new LuxException("A potential run-time error was detected during compilation: " + ((ErrorExpression)expr).getException().getMessageAndLocation());
            }
        }
        throw new UnsupportedOperationException("unhandled expression type: " + expr.getClass().getSimpleName() + " in " + expr.toString());
    }

    static /* synthetic */ int[] $SWITCH_TABLE$lux$compiler$SaxonTranslator$ExprClass() {
        if ($SWITCH_TABLE$lux$compiler$SaxonTranslator$ExprClass != null) {
            return $SWITCH_TABLE$lux$compiler$SaxonTranslator$ExprClass;
        }
        int[] nArray = new int[ExprClass.values().length];
        try {
            nArray[ExprClass.AtomicSequenceConverter.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.Atomizer.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.AxisExpression.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.BinaryExpression.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.Block.ordinal()] = 35;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.CastExpression.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.CastableExpression.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.Choose.ordinal()] = 36;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.Comment.ordinal()] = 37;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.CompareToIntegerConstant.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.ComputedAttribute.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.ComputedElement.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.ContextItemExpression.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.CopyOf.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.DocumentInstr.ordinal()] = 38;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.ErrorExpression.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.Expression.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.FLWORExpression.ordinal()] = 34;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.FilterExpression.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.FirstItemExpression.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.FixedAttribute.ordinal()] = 39;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.FixedElement.ordinal()] = 40;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.ForExpression.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.FunctionCall.ordinal()] = 17;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.GlobalVariable.ordinal()] = 41;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.InstanceOfExpression.ordinal()] = 18;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.IntegerRangeTest.ordinal()] = 19;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.ItemChecker.ordinal()] = 20;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.LastItemExpression.ordinal()] = 21;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.LetExpression.ordinal()] = 22;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.Literal.ordinal()] = 23;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.NegateExpression.ordinal()] = 24;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.ParentNodeExpression.ordinal()] = 26;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.ProcessingInstruction.ordinal()] = 25;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.QuantifiedExpression.ordinal()] = 27;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.RootExpression.ordinal()] = 28;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.SlashExpression.ordinal()] = 29;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.TailExpression.ordinal()] = 30;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.TreatAs.ordinal()] = 31;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.UnaryExpression.ordinal()] = 32;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.ValueOf.ordinal()] = 42;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExprClass.VariableReference.ordinal()] = 33;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$lux$compiler$SaxonTranslator$ExprClass = nArray;
        return nArray;
    }

    private static enum ExprClass {
        AtomicSequenceConverter,
        Atomizer,
        AxisExpression,
        BinaryExpression,
        CastExpression,
        CastableExpression,
        CompareToIntegerConstant,
        ComputedAttribute,
        ComputedElement,
        ContextItemExpression,
        CopyOf,
        ErrorExpression,
        Expression,
        FilterExpression,
        FirstItemExpression,
        ForExpression,
        FunctionCall,
        InstanceOfExpression,
        IntegerRangeTest,
        ItemChecker,
        LastItemExpression,
        LetExpression,
        Literal,
        NegateExpression,
        ProcessingInstruction,
        ParentNodeExpression,
        QuantifiedExpression,
        RootExpression,
        SlashExpression,
        TailExpression,
        TreatAs,
        UnaryExpression,
        VariableReference,
        FLWORExpression,
        Block,
        Choose,
        Comment,
        DocumentInstr,
        FixedAttribute,
        FixedElement,
        GlobalVariable,
        ValueOf;

    }
}

